package cn.com.biz.main.entity;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/**   
 * @Title: Entity
 * @Description: 地理区域
 * @author onlineGenerator
 * @date 2014-08-27 16:44:55
 * @version V1.0   
 *
 */
@Entity
@Table(name = "t_base_area", schema = "EISP")
@SequenceGenerator(name="SEQ_GEN", sequenceName="SEQ_BASE_AREA")  
@SuppressWarnings("serial")
public class TBaseAreaEntity implements java.io.Serializable {
	/** 主键 */
	private java.lang.Integer id;
	/**区域名*/
	private java.lang.String areaname;
	/**区域编码*/
	private java.lang.String areacode;
	/**区域级别*/
	private java.lang.Integer arealevel;
	/** 上一级区域 */
	private TBaseAreaEntity TBaseAreaEntity;
	/** 下属区域 */
	private List<TBaseAreaEntity> TBaseAreaEntitys = new ArrayList<TBaseAreaEntity>();
	
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "pid")
	public TBaseAreaEntity getTBaseAreaEntity() {
		return this.TBaseAreaEntity;
	}

	public void setTBaseAreaEntity(TBaseAreaEntity tBaseAreaEntity) {
		TBaseAreaEntity = tBaseAreaEntity;
	}

	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.LAZY, mappedBy = "TBaseAreaEntity")
	public List<TBaseAreaEntity> getTBaseAreaEntitys() {
		return TBaseAreaEntitys;
	}

	public void setTBaseAreaEntitys(List<TBaseAreaEntity> tBaseAreaEntitys) {
		TBaseAreaEntitys = tBaseAreaEntitys;
	}

	/**
	 * 方法: 取得java.lang.Integer
	 * 
	 * @return: java.lang.Integer 主键
	 */
	@Id
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "SEQ_GEN")
	@Column(name = "ID", nullable = false, length = 20)
	public java.lang.Integer getId() {
		return this.id;
	}

	/**
	 * 方法: 设置java.lang.Integer
	 * 
	 * @param: java.lang.Integer 主键
	 */
	public void setId(java.lang.Integer id) {
		this.id = id;
	}

	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  区域名
	 */
	@Column(name ="AREANAME",nullable=false,length=100)
	public java.lang.String getAreaname(){
		return this.areaname;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  区域名
	 */
	public void setAreaname(java.lang.String areaname){
		this.areaname = areaname;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  区域编码
	 */
	@Column(name ="AREACODE",nullable=false,length=100)
	public java.lang.String getAreacode(){
		return this.areacode;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  区域编码
	 */
	public void setAreacode(java.lang.String areacode){
		this.areacode = areacode;
	}
	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer  区域级别
	 */
	@Column(name ="AREALEVEL",nullable=false,length=20)
	public java.lang.Integer getArealevel(){
		return this.arealevel;
	}

	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer  区域级别
	 */
	public void setArealevel(java.lang.Integer arealevel){
		this.arealevel = arealevel;
	}
}
