package cn.com.biz.main.service.impl;

import java.util.List;
import java.util.UUID;

import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.biz.main.dao.BaseAreaDao;
import cn.com.biz.main.entity.TBaseAreaEntity;
import cn.com.biz.main.help.AreaHelp;
import cn.com.biz.main.service.TBaseAreaServiceI;

@Service("tBaseAreaService")
@Transactional
public class TBaseAreaServiceImpl extends CommonServiceImpl implements TBaseAreaServiceI {
 	
	@Autowired
	private BaseAreaDao baseAreaDao;
 	/**
	 * 替换sql中的变量
	 * @param sql
	 * @return
	 */
 	public String replaceVal(String sql,TBaseAreaEntity t){
 		sql  = sql.replace("#{id}",String.valueOf(t.getId()));
 		sql  = sql.replace("#{areaname}",String.valueOf(t.getAreaname()));
 		sql  = sql.replace("#{areacode}",String.valueOf(t.getAreacode()));
 		sql  = sql.replace("#{arealevel}",String.valueOf(t.getArealevel()));
 		sql  = sql.replace("#{UUID}",UUID.randomUUID().toString());
 		return sql;
 	}

	/**
	 * 根据父ID查找下属的区域
	 * 
	 * @param pid
	 * @return
	 */
	public List<AreaHelp> getChildAreaByPid(Integer pid) {
		return baseAreaDao.getChildAreaByPid(pid);
	}

	/**
	 * 根据业务区域查找包含的地理区域
	 * 
	 * @param saleAreaId
	 * @return
	 */
	public List<AreaHelp> getAreaBysaleAreaId(Integer saleAreaId) {
		return baseAreaDao.getAreaBysaleAreaId(saleAreaId);
	}
}