package cn.com.biz.main.service.impl;
import java.util.List;
import java.util.UUID;

import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.biz.main.dao.ChannelDao;
import cn.com.biz.main.entity.TChannelEntity;
import cn.com.biz.main.help.ChannelHelp;
import cn.com.biz.main.service.TChannelServiceI;

@Service("tChannelService")
@Transactional
public class TChannelServiceImpl extends CommonServiceImpl implements TChannelServiceI {

	@Autowired
	private ChannelDao channelDao;
	
 	/**
	 * 替换sql中的变量
	 * @param sql
	 * @return
	 */
 	public String replaceVal(String sql,TChannelEntity t){
 		sql  = sql.replace("#{id}",String.valueOf(t.getId()));
 		sql  = sql.replace("#{ccode}",String.valueOf(t.getCcode()));
 		sql  = sql.replace("#{cname}",String.valueOf(t.getCname()));
 		sql  = sql.replace("#{sapcode}",String.valueOf(t.getSapcode()));
 		sql  = sql.replace("#{UUID}",UUID.randomUUID().toString());
 		return sql;
 	}

	/**
	 * 通过渠道组ID获得所有的渠道
	 */
	public List<ChannelHelp> getChannelByGroupId(Integer groupId) {
		return channelDao.getChannelByGroupId(groupId);
	}

	/**
	 * 通过渠道组ID获得所有还未分配给其的渠道
	 */
	public List<TChannelEntity> getUnChannelByGroupId(Integer groupId) {
		return channelDao.getUnChannelByGroupId(groupId);
	}
}