package cn.com.biz.main.service.impl;

import java.util.List;
import java.util.UUID;

import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.biz.main.dao.ProductMaterialDao;
import cn.com.biz.main.entity.TMaterialEntity;
import cn.com.biz.main.help.ProductHelp;
import cn.com.biz.main.service.TMaterialServiceI;

@Service("tMaterialService")
@Transactional
public class TMaterialServiceImpl extends CommonServiceImpl implements TMaterialServiceI {

	@Autowired
	private ProductMaterialDao productMaterialDao;
 	
 	/**
	 * 替换sql中的变量
	 * @param sql
	 * @return
	 */
 	public String replaceVal(String sql,TMaterialEntity t){
 		sql  = sql.replace("#{id}",String.valueOf(t.getId()));
 		sql  = sql.replace("#{mcode}",String.valueOf(t.getMcode()));
 		sql  = sql.replace("#{mname}",String.valueOf(t.getMname()));
 		sql  = sql.replace("#{sapcode}",String.valueOf(t.getSapcode()));
 		sql  = sql.replace("#{mtype}",String.valueOf(t.getMtype()));
 		sql  = sql.replace("#{UUID}",UUID.randomUUID().toString());
 		return sql;
 	}

	/**
	 * 根据产品组ID获得所属的物料
	 * 
	 * @param pgroupId
	 * @return
	 */
	public List<ProductHelp> getMaterialByProductGroup(Integer pgroupId) {
		return productMaterialDao.getMaterialByProductGroup(pgroupId);
	}

	/**
	 * 根据产品组ID获得所有不属于其的物料
	 * 
	 * @param pgroupId
	 * @return
	 */
	public List<TMaterialEntity> getUnMaterialByProductGroup(Integer pgroupId) {
		return productMaterialDao.getUnMaterialByProductGroup(pgroupId);
	}
}