package cn.com.biz.main.service.impl;
import java.util.UUID;

import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.biz.main.entity.TProductGroupEntity;
import cn.com.biz.main.service.TProductGroupServiceI;

@Service("tProductGroupService")
@Transactional
public class TProductGroupServiceImpl extends CommonServiceImpl implements TProductGroupServiceI {
 	
 	/**
	 * 替换sql中的变量
	 * 
	 * @param sql
	 * @return
	 */
	public String replaceVal(String sql, TProductGroupEntity t) {
		sql = sql.replace("#{id}", String.valueOf(t.getId()));
		sql = sql.replace("#{pgcode}", String.valueOf(t.getPgcode()));
		sql = sql.replace("#{pgname}", String.valueOf(t.getPgname()));
		sql = sql.replace("#{sapcode}", String.valueOf(t.getSapcode()));
		sql = sql.replace("#{UUID}", UUID.randomUUID().toString());
		return sql;
	}
}