package cn.com.biz.phoneif.controller;
import cn.com.biz.phoneif.entity.PhoneTypeEntity;
import cn.com.biz.phoneif.service.PhoneTypeServiceI;

import java.util.ArrayList;
import java.util.List;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.common.model.json.TreeGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSDepart;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.core.util.MyBeanUtils;


/**   
 * @Title: Controller
 * @Description: 字典具体数据
 * @author onlineGenerator
 * @date 2014-08-29 15:16:16
 * @version V1.0   
 *
 */
@Controller
@RequestMapping("/phoneTypeController")
public class PhoneTypeController extends BaseController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = Logger.getLogger(PhoneTypeController.class);

	@Autowired
	private PhoneTypeServiceI phoneTypeService;
	@Autowired
	private SystemService systemService;


	/**
	 * 字典具体数据列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "phoneType")
	public ModelAndView phoneType(HttpServletRequest request) {
		return new ModelAndView("cn/com/biz/phoneif/phoneTypeList");
	}
	
	/**
	 * easyui AJAX请求数据
	 * 
	 * @param request
	 * @param response
	 * @param dataGrid
	 * @param user
	 */

	@RequestMapping(params = "datagrid")
	public void datagrid(PhoneTypeEntity phoneType,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		CriteriaQuery cq = new CriteriaQuery(PhoneTypeEntity.class, dataGrid);
		//查询条件组装器
		org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil.installHql(cq, phoneType, request.getParameterMap());
		try{
		//自定义追加查询条件
		}catch (Exception e) {
			throw new BusinessException(e.getMessage());
		}
		cq.add();
		this.phoneTypeService.getDataGridReturn(cq, true);
		TagUtil.datagrid(response, dataGrid);
	}
	
	/**
	 * 删除字典具体数据
	 * 
	 * @return
	 */
	@RequestMapping(params = "doDel")
	@ResponseBody
	public AjaxJson doDel(PhoneTypeEntity phoneType, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		phoneType = systemService.getEntity(PhoneTypeEntity.class, phoneType.getId());
		String message = "字典具体数据删除成功";
		try{
			phoneTypeService.delete(phoneType);
			systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
			//刷新缓存
			systemService.refleshTypeGroupCach();
		}catch(Exception e){
			e.printStackTrace();
			message = "字典具体数据删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 批量删除字典具体数据
	 * 
	 * @return
	 */
	 @RequestMapping(params = "doBatchDel")
	@ResponseBody
	public AjaxJson doBatchDel(String ids,HttpServletRequest request){
		AjaxJson j = new AjaxJson();
		String message = "字典具体数据删除成功";
		try{
			for(String id:ids.split(",")){
				PhoneTypeEntity phoneType = systemService.getEntity(PhoneTypeEntity.class, 
				Integer.parseInt(id)
				);
				phoneTypeService.delete(phoneType);
				systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
				//刷新缓存
				systemService.refleshTypeGroupCach();
			}
		}catch(Exception e){
			e.printStackTrace();
			message = "字典具体数据删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}


	/**
	 * 添加字典具体数据
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doAdd")
	@ResponseBody
	public AjaxJson doAdd(PhoneTypeEntity phoneType, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "字典具体数据添加成功";
		try{
			phoneTypeService.save(phoneType);
			systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
			//刷新缓存
			systemService.refleshTypeGroupCach();
		}catch(Exception e){
			e.printStackTrace();
			message = "字典具体数据添加失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 更新字典具体数据
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doUpdate")
	@ResponseBody
	public AjaxJson doUpdate(PhoneTypeEntity phoneType, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "字典具体数据更新成功";
		PhoneTypeEntity t = phoneTypeService.get(PhoneTypeEntity.class, phoneType.getId());
		try {
			MyBeanUtils.copyBeanNotNull2Bean(phoneType, t);
			phoneTypeService.saveOrUpdate(t);
			systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
			//刷新缓存
			systemService.refleshTypeGroupCach();
		} catch (Exception e) {
			e.printStackTrace();
			message = "字典具体数据更新失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	

	/**
	 * 字典具体数据新增页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goAdd")
	public ModelAndView goAdd(PhoneTypeEntity phoneType, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(phoneType.getId())) {
			phoneType = phoneTypeService.getEntity(PhoneTypeEntity.class, phoneType.getId());
			req.setAttribute("phoneTypePage", phoneType);
		}
		return new ModelAndView("cn/com/biz/phoneif/phoneType-add");
	}
	/**
	 * 字典具体数据编辑页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goUpdate")
	public ModelAndView goUpdate(PhoneTypeEntity phoneType, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(phoneType.getId())) {
			phoneType = phoneTypeService.getEntity(PhoneTypeEntity.class, phoneType.getId());
			req.setAttribute("phoneTypePage", phoneType);
		}
		return new ModelAndView("cn/com/biz/phoneif/phoneType-update");
	}
}
