package cn.com.biz.phoneif.controller;
import cn.com.biz.phoneif.entity.PhoneTypeEntity;
import cn.com.biz.phoneif.entity.PhoneTypegroupEntity;
import cn.com.biz.phoneif.service.PhoneTypeServiceI;
import cn.com.biz.phoneif.service.PhoneTypegroupServiceI;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.common.model.json.TreeGrid;
import org.jeecgframework.core.common.model.json.ValidForm;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSDepart;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.core.util.MyBeanUtils;

import com.sun.org.apache.bcel.internal.generic.CPInstruction;


/**   
 * @Title: Controller
 * @Description: 手机数据字典组
 * @author onlineGenerator
 * @date 2014-08-29 15:16:29
 * @version V1.0   
 *
 */
@Controller
@RequestMapping("/phoneTypegroupController")
public class PhoneTypegroupController extends BaseController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = Logger.getLogger(PhoneTypegroupController.class);

	@Autowired
	private PhoneTypegroupServiceI phoneTypegroupService;
	@Autowired
	private PhoneTypeServiceI phoneTypeService;
	@Autowired
	private SystemService systemService;
	private String message;

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * 手机数据字典组列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "phoneTypegroup")
	public ModelAndView phoneTypegroup(HttpServletRequest request) {
		return new ModelAndView("cn/com/biz/phoneif/phoneTypegroupList");
	}

	/**
	 * easyui AJAX请求数据
	 * 
	 * @param request
	 * @param response
	 * @param dataGrid
	 * @param user
	 */

	@RequestMapping(params = "typeGridTreePH")
	@ResponseBody
	public List<TreeGrid> typeGridTreePH(HttpServletRequest request, TreeGrid treegrid) {
		CriteriaQuery cq;
		List<TreeGrid> treeGrids = new ArrayList<TreeGrid>();
		if (treegrid.getId() != null) {
			cq = new CriteriaQuery(PhoneTypeEntity.class);
			cq.eq("typegroupid", Integer.valueOf(treegrid.getId().substring(1)));
			cq.add();
			List<PhoneTypeEntity> typeList = phoneTypegroupService.getListByCriteriaQuery(cq, false);
			for (PhoneTypeEntity obj : typeList) {
				TreeGrid treeNode = new TreeGrid();
				treeNode.setId("T"+obj.getId());
				treeNode.setText(obj.getTypename());
				treeNode.setCode(obj.getTypecode());
				treeGrids.add(treeNode);
			}
		} else {
			cq = new CriteriaQuery(PhoneTypegroupEntity.class);
			List<PhoneTypegroupEntity> typeGroupList = phoneTypegroupService.getListByCriteriaQuery(cq, false);
			for (PhoneTypegroupEntity obj : typeGroupList) {
				TreeGrid treeNode = new TreeGrid();
				treeNode.setId("G"+obj.getId());
				treeNode.setText(obj.getTypegroupname());
				treeNode.setCode(obj.getTypegroupcode());
				treeNode.setState("closed");
				treeGrids.add(treeNode);
			}
		}

		return treeGrids;
	}

	/**
	 * 删除类型分组或者类型（ID以G开头的是分组）
	 * 
	 * @return
	 */
	@RequestMapping(params = "delTypeGridTreePH")
	@ResponseBody
	public AjaxJson delTypeGridTreePH(String id, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		if (id.startsWith("G")) {//分组
			PhoneTypegroupEntity typegroup = phoneTypegroupService.getEntity(PhoneTypegroupEntity.class, id.substring(1));
			message = "数据字典分组: " + typegroup.getTypegroupname() + "被删除 成功";
			phoneTypegroupService.delete(typegroup);
		} else {
			PhoneTypeEntity type = phoneTypeService.getEntity(PhoneTypeEntity.class, Integer.valueOf(id.substring(1)));
			message = "数据字典类型: " + type.getTypename() + "被删除 成功";
			systemService.delete(type);
		}
		systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
		//刷新缓存
		systemService.refleshTypeGroupCach();
		j.setMsg(message);
		return j;
	}
	/**
	 * 类型分组列表页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "aouTypeGroupPH")
	public ModelAndView aouTypeGroupPH(PhoneTypegroupEntity typegroup, HttpServletRequest req) {
		if (typegroup.getId() != null) {
			typegroup = systemService.getEntity(PhoneTypegroupEntity.class, typegroup.getId());
			req.setAttribute("typegroup", typegroup);
		}
		return new ModelAndView("cn/com/biz/phoneif/phoneTypegroup-add");
	}
	/**
	 * 添加类型分组
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "saveTypeGroupPH")
	@ResponseBody
	public AjaxJson saveTypeGroupPH(PhoneTypegroupEntity typegroup, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		if (StringUtil.isNotEmpty(typegroup.getId())) {
			message = "类型分组: " + typegroup.getTypegroupname() + "被更新成功";
			phoneTypegroupService.saveOrUpdate(typegroup);
			systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
		} else {
			message = "类型分组: " + typegroup.getTypegroupname() + "被添加成功";
			phoneTypegroupService.save(typegroup);
			systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
		}
		//刷新缓存
		systemService.refleshTypeGroupCach();
		j.setMsg(message);
		return j;
	}
	/**
	 * 类型列表页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "addorupdateTypePH")
	public ModelAndView addorupdateType(PhoneTypeEntity type, HttpServletRequest req) {
		String typegroupid = req.getParameter("typegroupid");
		req.setAttribute("typegroupid", typegroupid);
		if (StringUtil.isNotEmpty(type.getId())) {
			type = phoneTypeService.getEntity(PhoneTypeEntity.class, type.getId());
			req.setAttribute("type", type);
		}
		return new ModelAndView("cn/com/biz/phoneif/phoneType-add");
	}
	/**
	 * 检查类型代码
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "checkTypePH")
	@ResponseBody
	public ValidForm checkType(HttpServletRequest request) {
		ValidForm v = new ValidForm();
//		String typecode=oConvertUtils.getString(request.getParameter("param"));
//		String code=oConvertUtils.getString(request.getParameter("code"));
//		String typeGroupCode=oConvertUtils.getString(request.getParameter("typeGroupCode"));
//		StringBuilder hql = new StringBuilder("FROM ").append(PhoneTypeEntity.class.getName()).append(" AS entity WHERE 1=1 ");
//		hql.append(" AND entity.PhoneTypegroupEntity.typegroupcode =  '").append(typeGroupCode).append("'");
//		hql.append(" AND entity.typecode =  '").append(typecode).append("'");
//		List<Object> types = this.systemService.findByQueryString(hql.toString());
//		if(types.size()>0&&!code.equals(typecode))
//		{
//			v.setInfo("类型已存在");
//			v.setStatus("n");
//		}
		return v;
	}
	/**
	 * 添加类型
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "saveTypePH")
	@ResponseBody
	public AjaxJson saveTypePH(PhoneTypeEntity type, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		if (StringUtil.isNotEmpty(type.getId())) {
			message = "类型: " + type.getTypename() + "被更新成功";
			phoneTypeService.saveOrUpdate(type);
			systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
		} else {
			message = "类型: " + type.getTypename() + "被添加成功";
			phoneTypeService.save(type);
			systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
		}
		//刷新缓存
		systemService.refleshTypeGroupCach();
		j.setMsg(message);
		return j;
	}
	/**
	 * easyui 请求功能列表数据
	 * 
	 * @param request
	 * @param response
	 * @param dataGrid
	 */

	@RequestMapping(params = "datagridFunc")
	public void datagridFunc(PhoneTypeEntity phoneAuto,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		CriteriaQuery cq = new CriteriaQuery(PhoneTypegroupEntity.class);
		try {
			cq.eq("typegroupcode", "phoneFunc");//phoneFunc为功能类型标记
			cq.add();
			List<PhoneTypegroupEntity> pEntities = this.systemService
					.getListByCriteriaQuery(cq, false);//
			// List<PhoneTypeEntity> list
			// =phoneTypegroupService.getPhoneTypeByParam("phoneFunc");
			CriteriaQuery cqq = new CriteriaQuery(PhoneTypeEntity.class,
					dataGrid);
			if (pEntities != null && pEntities.size() > 0) {
				cqq.eq("typegroupid", pEntities.get(0).getId());
			} else {
				cqq.eq("1", "2");
			}
			org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil
					.installHql(cqq, phoneAuto, request.getParameterMap());
			this.phoneTypegroupService.getDataGridReturn(cqq, true);
		} catch (Exception e) {
			throw new BusinessException(e.getMessage());
		}
		TagUtil.datagrid(response, dataGrid);
	}
}
