package cn.com.biz.phoneif.service.impl;
import cn.com.biz.phoneif.service.PhoneTypegroupServiceI;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;

import cn.com.biz.phoneif.dao.PhoneTypeMiniDao;
import cn.com.biz.phoneif.entity.PhoneTypeEntity;
import cn.com.biz.phoneif.entity.PhoneTypegroupEntity;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.UUID;
import java.io.Serializable;

@Service("phoneTypegroupService")
@Transactional
public class PhoneTypegroupServiceImpl extends CommonServiceImpl implements PhoneTypegroupServiceI {
    @Autowired
	PhoneTypeMiniDao phoneTypeMiniDao;
	
 	public <T> void delete(T entity) {
 		super.delete(entity);
 		//执行删除操作配置的sql增强
		this.doDelSql((PhoneTypegroupEntity)entity);
 	}
 	
 	public <T> Serializable save(T entity) {
 		Serializable t = super.save(entity);
 		//执行新增操作配置的sql增强
 		this.doAddSql((PhoneTypegroupEntity)entity);
 		return t;
 	}
 	
 	public <T> void saveOrUpdate(T entity) {
 		super.saveOrUpdate(entity);
 		//执行更新操作配置的sql增强
 		this.doUpdateSql((PhoneTypegroupEntity)entity);
 	}
 	
 	/**
	 * 默认按钮-sql增强-新增操作
	 * @param id
	 * @return
	 */
 	public boolean doAddSql(PhoneTypegroupEntity t){
	 	return true;
 	}
 	/**
	 * 默认按钮-sql增强-更新操作
	 * @param id
	 * @return
	 */
 	public boolean doUpdateSql(PhoneTypegroupEntity t){
	 	return true;
 	}
 	/**
	 * 默认按钮-sql增强-删除操作
	 * @param id
	 * @return
	 */
 	public boolean doDelSql(PhoneTypegroupEntity t){
	 	return true;
 	}
 	
 	/**
	 * 替换sql中的变量
	 * @param sql
	 * @return
	 */
 	public String replaceVal(String sql,PhoneTypegroupEntity t){
 		sql  = sql.replace("#{id}",String.valueOf(t.getId()));
 		sql  = sql.replace("#{typegroupname}",String.valueOf(t.getTypegroupname()));
 		sql  = sql.replace("#{typegroupcode}",String.valueOf(t.getTypegroupcode()));
 		sql  = sql.replace("#{UUID}",UUID.randomUUID().toString());
 		return sql;
 	}
 	/**
 	 * 查询手机功能列表
 	 * @param func
 	 * @return
 	 */
 	public List<PhoneTypeEntity> getPhoneTypeByParam(String func){
 		return phoneTypeMiniDao.getPhoneTypeByParam(func);
 	}
}