package cn.com.biz.position.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.RoletoJson;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import cn.com.biz.position.entity.TPositionAttrEntity;
import cn.com.biz.position.entity.TPositionEntity;
import cn.com.biz.position.entity.TPositionRoleEntity;
import cn.com.biz.position.entity.TPositionTypeEntity;
import cn.com.biz.position.help.PositionHelp;
import cn.com.biz.position.service.TPositionServiceI;


/**   
 * @Title: Controller
 * @Description: 职位
 * @author onlineGenerator
 * @date 2014-08-14 10:03:04
 * @version V1.0   
 *
 */
@Controller
@RequestMapping("/tPositionController")
public class TPositionController extends BaseController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = Logger.getLogger(TPositionController.class);

	@Autowired
	private TPositionServiceI tPositionService;
	@Autowired
	private SystemService systemService;

	/**
	 * 选择部门后查看弹出职位列表功能页面(1.仅显示 或 2.选择某职位并作为返回值回传)： Weston.wen 日 期： 2014-8-8
	 * 
	 * @param request
	 * @param departid
	 * @return 返回类型： ModelAndView
	 */
	@RequestMapping(params = "departPositionList")
	public ModelAndView departPositionList(HttpServletRequest request,
			String depid, Integer op) {
		request.setAttribute("depid", depid);
		if (op != null && op == 2) {// 选择职位的页面
			return new ModelAndView(
					"cn/com/biz/position/departPostionListCheck");
		} else {
			return new ModelAndView("cn/com/biz/position/departPostionList");
		}
	}


	/**
	 * 职位列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "tPosition")
	public ModelAndView tPosition(HttpServletRequest request) {
		List<TPositionTypeEntity> posTypeList = systemService
				.getList(TPositionTypeEntity.class);
		request.setAttribute("posTypeReplace", RoletoJson
				.listToReplaceStrLongId(posTypeList, "typename", "id"));
		return new ModelAndView("cn/com/biz/position/tPositionList");
	}

	/**
	 * 职位列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "tPosition2")
	public ModelAndView tPosition2(HttpServletRequest request) {
		return new ModelAndView("cn/com/biz/position/tPositionList2");
	}

	/**
	 * easyui AJAX请求数据
	 * 
	 * @param request
	 * @param response
	 * @param dataGrid
	 * @param user
	 */
	@RequestMapping(params = "datagrid")
	public void datagrid(PositionHelp tPosition, HttpServletRequest request,
			HttpServletResponse response, DataGrid dataGrid) {
		String depid = oConvertUtils.getString(request.getParameter("depid"));
		if (StringUtil.isNotEmpty(depid)) {
			tPosition.getTsDepart().setId(depid);
		}
		CriteriaQuery cq = new CriteriaQuery(TPositionEntity.class, dataGrid);
		// 查询条件组装器
		org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil.installHql(cq,
				tPosition, request.getParameterMap());
		try {
			// 自定义追加查询条件
		} catch (Exception e) {
			throw new BusinessException(e.getMessage());
		}
		cq.add();
		this.tPositionService.getDataGridReturn(cq, true);
		TagUtil.datagrid(response, dataGrid);
	}

	@RequestMapping(params = "datagrid2")
	public void datagrid2(PositionHelp tPosition,
			HttpServletRequest request, HttpServletResponse response,
			DataGrid dataGrid) {
		String departid = oConvertUtils.getString(request
				.getParameter("departid"));
		if (!StringUtil.isEmpty(departid)) {
			tPosition.setDepartid(departid);
		}
		List<PositionHelp> tPositionList = tPositionService
				.getPositionsByParam(tPosition, dataGrid.getPage(),
						dataGrid.getRows());
		dataGrid.setResults(tPositionList);
		dataGrid.setTotal(tPositionService.getCount());
		TagUtil.datagrid(response, dataGrid);
	}

	/**
	 * 删除职位
	 * 
	 * @return
	 */
	@RequestMapping(params = "doDel")
	@ResponseBody
	public AjaxJson doDel(TPositionEntity tPosition, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		tPosition = systemService.getEntity(TPositionEntity.class, tPosition.getId());
		String message = "职位删除成功";
		try{
			tPositionService.delete(tPosition);
			systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "职位删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 批量删除职位
	 * 
	 * @return
	 */
	 @RequestMapping(params = "doBatchDel")
	@ResponseBody
	public AjaxJson doBatchDel(String ids,HttpServletRequest request){
		AjaxJson j = new AjaxJson();
		String message = "职位删除成功";
		try{
			for(String id:ids.split(",")){
				TPositionEntity tPosition = systemService.getEntity(TPositionEntity.class, 
				Integer.parseInt(id)
				);
				tPositionService.delete(tPosition);
				systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
			}
		}catch(Exception e){
			e.printStackTrace();
			message = "职位删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}


	/**
	 * 添加职位
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doAdd")
	@ResponseBody
	public AjaxJson doAdd(TPositionEntity tPosition, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "职位添加成功";
		try{
			tPositionService.save(tPosition);
			systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "职位添加失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 更新职位
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doUpdate")
	@ResponseBody
	public AjaxJson doUpdate(TPositionEntity tPosition, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "职位更新成功";
		TPositionEntity t = tPositionService.get(TPositionEntity.class,
				tPosition.getId());
		try {
			MyBeanUtils.copyBeanNotNull2Bean(tPosition, t);
			tPositionService.saveOrUpdate(t);
			systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
		} catch (Exception e) {
			e.printStackTrace();
			message = "职位更新失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}


	/**
	 * 职位新增页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goAdd")
	public ModelAndView goAdd(TPositionEntity tPosition, HttpServletRequest req) {
		List<TPositionTypeEntity> tposTypeList = new ArrayList<TPositionTypeEntity>();
		tposTypeList.addAll((List) systemService
				.getList(TPositionTypeEntity.class));
		req.setAttribute("posTypeList", tposTypeList);
		if (StringUtil.isNotEmpty(tPosition.getId())) {
			tPosition = tPositionService.getEntity(TPositionEntity.class,
					tPosition.getId());
			req.setAttribute("tPositionPage", tPosition);
		}
		return new ModelAndView("cn/com/biz/position/tPosition-add");
	}
	/**
	 * 职位编辑页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goUpdate")
	public ModelAndView goUpdate(TPositionEntity tPosition, HttpServletRequest req) {
		List<TPositionTypeEntity> tposTypeList = new ArrayList<TPositionTypeEntity>();
		tposTypeList.addAll((List) systemService
				.getList(TPositionTypeEntity.class));
		req.setAttribute("posTypeList", tposTypeList);
		if (StringUtil.isNotEmpty(tPosition.getId())) {
			tPosition = tPositionService.getEntity(TPositionEntity.class,
					tPosition.getId());
			req.setAttribute("tPositionPage", tPosition);
		}
		return new ModelAndView("cn/com/biz/position/tPosition-update");
	}

	/**
	 * 职位新增角色页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goSetRole")
	public ModelAndView goSetRole(TPositionEntity tPosition,
			HttpServletRequest req) {
		String posid = oConvertUtils.getString(req.getParameter("posid"));
		if (StringUtil.isNotEmpty(posid)) {
			tPosition = tPositionService.getEntity(TPositionEntity.class,
					Integer.parseInt(posid));
			req.setAttribute("pos", tPosition);
		}
		return new ModelAndView("cn/com/biz/position/tPosition-role");
	}

	/**
	 * 职位所含角色页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goAddRole")
	public ModelAndView goAddRole(PositionHelp tPosition,
			HttpServletRequest req) {
		String posid = oConvertUtils.getString(req.getParameter("posid"));
		tPosition.setId(Integer.parseInt(posid));
		List<PositionHelp> tPositionList = tPositionService
				.getPositionsByParam(tPosition, 1, 10);
		if (tPositionList != null && tPositionList.size() > 0) {
			req.setAttribute("pos", tPositionList.get(0));
		}
		return new ModelAndView("cn/com/biz/position/tPosition-roleAdd");
	}

	/**
	 * 添加一条职位角色对应关系
	 * 
	 * @return
	 */
	@RequestMapping(params = "doAddRole")
	@ResponseBody
	public AjaxJson doAddRole(PositionHelp tPosition,
			HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "参数错误";
		String roleid = oConvertUtils.getString(request.getParameter("roleid"));
		String posidStr = oConvertUtils
				.getString(request.getParameter("posid"));
		String[] roleids = roleid.split(",");
		try {
			Integer posid = Integer.parseInt(posidStr);
			if (posid != null && posid > 0) {
				for (int i = 0; i < roleids.length; i++) {
					message = "职位的角色添加成功";
					TPositionRoleEntity pr = new TPositionRoleEntity();
					pr.setRoleid(roleids[i]);
					pr.setPosid(posid);
					systemService.save(pr);
					systemService.addLog(message, Globals.Log_Type_INSERT,
							Globals.Log_Leavel_INFO);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			message = "职位的角色添加失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}

	/**
	 * 职位角色信息查询后返回datagrid
	 * 
	 * @param request
	 * @param response
	 * @param dataGrid
	 * @param user
	 */
	@RequestMapping(params = "roledatagrid")
	public void roledatagrid(TPositionEntity tPosition,
			HttpServletRequest request, HttpServletResponse response,
			DataGrid dataGrid) {
		Integer posid = 0;
		try {
			String idStr = oConvertUtils.getString(request
					.getParameter("posid"));
			if (!StringUtil.isEmpty(idStr)) {
				posid = Integer.parseInt(idStr);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		tPosition.setId(posid);
		List<PositionHelp> tPosHelpList = tPositionService
				.getPosRolesByParam(tPosition);
		dataGrid.setResults(tPosHelpList);
		TagUtil.datagrid(response, dataGrid);
	}

	/**
	 * 删除一条职位角色对应关系
	 * 
	 * @return
	 */
	@RequestMapping(params = "doDelRole")
	@ResponseBody
	public AjaxJson doDelRole(PositionHelp tPosition,
			HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "职位错误";
		if (tPosition.getPosRoleId() != null && tPosition.getPosRoleId() > 0) {
			message = "职位的角色删除成功";
			try {
				TPositionRoleEntity pr = new TPositionRoleEntity();
				pr.setId(tPosition.getPosRoleId());
				systemService.delete(pr);
				systemService.addLog(message, Globals.Log_Type_DEL,
						Globals.Log_Leavel_INFO);
			} catch (Exception e) {
				e.printStackTrace();
				message = "职位的角色删除失败";
				throw new BusinessException(e.getMessage());
			}
		}
		j.setMsg(message);
		return j;
	}

	/**
	 * 职位列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "tPositionAttr")
	public ModelAndView tPositionAttr(HttpServletRequest request) {
		return new ModelAndView("cn/com/biz/position/tPositionAttrList");
	}

	/**
	 * 职位属性Datagrid
	 */
	@RequestMapping(params = "attrDatagrid")
	public void attrDatagrid(PositionHelp tPosition,
			HttpServletRequest request, HttpServletResponse response,
			DataGrid dataGrid) {
		List<PositionHelp> tPositionList = tPositionService.getPosAttrByParam(
				tPosition, dataGrid.getPage(),dataGrid.getRows());
		dataGrid.setResults(tPositionList);
		dataGrid.setTotal(tPositionService.getCount());
		TagUtil.datagrid(response, dataGrid);
	}

	/**
	 * 职位属性新增页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goAddAttr")
	public ModelAndView goAddAttr(TPositionAttrEntity tPositionAttrEntity,
			HttpServletRequest req) {
		List<TPositionTypeEntity> tposTypeList = new ArrayList<TPositionTypeEntity>();
		return new ModelAndView("cn/com/biz/position/tPositionAttr-add");
	}

	/**
	 * 职位编辑页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goUpdateAttr")
	public ModelAndView goUpdateAttr(TPositionAttrEntity tPositionAttrEntity,
			HttpServletRequest req) {
		if (StringUtil.isNotEmpty(tPositionAttrEntity.getId())) {
			tPositionAttrEntity = systemService.getEntity(
					TPositionAttrEntity.class, tPositionAttrEntity.getId());
			req.setAttribute("tPositionAttrPage", tPositionAttrEntity);
		}
		return new ModelAndView("cn/com/biz/position/tPositionAttr-update");
	}

	/**
	 * 添加职位属性
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doAddAttr")
	@ResponseBody
	public AjaxJson doAddAttr(TPositionAttrEntity tPositionAttrEntity,
			HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "职位属性设置成功";
		try {
			systemService.save(tPositionAttrEntity);
			systemService.addLog(message, Globals.Log_Type_INSERT,
					Globals.Log_Leavel_INFO);
		} catch (Exception e) {
			e.printStackTrace();
			message = "职位属性设置失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}

	/**
	 * 更新职位属性
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doUpdateAttr")
	@ResponseBody
	public AjaxJson doUpdateAttr(TPositionAttrEntity tPositionAttrEntity,
			HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "职位属性更新成功";
		TPositionAttrEntity t = systemService.getEntity(
				TPositionAttrEntity.class, tPositionAttrEntity.getId());
		try {
			MyBeanUtils.copyBeanNotNull2Bean(tPositionAttrEntity, t);
			systemService.save(t);
			systemService.addLog(message, Globals.Log_Type_UPDATE,
					Globals.Log_Leavel_INFO);
		} catch (Exception e) {
			e.printStackTrace();
			message = "职位属性更新失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
}
