package cn.com.biz.position.dao;

import java.util.List;

import org.jeecgframework.minidao.annotation.Arguments;
import org.jeecgframework.minidao.annotation.MiniDao;
import org.jeecgframework.minidao.annotation.ResultType;
import org.jeecgframework.minidao.annotation.Sql;
import org.jeecgframework.minidao.hibernate.MiniDaoSupportHiber;

import cn.com.biz.position.entity.TPositionEntity;
import cn.com.biz.position.help.PositionHelp;

@MiniDao
public interface PositionDao extends MiniDaoSupportHiber<PositionHelp> {
	@Arguments({ "pos", "page", "rows" })
	public List<PositionHelp> getPositionsByParam(TPositionEntity pos,
			int page, int rows);

	@Arguments("pos")
	public List<PositionHelp> getPosRolesByParam(TPositionEntity pos);

	@Sql("SELECT count(*) FROM t_position")
	public Integer getCount();

	@Arguments({ "ph", "page", "rows" })
	@ResultType("cn.com.biz.position.help.PositionHelp")
	public List<PositionHelp> getPosAttrByParam(PositionHelp ph, int page,
			int rows);

	public Integer getPosAttrByParamCount();
}
