package cn.com.biz.position.entity;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.jeecgframework.web.system.pojo.base.TSDepart;

/**   
 * @Title: Entity
 * @Description: 职位
 * @author onlineGenerator
 * @date 2014-08-14 10:03:04
 * @version V1.0   
 *
 */
@Entity
@Table(name = "t_position")
@PrimaryKeyJoinColumn(name = "id")
@SequenceGenerator(name="SEQ_GEN", sequenceName="SEQ_T_POSITION")  
@SuppressWarnings("serial")
public class TPositionEntity implements java.io.Serializable {
	/**主键*/
	private java.lang.Integer id;
	/**职位名称*/
	private java.lang.String posname;
	/**职位类型*/
	private java.lang.Integer posttype;
	/**职位助记码*/
	private java.lang.String poscode;
	/**父职位ID*/
	private java.lang.Integer pid;
	
	private TSDepart tsDepart = new TSDepart();// 部门

	@JsonIgnore
	// getList查询转换为列表时处理json转换异常
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "departid")
	public TSDepart getTsDepart() {
		return tsDepart;
	}

	public void setTsDepart(TSDepart tsDepart) {
		this.tsDepart = tsDepart;
	}

	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer  主键
	 */
	@Id
	@GeneratedValue(strategy=GenerationType.SEQUENCE,generator="SEQ_GEN")  
	@Column(name ="ID",nullable=false,length=20)
	public java.lang.Integer getId(){
		return this.id;
	}

	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer  主键
	 */
	public void setId(java.lang.Integer id){
		this.id = id;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  职位名称
	 */
	@Column(name ="POSNAME",nullable=false,length=100)
	public java.lang.String getPosname(){
		return this.posname;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  职位名称
	 */
	public void setPosname(java.lang.String posname){
		this.posname = posname;
	}
	

	/**
	 * 方法: 取得java.lang.String
	 * 
	 * @return: java.lang.String 职位类型
	 */
	@Column(name = "POSTTYPE", nullable = true, length = 20)
	public java.lang.Integer getPosttype() {
		return this.posttype;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  职位类型
	 */
	public void setPosttype(java.lang.Integer posttype) {
		this.posttype = posttype;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  职位助记码
	 */
	@Column(name ="POSCODE",nullable=true,length=50)
	public java.lang.String getPoscode(){
		return this.poscode;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  职位助记码
	 */
	public void setPoscode(java.lang.String poscode){
		this.poscode = poscode;
	}
	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer  父职位ID
	 */
	@Column(name ="PID",nullable=true,length=20)
	public java.lang.Integer getPid(){
		return this.pid;
	}

	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer  父职位ID
	 */
	public void setPid(java.lang.Integer pid){
		this.pid = pid;
	}
}
