package cn.com.biz.position.service;

import java.io.Serializable;
import java.util.List;

import org.jeecgframework.core.common.service.CommonService;

import cn.com.biz.position.entity.TPositionEntity;
import cn.com.biz.position.help.PositionHelp;

public interface TPositionServiceI extends CommonService {
	
	public <T> void delete(T entity);

	public <T> Serializable save(T entity);

	public <T> void saveOrUpdate(T entity);

 	/**
	 * 默认按钮-sql增强-新增操作
	 * @param id
	 * @return
	 */
 	public boolean doAddSql(TPositionEntity t);
 	/**
	 * 默认按钮-sql增强-更新操作
	 * @param id
	 * @return
	 */
 	public boolean doUpdateSql(TPositionEntity t);
 	/**
	 * 默认按钮-sql增强-删除操作
	 * @param id
	 * @return
	 */
 	public boolean doDelSql(TPositionEntity t);

	/** 查找职位,带附加属性 **/
	public List<PositionHelp> getPositionsByParam(PositionHelp pos,
			int page, int rows);

	/** 查找职位及拥有的角色,带附加属性 **/
	public List<PositionHelp> getPosRolesByParam(TPositionEntity pos);

	/** 查找职位,带附加属性--总数统计 */
	public int getCount();

	/** 查找职位属性,分页 */
	public List<PositionHelp> getPosAttrByParam(PositionHelp ph, int page,
			int rows);
}
