package cn.com.biz.position.service.impl;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;

import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.biz.position.dao.PositionDao;
import cn.com.biz.position.entity.TPositionEntity;
import cn.com.biz.position.help.PositionHelp;
import cn.com.biz.position.service.TPositionServiceI;

@Service("tPositionService")
@Transactional
public class TPositionServiceImpl extends CommonServiceImpl implements
		TPositionServiceI {

	@Autowired
	private PositionDao positionDao;

	public <T> void delete(T entity) {
		super.delete(entity);
		// 执行删除操作配置的sql增强
		this.doDelSql((TPositionEntity) entity);
	}

	public <T> Serializable save(T entity) {
		Serializable t = super.save(entity);
		// 执行新增操作配置的sql增强
		this.doAddSql((TPositionEntity) entity);
		return t;
	}

	public <T> void saveOrUpdate(T entity) {
		super.saveOrUpdate(entity);
		// 执行更新操作配置的sql增强
		this.doUpdateSql((TPositionEntity) entity);
	}

	/**
	 * 默认按钮-sql增强-新增操作
	 * 
	 * @param id
	 * @return
	 */
	public boolean doAddSql(TPositionEntity t) {
		return true;
	}

	/**
	 * 默认按钮-sql增强-更新操作
	 * 
	 * @param id
	 * @return
	 */
	public boolean doUpdateSql(TPositionEntity t) {
		return true;
	}

	/**
	 * 默认按钮-sql增强-删除操作
	 * 
	 * @param id
	 * @return
	 */
	public boolean doDelSql(TPositionEntity t) {
		return true;
	}

	/**
	 * 替换sql中的变量
	 * 
	 * @param sql
	 * @return
	 */
	public String replaceVal(String sql, TPositionEntity t) {
		sql = sql.replace("#{id}", String.valueOf(t.getId()));
		sql = sql.replace("#{posname}", String.valueOf(t.getPosname()));
		sql = sql.replace("#{posttype}", String.valueOf(t.getPosttype()));
		sql = sql.replace("#{poscode}", String.valueOf(t.getPoscode()));
		sql = sql.replace("#{pid}", String.valueOf(t.getPid()));
		sql = sql.replace("#{UUID}", UUID.randomUUID().toString());
		return sql;
	}

	/** 查找职位,带附加属性 **/
	public List<PositionHelp> getPositionsByParam(PositionHelp pos,
			int page, int rows) {
		return positionDao.getPositionsByParam(pos, page, rows);
	}

	/** 查找职位及拥有的角色,带附加属性 **/
	public List<PositionHelp> getPosRolesByParam(TPositionEntity pos) {
		return positionDao.getPosRolesByParam(pos);
	}

	/** 查找职位,带附加属性--总数统计 */
	public int getCount() {
		return positionDao.getCount();
	}

	/** 查找职位属性,分页 */
	public List<PositionHelp> getPosAttrByParam(PositionHelp ph, int page,
			int rows) {
		return positionDao.getPosAttrByParam(ph, page, rows);
	}
}