package cn.com.biz.salearea.controller;
import cn.com.biz.salearea.entity.TSaleAreaEntity;
import cn.com.biz.salearea.service.TSaleAreaServiceI;
import java.util.List;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSDepart;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.core.util.MyBeanUtils;


/**   
 * @Title: Controller
 * @Description: 销售区域
 * @author onlineGenerator
 * @date 2014-08-28 10:51:18
 * @version V1.0   
 *
 */
@Controller
@RequestMapping("/tSaleAreaController")
public class TSaleAreaController extends BaseController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = Logger.getLogger(TSaleAreaController.class);

	@Autowired
	private TSaleAreaServiceI tSaleAreaService;
	@Autowired
	private SystemService systemService;


	/**
	 * 销售区域列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "tSaleArea")
	public ModelAndView tSaleArea(HttpServletRequest request) {
		return new ModelAndView("cn/com/biz/salearea/tSaleAreaList");
	}

	/**
	 * easyui AJAX请求数据
	 * 
	 * @param request
	 * @param response
	 * @param dataGrid
	 * @param user
	 */

	@RequestMapping(params = "datagrid")
	public void datagrid(TSaleAreaEntity tSaleArea,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		CriteriaQuery cq = new CriteriaQuery(TSaleAreaEntity.class, dataGrid);
		//查询条件组装器
		org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil.installHql(cq, tSaleArea, request.getParameterMap());
		try{
		//自定义追加查询条件
		}catch (Exception e) {
			throw new BusinessException(e.getMessage());
		}
		cq.add();
		this.tSaleAreaService.getDataGridReturn(cq, true);
		TagUtil.datagrid(response, dataGrid);
	}

	/**
	 * 删除销售区域
	 * 
	 * @return
	 */
	@RequestMapping(params = "doDel")
	@ResponseBody
	public AjaxJson doDel(TSaleAreaEntity tSaleArea, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		tSaleArea = systemService.getEntity(TSaleAreaEntity.class, tSaleArea.getId());
		String message = "销售区域删除成功";
		try{
			tSaleAreaService.delete(tSaleArea);
			systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "销售区域删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 批量删除销售区域
	 * 
	 * @return
	 */
	 @RequestMapping(params = "doBatchDel")
	@ResponseBody
	public AjaxJson doBatchDel(String ids,HttpServletRequest request){
		AjaxJson j = new AjaxJson();
		String message = "销售区域删除成功";
		try{
			for(String id:ids.split(",")){
				TSaleAreaEntity tSaleArea = systemService.getEntity(TSaleAreaEntity.class, 
				Integer.parseInt(id)
				);
				tSaleAreaService.delete(tSaleArea);
				systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
			}
		}catch(Exception e){
			e.printStackTrace();
			message = "销售区域删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}


	/**
	 * 添加销售区域
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doAdd")
	@ResponseBody
	public AjaxJson doAdd(TSaleAreaEntity tSaleArea, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "销售区域添加成功";
		try{
			tSaleAreaService.save(tSaleArea);
			systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "销售区域添加失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 更新销售区域
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doUpdate")
	@ResponseBody
	public AjaxJson doUpdate(TSaleAreaEntity tSaleArea, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "销售区域更新成功";
		TSaleAreaEntity t = tSaleAreaService.get(TSaleAreaEntity.class, tSaleArea.getId());
		try {
			MyBeanUtils.copyBeanNotNull2Bean(tSaleArea, t);
			tSaleAreaService.saveOrUpdate(t);
			systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
		} catch (Exception e) {
			e.printStackTrace();
			message = "销售区域更新失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	

	/**
	 * 销售区域新增页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goAdd")
	public ModelAndView goAdd(TSaleAreaEntity tSaleArea, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(tSaleArea.getId())) {
			tSaleArea = tSaleAreaService.getEntity(TSaleAreaEntity.class, tSaleArea.getId());
			req.setAttribute("tSaleAreaPage", tSaleArea);
		}
		return new ModelAndView("cn/com/biz/salearea/tSaleArea-add");
	}
	/**
	 * 销售区域编辑页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goUpdate")
	public ModelAndView goUpdate(TSaleAreaEntity tSaleArea, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(tSaleArea.getId())) {
			tSaleArea = tSaleAreaService.getEntity(TSaleAreaEntity.class, tSaleArea.getId());
			req.setAttribute("tSaleAreaPage", tSaleArea);
		}
		return new ModelAndView("cn/com/biz/salearea/tSaleArea-update");
	}
}
