package org.jeecgframework.codegenerate.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

import javax.swing.text.Position;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.codegenerate.pojo.Columnt;
import org.jeecgframework.codegenerate.pojo.TableConvert;
import org.jeecgframework.codegenerate.util.CodeResourceUtil;
import org.jeecgframework.codegenerate.util.CodeStringUtils;
import org.jeecgframework.codegenerate.util.def.ConvertDef;
import org.jeecgframework.core.util.StringUtil;


/**
 * 取生成页面需要字段（过滤建表模板的默认字段）
 * @author 00704873
 *
 */
public class JeecgReadTable {
	private static final Log log = LogFactory.getLog(JeecgReadTable.class);
	private static final long serialVersionUID = -5324160085184088010L;
	
	private Connection conn;
	private Statement stmt;
	private String sql;
	private ResultSet rs;
	
	public static void main(String[] args) throws Exception{
		try {
			List<Columnt> cls = new JeecgReadTable().readTableColumn("person");
			for (Columnt c:cls) {
				System.out.println(c.getFieldName());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		System.out.println(ArrayUtils.toString(new JeecgReadTable().readAllTableNames()));
	}
	
	/**
	 * 读取数据库中所有的表
	 */
	public List<String> readAllTableNames() throws SQLException{
		List<String> tableNames = new ArrayList<String>(0);
		try {
			Class.forName(CodeResourceUtil.DATABASE_NAME);
			conn = DriverManager.getConnection(CodeResourceUtil.URL, CodeResourceUtil.USERNAME, CodeResourceUtil.PASSWORD);
			stmt = conn.createStatement(ResultSet.TYPE_SCROLL_SENSITIVE, ResultSet.CONCUR_READ_ONLY);
			
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_MYSQL)){
				sql = MessageFormat.format(ConvertDef.mysql_db_sql_queryName, TableConvert.getV(CodeResourceUtil.DATABASE_NAME));
			}
			
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_ORACLE)){
				sql = ConvertDef.oracle_db_sql_queryName;
			}
			
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_postgresql)){
				sql = ConvertDef.PostgreSQL_db_sql_queryName;
			}
			
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_SQL_SERVER)){
				sql = ConvertDef.sqlserver_db_sql_queryName;
			}
			
			rs = stmt.executeQuery(sql);
			while(rs.next()){
				String tableName = rs.getString(1);
				tableNames.add(tableName);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			try {
				if(stmt != null){
					stmt.close();
					stmt = null;
					System.gc();
				}
				if(conn != null){
					conn.close();
					conn = null;
					System.gc();
				}
			} catch (SQLException e2) {
				throw e2;
			}
		}
		return tableNames;
	}
	
	
	/**
	 * 方法：读取表字段信息
	 * 
	 */
	public List<Columnt> readTableColumn(String tableName) throws Exception{
		List<Columnt> columntList = new ArrayList<Columnt>();
		try {
			Class.forName(CodeResourceUtil.DIVER_NAME);
			conn = DriverManager.getConnection(CodeResourceUtil.URL, CodeResourceUtil.USERNAME, CodeResourceUtil.PASSWORD);
			stmt = conn.createStatement(ResultSet.TYPE_SCROLL_SENSITIVE, ResultSet.CONCUR_READ_ONLY);
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_MYSQL)){
				sql = MessageFormat.format(ConvertDef.mysql_db_sql, TableConvert.getV(tableName.toUpperCase()), TableConvert.getV(CodeResourceUtil.DATABASE_NAME));
			}
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_ORACLE)){
				sql = MessageFormat.format(ConvertDef.oracle_db_sql, TableConvert.getV(tableName.toUpperCase()));
			}
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_postgresql)){
				sql = MessageFormat.format(ConvertDef.PostgreSQL_db_sql, TableConvert.getV(tableName.toLowerCase()));
			}
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_SQL_SERVER)){
				sql = MessageFormat.format(ConvertDef.sqlserver_db_sql, TableConvert.getV(tableName.toLowerCase()));
			}
			rs = stmt.executeQuery(sql);
			rs.last();//把指针向结果集的最后
			int fieldNum = rs.getRow();//取得最后条结果的行，作为类的属性个数
			int n = fieldNum;
			
			if(n > 0){//判断数据表中是否存在字段
				Columnt columnt = new Columnt();
				if(CodeResourceUtil.JEECG_FILED_CONVERT){
					columnt.setFieldName(formatField(rs.getString(1).toLowerCase()));
				}else {
					columnt.setFieldName(rs.getString(1).toLowerCase());
				}
				//直接保存表字段名字
				columnt.setFieldDbName(rs.getString(1).toUpperCase());
				columnt.setFieldType(formatField(rs.getString(2).toLowerCase()));
				columnt.setPrecision(rs.getString(4));
				columnt.setScale(rs.getString(5));
				columnt.setCharmaxLength(rs.getString(6));
				columnt.setNullable(TableConvert.getNullAble(rs.getString(7)));
				//加载字段页面样式
				formatFieldClassType(columnt);
				columnt.setFiledComment(StringUtils.isBlank(rs.getString(3))?columnt.getFieldName():rs.getString(3));
				
				//页面生成过滤字段
				String[] ui_filter_fields = new String[]{};
				if(CodeResourceUtil.JEECG_GENERATE_UI_FILTER_FIELDS!=null){
					ui_filter_fields = CodeResourceUtil.JEECG_GENERATE_UI_FILTER_FIELDS.toLowerCase().split(",");
				}
				
				if(CodeResourceUtil.JEECG_GENERATE_TABLE_ID.equals(columnt.getFieldName())||CodeStringUtils.isIn(columnt.getFieldDbName().toLowerCase(), ui_filter_fields)){
				}else {
					columntList.add(columnt);
				}
				while(rs.previous()){
					Columnt po = new Columnt();
					if(CodeResourceUtil.JEECG_FILED_CONVERT){
						po.setFieldName(formatField(rs.getString(1)).toLowerCase());
					}else {
						po.setFieldName(rs.getString(1).toLowerCase());
					}
					
					//直接保存表字段名字
					po.setFieldDbName(rs.getString(1).toUpperCase());
					if(CodeResourceUtil.JEECG_GENERATE_TABLE_ID.equals(po.getFieldName()));
					if(CodeResourceUtil.JEECG_GENERATE_TABLE_ID.equals(po.getFieldName())||CodeStringUtils.isIn(po.getFieldDbName().toLowerCase(), ui_filter_fields)){
						continue;
					}
					po.setFieldType(formatField(rs.getString(2).toLowerCase()));
					//精度－小数点
					po.setPrecision(rs.getString(4));
					po.setScale(rs.getString(5));
					po.setCharmaxLength(rs.getString(6));
					po.setNullable(TableConvert.getNullAble(rs.getString(7)));
					formatFieldClassType(po);
					po.setFiledComment(StringUtils.isBlank(rs.getString(3))?po.getFieldName():rs.getString(3));
					columntList.add(po);
				}
			}else {
				throw new Exception("该表不存在或都表中没有字段");
			}
		} catch (ClassNotFoundException e) {
			throw e;
		}catch (SQLException e) {
			throw e;
		}finally{
			try {
				if (stmt != null) {
					stmt.close();
					stmt = null;
					System.gc();
				}
				if (conn != null) {
					conn.close();
					conn = null;
					System.gc();
				}
			} catch (SQLException e) {
				throw e;
			}
		}
		
		List<Columnt> rsList = new ArrayList<Columnt>();
		for (int i = columntList.size()-1; i >= 0; i--) {
			Columnt ch = columntList.get(i);
			rsList.add(ch);
		}
		
		return rsList;
	}
	
	
	/**
	 * 根据数据库字段的类型，加载页面样式
	 */
	private void formatFieldClassType(Columnt columnt){
		String fieldType = columnt.getFieldType();
		String scale = columnt.getScale();
		
		columnt.setClassType("inputxt");
		//必须校验判断
		if(ConvertDef.FIELD_NULL_ABLE_N.equals(columnt.getNullable())){
			columnt.setOptionType("*");
		}
		if("datatime".equals(fieldType)||fieldType.contains("time")){
			columnt.setClassType("easyui-datetimebox");
		}else if("date".equals(fieldType)){
			columnt.setClassType("easyui-datebox");
		}else if(fieldType.contains("int")){
			columnt.setOptionType("n");
		}else if(fieldType.equals("number")){
			if(StringUtils.isNotBlank(scale)&&Integer.parseInt(scale)>0){
				columnt.setOptionType("d");
			}
		}else if("float".equals(fieldType)||"double".equals(fieldType)||"decimal".equals(fieldType)){
			columnt.setOptionType("d");
		}else if("numeric".equals(fieldType)){
			columnt.setOptionType("d");
		}
	}
	
	
	/**
	 * 把数据库字段格式成java变量[头字母小写]
	 */
	public static String formatField(String field){
		String[] strs = field.split("_");
		field = "";
		for (int m = 0; m < strs.length; m++) {
			if(m > 0){
				String tempStr = strs[m].toLowerCase();
				tempStr = tempStr.substring(0,1).toUpperCase() + tempStr.substring(1,tempStr.length());
				field += tempStr;
			}else {
				field += strs[m].toLowerCase();
			}
		}
		return field;
	}
	
	/**
	 * 把数据库字段格式成java变量名[头字母大写]
	 * 
	 * @param field
	 * @return
	 */
	public static String formatFieldCapital(String field){
		String[] strs = field.split("_");
		field = "";
		for (int m = 0; m < strs.length; m++) {
			if(m > 0){
				String tempStr = strs[m].toLowerCase();
				tempStr = tempStr.substring(0,1).toUpperCase() + tempStr.substring(1,tempStr.length());
				field += tempStr;
			}else {
				field += strs[m].toLowerCase();
			}
		}
		field = field.substring(0, 1).toUpperCase()+field.substring(1);
		return field;
	}
	
	
	/**
	 * 判断表在数据库中是否存在
	 */
	public boolean checkTableExist(String tableName, String sechma){
		try {
			Class.forName(CodeResourceUtil.DIVER_NAME);
			conn = DriverManager.getConnection(CodeResourceUtil.URL, CodeResourceUtil.USERNAME, CodeResourceUtil.PASSWORD);
			stmt = conn.createStatement(ResultSet.TYPE_SCROLL_SENSITIVE, ResultSet.CONCUR_READ_ONLY);
			
			//mysql
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_MYSQL)){
				sql = "select column_name,data_type,column_comment,0,0 from information_schema.columns"+
						" where table_name = '"+tableName.toUpperCase()+"'"
						+" and table_schema = '"+CodeResourceUtil.DATABASE_NAME+"'"; // 表名
			}
			//oracle
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_ORACLE)){
				if(StringUtil.isNotEmpty(sechma)){
					sql = "select colstable.column_name column_name, colstable.data_type data_type, commentstable.comments column_comment"
							+ " FROM all_tab_cols colstable "
							+ " INNER JOIN all_col_comments commentstable "
							+ " ON colstable.column_name = commentstable.column_name "
							+ " WHERE colstable.table_name = commentstable.table_name "
							+ " AND colstable.table_name = '"+tableName.toUpperCase()+"'"
							+ " AND colstable.owner='"+sechma.toUpperCase()+"' ";
				}else {
					sql = "select colstable.column_name column_name, colstable.data_type data_type, commentstable.comments column_comment"
							+ " from user_tab_cols colstable "
							+ " inner join user_col_comments commentstable "
							+ " on colstable.column_name = commentstable.column_name "
							+ " where colstable.table_name = commentstable.table_name "
							+ " and colstable.table_name = '"
							+ tableName.toUpperCase() + "'"; // 表名
				}
			}
			//postgresql
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_postgresql)){
				sql = MessageFormat.format(ConvertDef.PostgreSQL_db_sql,TableConvert.getV(tableName.toLowerCase()));
			}//sqlserver
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_SQL_SERVER)){
				sql = MessageFormat.format(ConvertDef.sqlserver_db_sql,TableConvert.getV(tableName.toLowerCase()));
			}
			
			rs = stmt.executeQuery(sql);
			rs.last(); // 把指针指向结果集的最后
			int fieldNum = rs.getRow(); // 取得最后一条结果的行号,作为类的属性个数
			if(fieldNum>0){
				return true;
			}
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
		
		return false;
	}
	
	/**
	 * 方法：java类方法
	 */
	public List<Columnt> readOriginalTableColumn(String tableName) throws Exception{
		List<Columnt> columntList = new ArrayList<Columnt>();
		try {
			Class.forName(CodeResourceUtil.DIVER_NAME);
			conn = DriverManager.getConnection(CodeResourceUtil.URL, CodeResourceUtil.USERNAME, CodeResourceUtil.PASSWORD);
			stmt = conn.createStatement(ResultSet.TYPE_SCROLL_SENSITIVE,
					ResultSet.CONCUR_READ_ONLY); // 创建可滚动的,只读的结果集
			//[DB SQL]
			//mysql
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_MYSQL)){
				sql = MessageFormat.format(ConvertDef.mysql_db_sql,TableConvert.getV(tableName.toUpperCase()),TableConvert.getV(CodeResourceUtil.DATABASE_NAME));
			}
			//oracle
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_ORACLE)){
				sql = MessageFormat.format(ConvertDef.oracle_db_sql,TableConvert.getV(tableName.toUpperCase()));
			}
			//postgresql
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_postgresql)){
				sql = MessageFormat.format(ConvertDef.PostgreSQL_db_sql,TableConvert.getV(tableName.toLowerCase()));
			}//sqlserver
			if(CodeResourceUtil.DATABASE_TYPE.equals(ConvertDef.DATABASE_TYPE_SQL_SERVER)){
				sql = MessageFormat.format(ConvertDef.sqlserver_db_sql,TableConvert.getV(tableName.toLowerCase()));
			}
			//---------------------------------------------------------------------------------------
			rs = stmt.executeQuery(sql);
			rs.last(); // 把指针指向结果集的最后
			int fieldNum = rs.getRow(); // 取得最后一条结果的行号,作为类的属性个数
			int n = fieldNum;
			
			if (n > 0) { // 判断数据表中是否存在字段
				Columnt columnt = new Columnt();
				//----begin--------------是否转换字段可配置------------------------------------
				if(CodeResourceUtil.JEECG_FILED_CONVERT){
					columnt.setFieldName(formatField(rs.getString(1).toLowerCase()));
				}else{
					columnt.setFieldName(rs.getString(1).toLowerCase());
				}
				//--end----------------------------------------------------
				//直接保存表字段名字
				columnt.setFieldDbName(rs.getString(1).toUpperCase());
				//精度-小数点
				columnt.setPrecision(TableConvert.getNullString(rs.getString(4)));
				columnt.setScale(TableConvert.getNullString(rs.getString(5)));
				columnt.setCharmaxLength(TableConvert.getNullString(rs.getString(6)));
				columnt.setNullable(TableConvert.getNullAble(rs.getString(7)));
				// 把数据库字段类型转换成java数据类型
				columnt.setFieldType(formatDataType(rs.getString(2).toLowerCase(),columnt.getPrecision(),columnt.getScale()));
				//加载字段页面样式
				formatFieldClassType(columnt);
				columnt.setFiledComment(StringUtils.isBlank(rs.getString(3))?columnt.getFieldName():rs.getString(3));
				

				//过滤建表模板中字段
				//System.out.println("columnt.getFieldName() -------------"+columnt.getFieldName());
				columntList.add(columnt);
				while (rs.previous()) {
					Columnt po = new Columnt();
					//----begin--------------是否转换字段可配置------------------------------------
					if(CodeResourceUtil.JEECG_FILED_CONVERT){
						po.setFieldName(formatField(rs.getString(1).toLowerCase()));
					}else{
						po.setFieldName(rs.getString(1).toLowerCase());
					}
					//--end----------------------------------------------------
					//直接保存表字段名字
					po.setFieldDbName(rs.getString(1).toUpperCase());
					//精度-小数点
					po.setPrecision(TableConvert.getNullString(rs.getString(4)));
					po.setScale(TableConvert.getNullString(rs.getString(5)));
					po.setCharmaxLength(TableConvert.getNullString(rs.getString(6)));
					po.setNullable(TableConvert.getNullAble(rs.getString(7)));
					// 把数据库字段类型转换成java数据类型
					po.setFieldType(formatDataType(rs.getString(2).toLowerCase(),po.getPrecision(),po.getScale()));
					//加载字段页面样式
					formatFieldClassType(po);
					po.setFiledComment(StringUtils.isBlank(rs.getString(3))?po.getFieldName():rs.getString(3));
					columntList.add(po);
				}
			}else {
				throw new Exception("该表不存在或者表中没有字段");
			}
		} catch (ClassNotFoundException e) {
			throw e;
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (stmt != null) {
					stmt.close();
					stmt = null;
					System.gc();
				}
				if (conn != null) {
					conn.close();
					conn = null;
					System.gc();
				}
			} catch (SQLException e) {
				throw e;
			}
		}
		
		
		//纠正顺序
		List<Columnt> rsList = new ArrayList<Columnt>();
			for(int i = columntList.size() - 1;i >= 0;i--){
			Columnt ch = columntList.get(i);
			rsList.add(ch);
		}
		return rsList;
	}
	
	private String formatDataType(String dataType,String precision,String scale) {
		if (dataType.contains("char")) {
			dataType = "java.lang.String";
		} else if (dataType.contains("int")) {
			dataType = "java.lang.Integer";
		} else if (dataType.contains("float")) {
			dataType = "java.lang.Float";
		} else if (dataType.contains("double")) {
			dataType = "java.lang.Double";
		} else if (dataType.contains("number")) {
			if(StringUtils.isNotBlank(scale) && Integer.parseInt(scale)>0){
				dataType = "java.math.BigDecimal";
			}else if(StringUtils.isNotBlank(precision) && Integer.parseInt(precision)>10){
				dataType = "java.lang.Long";
			}else{
				dataType = "java.lang.Integer";
			}
		} else if (dataType.contains("decimal")) {
			dataType = "BigDecimal";
		}else if (dataType.contains("date")) {
			dataType = "java.util.Date";
		} else if (dataType.contains("time")) {
			//dataType = "java.sql.Timestamp";
			dataType = "java.util.Date";
		} else if (dataType.contains("blob")) {
			dataType = "byte[]";
		} else if (dataType.contains("clob")) {
			dataType = "java.sql.Clob";
		} else if (dataType.contains("numeric")) {
			dataType = "BigDecimal";
		} else {
			dataType = "java.lang.Object";
		}
		return dataType;
	}
	
}
