package org.jeecgframework.core.util;

import java.util.List;

import org.jeecgframework.core.extend.hqlsearch.parse.vo.HqlRuleEnum;
import org.jeecgframework.web.system.pojo.base.TSDataRule;

/**
 * 数据库列表序列化转换sql
  * @ClassName: SqlJsonConvert
  * @Description: TODO
  * @author Comsys-skyCc cmzcheng@gmail.com
  * @date 2014-8-25 下午7:12:41
  *
 */
public class SqlJsonConvert {
	
	enum Signal {
	        GREEN, YELLOW, RED
	    }


/**
 * 
  * setSqlModel sql行列转换
  *
  * @Title: setSqlModel
  * @Description: TODO
  * @param @param dataRule
  * @param @return    设定文件
  * @return String    返回类型
  * @throws
 */
	public static String setSqlModel(TSDataRule dataRule){
		String sqlValue="";
		HqlRuleEnum ruleEnum=HqlRuleEnum.getByValue(dataRule.getRuleConditions());
		switch (ruleEnum) {
		case GT:
			sqlValue+=" and "+dataRule.getRuleColumn()+" <'"+dataRule.getRuleValue()+"'";
			break;
		case GE:
			sqlValue+=" and "+dataRule.getRuleColumn()+" >='"+dataRule.getRuleValue()+"'";
			break;
		case LT:
			sqlValue+=" and "+dataRule.getRuleColumn()+" <'"+dataRule.getRuleValue()+"'";
			break;
		case LE:
			sqlValue+=" and "+dataRule.getRuleColumn()+" =>'"+dataRule.getRuleValue()+"'";
			break;
		case  EQ:
			sqlValue+=" and "+dataRule.getRuleColumn()+" ='"+dataRule.getRuleValue()+"'";
			break;
		case LIKE:
			sqlValue+=" and "+dataRule.getRuleColumn()+" like %'"+dataRule.getRuleValue()+"'%";
			break;
		case NE:
			sqlValue+=" and "+dataRule.getRuleColumn()+" !='"+dataRule.getRuleValue()+"'";
			break;
		case IN:
			sqlValue+=" and "+dataRule.getRuleColumn()+" IN('"+dataRule.getRuleValue()+"')";
		default:
			break;
		}
		
		
		return sqlValue;
	}
	
	
///**
// * 
//  * setSqlIn sql为in的方法
//  *
//  * @Title: setSqlIn
//  * @Description: TODO
//  * @param @param dataRule
//  * @param @param sqlValue
//  * @param @return    设定文件
//  * @return String    返回类型
//  * @throws
// */
//	public static String setSqlIn(List<DSDataRule>T dataRule,String sqlValue){
//			sqlValue+="'"+dataRule.getRuleValue()+"',";
//		return sqlValue;
//	}
}
