/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.CodeUtils;
import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.core.BaseCoreUtils;
import com.fr.report.core.gif.GIFEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class BaseUtils {
    private static Map imageMap = new HashMap();
    static /* synthetic */ Class class$com$fr$util$Utils;

    private BaseUtils() {
    }

    public static BufferedImage readImage(String string) {
        Object v = imageMap.get(string);
        if (v instanceof BufferedImage) {
            return (BufferedImage)v;
        }
        InputStream inputStream = BaseUtils.readResource(string);
        if (inputStream == null) {
            return null;
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = BaseUtils.readImage(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
        }
        imageMap.put(string, bufferedImage);
        return bufferedImage;
    }

    public static Icon readIcon(String string) {
        return new ImageIcon(BaseUtils.readImage(string));
    }

    public static BufferedImage readImage(InputStream inputStream) throws IOException {
        return ImageIO.read(inputStream);
    }

    public static BufferedImage readBlobImage(InputStream inputStream) throws IOException {
        return ImageIO.read(new BufferedInputStream(inputStream));
    }

    public static void writeImage(Image image, String string, OutputStream outputStream) {
        try {
            if ("gif".equalsIgnoreCase(string)) {
                GIFEncoder gIFEncoder = new GIFEncoder(image, outputStream);
                gIFEncoder.encode();
            } else {
                ImageIO.write((RenderedImage)BaseCoreUtils.toBufferedImage(image), string, outputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String convertColumnRowToCellString(ColumnRow columnRow) {
        if (columnRow == null) {
            return "";
        }
        return columnRow.toString();
    }

    public static ColumnRow convertCellStringToColumnRow(String string) {
        return ColumnRow.valueOf(string);
    }

    public static String readBuildNo() {
        return BaseUtils.readResourceAsString("build.txt");
    }

    public static String readResourceAsString(String string) {
        return BaseUtils.readResourceAsString(string, "GBK");
    }

    public static String readResourceAsString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        InputStream inputStream = BaseUtils.readResource(string);
        String string3 = null;
        if (inputStream != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string2));
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(string3);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRContext.getLogger().log(Level.WARNING, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
            catch (IOException iOException) {
                FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
            }
        }
        return stringBuffer.toString();
    }

    public static InputStream readResource(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        InputStream inputStream = string.startsWith("/") ? (class$com$fr$util$Utils == null ? (class$com$fr$util$Utils = BaseUtils.class$("com.fr.util.Utils")) : class$com$fr$util$Utils).getResourceAsStream(string) : (class$com$fr$util$Utils == null ? (class$com$fr$util$Utils = BaseUtils.class$("com.fr.util.Utils")) : class$com$fr$util$Utils).getResourceAsStream("/" + string);
        if (inputStream != null) {
            return inputStream;
        }
        if (string.toLowerCase().startsWith("http:")) {
            try {
                return new URL(string).openStream();
            }
            catch (IOException iOException) {
                FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
            }
        }
        try {
            try {
                File file = new File(string);
                if (file.exists()) {
                    return new FileInputStream(string);
                }
            }
            catch (SecurityException securityException) {}
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return null;
    }

    public static String generateActiveKey(String string) {
        byte[] byArray = string.getBytes();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            int n2;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            for (n2 = 2; n2 <= 5; ++n2) {
                n = byArray2[n2] & 0xFF;
                stringBuffer.append((char)(n % 25 + 65));
            }
            stringBuffer.append("-");
            for (n2 = 7; n2 <= 11; ++n2) {
                n = byArray2[n2] & 0xFF;
                if (n2 == 9) {
                    stringBuffer.append(Integer.toHexString(n % 16));
                    continue;
                }
                stringBuffer.append(n % 10);
            }
            stringBuffer.append("-");
            n = byArray2[15] & 0xFF;
            stringBuffer.append((char)(n % 25 + 65));
            for (n2 = 14; n2 >= 12; --n2) {
                n = byArray2[n2] & 0xFF;
                stringBuffer.append(n % 10);
            }
            for (n2 = 6; n2 >= 3; --n2) {
                n = byArray2[n2] & 0xFF;
                stringBuffer.append(Integer.toHexString(n % 16));
            }
            stringBuffer.append("-");
            for (n2 = 4; n2 >= 1; --n2) {
                n = byArray2[n2] & 0xFF;
                stringBuffer.append(n % 10);
            }
            stringBuffer.insert(5, 'A');
            stringBuffer.insert(15, 'F');
            System.out.print(stringBuffer.toString().length());
            return stringBuffer.toString().toUpperCase();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static String addFileSeparator(String string) {
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + File.separator;
            return string;
        }
        return string;
    }

    public static String cjkEncode(String string) {
        return CodeUtils.cjkEncode(string);
    }

    public static String cjkDecode(String string) throws Exception {
        return CodeUtils.cjkDecode(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

