/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.web.core.service.AttachmentService;
import java.awt.Image;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodeUtils {
    private static Pattern bracketPattern = Pattern.compile("\\[[^\\]]*\\]");
    private static Pattern textPattern = Pattern.compile("[0-9a-f]{2,4}", 2);
    private static Pattern blankPattern = Pattern.compile("\\s+");

    private CodeUtils() {
    }

    public static String javascriptEncode(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        char c = '\u0000';
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        block9: for (int i = 0; i < n; ++i) {
            char c2 = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block9;
                }
                case '/': {
                    if (c2 == '<') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                    continue block9;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String string2 = "000" + Integer.toHexString(c);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4));
                        continue block9;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String javascriptDecode(String string) {
        return BaseCoreUtils.encodeString(string, new String[][]{{"\\", "'", "\""}, {"\\\\", "\\'", "\\\""}});
    }

    public static String encodeURIComponent(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return BaseCoreUtils.encodeString(string, new String[][]{{"%20", "%23", "%24", "%26", "%2B", "%2C", "%2F", "%3A", "%3B", "%3D", "%3F", "%40", "%25"}, {" ", "#", "$", "&", "+", ",", "/", ":", ";", "=", "?", "@", "%"}});
        }
    }

    public static String attributeHtmlEncode(CharSequence charSequence) {
        if (charSequence == null) {
            return "";
        }
        int n = charSequence.length();
        StringBuffer stringBuffer = new StringBuffer((int)((double)n * 1.5));
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("&#").append((int)c).append(';');
        }
        return stringBuffer.toString();
    }

    public static String htmlEncode(CharSequence charSequence) {
        if (charSequence == null) {
            return "";
        }
        int n = charSequence.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block9: for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block9;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block9;
                }
                case '\r': {
                    if (i + 1 < n && charSequence.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    stringBuffer.append("<br>");
                    continue block9;
                }
                case '\\': {
                    if (i + 1 < n && charSequence.charAt(i + 1) == 'n') {
                        ++i;
                        stringBuffer.append("<br>");
                        continue block9;
                    }
                    stringBuffer.append(c);
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("<br>");
                    continue block9;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        String string = CodeUtils.replaceBlankToHtmlBlank(stringBuffer.toString());
        return string;
    }

    private static String replaceBlankToHtmlBlank(String string) {
        Matcher matcher = blankPattern.matcher(string);
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (matcher.find()) {
            n2 = matcher.start();
            stringBuffer.append(string.substring(n, n2));
            n = matcher.end();
            String string2 = matcher.group();
            stringBuffer.append(" ");
            int n3 = string2.length() - 1;
            if (n3 <= 1) continue;
            for (int i = n3; i > 1; i -= 2) {
                stringBuffer.append("&nbsp;");
            }
            stringBuffer.append(" ");
        }
        if (n == 0) {
            return string;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String htmlDecode(String string) {
        return BaseCoreUtils.encodeString(string, new String[][]{{" ", "&", "<", ">", "'", "\"", "\\r\\n"}, {"&nbsp;", "&amp;", "&lt;", "&gt;", "&apos;", "&quot;", "<br>"}});
    }

    public static String cjkEncode(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0080' || c == '[' || c == ']') {
                stringBuffer.append("[");
                stringBuffer.append(Integer.toString(c, 16));
                stringBuffer.append("]");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String cjkDecode(String string) throws Exception {
        if (string == null) {
            return "";
        }
        if (string.indexOf(91) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            int n;
            char c = string.charAt(i);
            if (c == '[' && (n = string.indexOf(93, i + 1)) > i + 1) {
                String string2 = string.substring(i + 1, n);
                if (string2.length() > 0) {
                    c = (char)Integer.parseInt(string2, 16);
                }
                i = n;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String jsonEncode(Object object) throws JSONException {
        return JSONObject.valueToString(object);
    }

    public static Object jsonDecode(String string) throws JSONException {
        JSONArray jSONArray = new JSONArray("[" + string + "]");
        return jSONArray.length() == 0 ? null : jSONArray.get(0);
    }

    public static Object object2JSONable(Object object) throws JSONException {
        if (object instanceof Date) {
            return new JSONObject().put("date_milliseconds", new Long(((Date)object).getTime()));
        }
        if (object instanceof Image) {
            return AttachmentService.addAttachment((Image)object).toConfig();
        }
        return object;
    }

    public static String evadeBackslash(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(string.length() * 6);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c)) {
                stringBuffer.append(c);
                continue;
            }
            if (c < '\u0100') {
                stringBuffer.append("%");
                if (c < '\u0010') {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toString(c, 16));
                continue;
            }
            stringBuffer.append("%u");
            stringBuffer.append(Integer.toString(c, 16));
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(string.length());
        int n = 0;
        int n2 = 0;
        while (n < string.length()) {
            n2 = string.indexOf("%", n);
            if (n2 == n) {
                char c;
                if (string.charAt(n2 + 1) == 'u') {
                    c = (char)Integer.parseInt(string.substring(n2 + 2, n2 + 6), 16);
                    stringBuffer.append(c);
                    n = n2 + 6;
                    continue;
                }
                c = (char)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
                stringBuffer.append(c);
                n = n2 + 3;
                continue;
            }
            if (n2 == -1) {
                stringBuffer.append(string.substring(n));
                n = string.length();
                continue;
            }
            stringBuffer.append(string.substring(n, n2));
            n = n2;
        }
        return stringBuffer.toString();
    }

    public static boolean isCJKEncoded(String string) {
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        Matcher matcher = bracketPattern.matcher(string);
        while (matcher.find()) {
            int n;
            bl = true;
            int n2 = matcher.start();
            String string2 = string.substring(n2 + 1, (n = matcher.end()) - 1);
            if (textPattern.matcher(string2).matches()) continue;
            return false;
        }
        return bl;
    }

    public static String carlDecode(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("%fr22", "\"");
        string = string.replaceAll("%fr27", "'");
        return string;
    }
}

