/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.ColumnRowRelated;
import com.fr.base.core.BaseCoreUtils;
import java.io.Serializable;

public class ColumnRow
implements Serializable,
Cloneable,
ColumnRowRelated {
    public final int column;
    public final int row;

    public static ColumnRow valueOf(int n, int n2) {
        if (n >= 0 && n < 5 && n2 >= 0 && n2 < 10) {
            return ColumnRowCache.cache[n][n2];
        }
        return new ColumnRow(n, n2);
    }

    public static ColumnRow valueOf(String string) {
        ColumnRow columnRow = ColumnRow.valueOf(-1, -1);
        if (string == null) {
            return columnRow;
        }
        if (!(string = string.trim()).matches("^[a-zA-Z]+[1-9]\\d*$")) {
            return columnRow;
        }
        try {
            columnRow = ColumnRow.valueOf(BaseCoreUtils.convertABCToInt(string.replaceAll("\\d", "")) - 1, Integer.parseInt(string.replaceAll("[a-zA-Z]", "")) - 1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return columnRow;
    }

    public static boolean validate(ColumnRow columnRow) {
        return columnRow != null && columnRow.getColumn() >= 0 && columnRow.getRow() >= 0;
    }

    private ColumnRow(int n, int n2) {
        this.column = n;
        this.row = n2;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public ColumnRow[] getRelatedColumnRows() {
        return new ColumnRow[]{this};
    }

    public String toString() {
        return BaseCoreUtils.convertIntToABC(this.column + 1) + (this.row + 1);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.column;
        n = 37 * n + this.row;
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColumnRow)) {
            return false;
        }
        ColumnRow columnRow = (ColumnRow)object;
        return this.row == columnRow.row && this.column == columnRow.column;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static class ColumnRowCache {
        static final ColumnRow[][] cache = new ColumnRow[5][10];

        private ColumnRowCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                int n = cache[i].length;
                for (int j = 0; j < n; ++j) {
                    ColumnRowCache.cache[i][j] = new ColumnRow(i, j);
                }
            }
        }
    }
}

