/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ConcurrentHashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    protected transient Entry[] table;
    protected static final int CONCURRENCY_LEVEL = 32;
    protected static final int SEGMENT_MASK = 31;
    protected final Segment[] segments = new Segment[32];
    public static int DEFAULT_INITIAL_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 32;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected final float loadFactor;
    protected int threshold;
    protected volatile transient int votesForResize;
    protected transient Set keySet = null;
    protected transient Set entrySet = null;
    protected transient Collection values = null;

    protected static int bitcount(int n) {
        n -= (0xAAAAAAAA & n) >>> 1;
        n = (n & 0x33333333) + (n >>> 2 & 0x33333333);
        n = n + (n >>> 4) & 0xF0F0F0F;
        n += n >>> 8;
        n += n >>> 16;
        return n & 0xFF;
    }

    private int p2capacity(int n) {
        int n2;
        int n3 = n;
        if (n3 > 0x40000000 || n3 < 0) {
            n2 = 0x40000000;
        } else {
            for (n2 = 32; n2 < n3; n2 <<= 1) {
            }
        }
        return n2;
    }

    protected static int hash(Object object) {
        int n = object.hashCode();
        return (n << 7) - n + (n >>> 9) + (n >>> 17);
    }

    protected boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    protected Entry[] newTable(int n) {
        this.threshold = (int)((float)n * this.loadFactor / 32.0f) + 1;
        return new Entry[n];
    }

    public ConcurrentHashMap(int n, float f) {
        int n2;
        if (!(f > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        this.loadFactor = f;
        for (n2 = 0; n2 < this.segments.length; ++n2) {
            this.segments[n2] = new Segment();
        }
        n2 = this.p2capacity(n);
        this.table = this.newTable(n2);
    }

    public ConcurrentHashMap(int n) {
        this(n, 0.75f);
    }

    public ConcurrentHashMap() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f);
    }

    public ConcurrentHashMap(Map map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 32), 0.75f);
        this.putAll(map);
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this.segments.length; ++i) {
            n += this.segments[i].getCount();
        }
        return n;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i].getCount() == 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        Object object2;
        Entry entry;
        int n = ConcurrentHashMap.hash(object);
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (entry2 != null) {
            if (entry2.hash == n && this.eq(object, entry2.key)) {
                object2 = entry2.value;
                if (object2 == null) break;
                return object2;
            }
            entry2 = entry2.next;
        }
        object2 = this.segments[n & 0x1F];
        Segment segment = object2;
        synchronized (segment) {
            entryArray = this.table;
            n2 = n & entryArray.length - 1;
            Entry entry3 = entryArray[n2];
            if (entry2 != null || entry != entry3) {
                entry2 = entry3;
                while (entry2 != null) {
                    if (entry2.hash == n && this.eq(object, entry2.key)) {
                        return entry2.value;
                    }
                    entry2 = entry2.next;
                }
            }
            return null;
        }
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        int n;
        int n2;
        Entry[] entryArray;
        Segment segment;
        if (object2 == null) {
            throw new NullPointerException();
        }
        int n3 = ConcurrentHashMap.hash(object);
        Segment segment2 = segment = this.segments[n3 & 0x1F];
        synchronized (segment2) {
            Entry entry;
            entryArray = this.table;
            int n4 = n3 & entryArray.length - 1;
            Entry entry2 = entry = entryArray[n4];
            while (entry2 != null) {
                if (entry2.hash == n3 && this.eq(object, entry2.key)) {
                    Object object3 = entry2.value;
                    entry2.value = object2;
                    return object3;
                }
                entry2 = entry2.next;
            }
            entryArray[n4] = entry2 = new Entry(n3, object, object2, entry);
            n2 = ++segment.count;
            if (segment.count < this.threshold) {
                return null;
            }
            n = this.votesForResize;
            int n5 = 1 << (n3 & 0x1F);
            if ((n & n5) == 0) {
                n = this.votesForResize |= n5;
            }
        }
        if (ConcurrentHashMap.bitcount(n) >= 8 || n2 > this.threshold * 32) {
            this.resize(0, entryArray);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putIfAbsent(Object object, Object object2) {
        int n;
        int n2;
        Entry[] entryArray;
        Segment segment;
        if (object2 == null) {
            throw new NullPointerException();
        }
        int n3 = ConcurrentHashMap.hash(object);
        Segment segment2 = segment = this.segments[n3 & 0x1F];
        synchronized (segment2) {
            Entry entry;
            Entry entry2;
            entryArray = this.table;
            int n4 = n3 & entryArray.length - 1;
            Entry entry3 = entry2 = entryArray[n4];
            while (!(entry3 == null || entry3.hash == n3 && this.eq(object, entry3.key))) {
                entry3 = entry3.next;
            }
            if (entry3 != null) {
                Object object3 = entry3.value;
                return object3;
            }
            Object var12_11 = null;
            entryArray[n4] = entry = new Entry(n3, object, object2, entry2);
            n2 = ++segment.count;
            if (segment.count < this.threshold) {
                return null;
            }
            n = this.votesForResize;
            int n5 = 1 << (n3 & 0x1F);
            if ((n & n5) == 0) {
                n = this.votesForResize |= n5;
            }
        }
        if (ConcurrentHashMap.bitcount(n) >= 8 || n2 > this.threshold * 32) {
            this.resize(0, entryArray);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resize(int n, Entry[] entryArray) {
        Segment segment;
        Segment segment2 = segment = this.segments[n];
        synchronized (segment2) {
            if (entryArray == this.table) {
                int n2 = n + 1;
                if (n2 < this.segments.length) {
                    this.resize(n2, entryArray);
                } else {
                    this.rehash();
                }
            }
        }
    }

    protected void rehash() {
        this.votesForResize = 0;
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        if (n >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int n2 = n << 1;
        Entry[] entryArray2 = this.newTable(n2);
        int n3 = n2 - 1;
        for (int i = 0; i < n; ++i) {
            int n4;
            Entry entry = entryArray[i];
            if (entry == null) continue;
            int n5 = entry.hash & n3;
            Entry entry2 = entry.next;
            if (entry2 == null) {
                entryArray2[n5] = entry;
                continue;
            }
            Entry entry3 = entry;
            int n6 = n5;
            Entry entry4 = entry2;
            while (entry4 != null) {
                n4 = entry4.hash & n3;
                if (n4 != n6) {
                    n6 = n4;
                    entry3 = entry4;
                }
                entry4 = entry4.next;
            }
            entryArray2[n6] = entry3;
            entry4 = entry;
            while (entry4 != entry3) {
                n4 = entry4.hash & n3;
                entryArray2[n4] = new Entry(entry4.hash, entry4.key, entry4.value, entryArray2[n4]);
                entry4 = entry4.next;
            }
        }
        this.table = entryArray2;
    }

    public Object remove(Object object) {
        return this.remove(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object remove(Object object, Object object2) {
        Segment segment;
        int n = ConcurrentHashMap.hash(object);
        Segment segment2 = segment = this.segments[n & 0x1F];
        synchronized (segment2) {
            Entry entry;
            Entry[] entryArray = this.table;
            int n2 = n & entryArray.length - 1;
            Entry entry2 = entry = entryArray[n2];
            while (true) {
                if (entry2 == null) {
                    return null;
                }
                if (entry2.hash == n && this.eq(object, entry2.key)) break;
                entry2 = entry2.next;
            }
            Object object3 = entry2.value;
            if (object2 != null && !object2.equals(object3)) {
                return null;
            }
            entry2.value = null;
            Entry entry3 = entry2.next;
            Entry entry4 = entry;
            while (entry4 != entry2) {
                entry3 = new Entry(entry4.hash, entry4.key, entry4.value, entry3);
                entry4 = entry4.next;
            }
            entryArray[n2] = entry3;
            --segment.count;
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.segments.length; ++i) {
            Entry[] entryArray;
            Segment segment;
            Segment segment2 = segment = this.segments[i];
            synchronized (segment2) {
                entryArray = this.table;
            }
            for (int j = i; j < entryArray.length; j += this.segments.length) {
                Entry entry = entryArray[j];
                while (entry != null) {
                    if (object.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map map) {
        Object object;
        int n = map.size();
        if (n == 0) {
            return;
        }
        while (true) {
            int n2;
            Segment segment = this.segments[0];
            synchronized (segment) {
                object = this.table;
                n2 = this.threshold * 32;
            }
            if (n < n2) break;
            this.resize(0, (Entry[])object);
        }
        object = map.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            Segment segment;
            Segment segment2 = segment = this.segments[i];
            synchronized (segment2) {
                Entry[] entryArray = this.table;
                for (int j = i; j < entryArray.length; j += this.segments.length) {
                    Entry entry = entryArray[j];
                    while (entry != null) {
                        entry.value = null;
                        entry = entry.next;
                    }
                    entryArray[j] = null;
                    segment.count = 0;
                }
                continue;
            }
        }
    }

    public Object clone() {
        return new ConcurrentHashMap(this);
    }

    public Set keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    public Set entrySet() {
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new EntrySet());
    }

    public Enumeration keys() {
        return new KeyIterator();
    }

    public Enumeration elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.defaultWriteObject();
        Segment segment = this.segments[0];
        synchronized (segment) {
            n = this.table.length;
        }
        objectOutputStream.writeInt(n);
        for (int i = 0; i < this.segments.length; ++i) {
            Entry[] entryArray;
            Segment segment2;
            Segment segment3 = segment2 = this.segments[i];
            synchronized (segment3) {
                entryArray = this.table;
            }
            for (int j = i; j < entryArray.length; j += this.segments.length) {
                Entry entry = entryArray[j];
                while (entry != null) {
                    objectOutputStream.writeObject(entry.key);
                    objectOutputStream.writeObject(entry.value);
                    entry = entry.next;
                }
            }
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = this.newTable(n);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment();
        }
        while (true) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (object == null) break;
            this.put(object, object2);
        }
    }

    protected class ValueIterator
    extends HashIterator {
        protected ValueIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentValue;
        }
    }

    protected class KeyIterator
    extends HashIterator {
        protected KeyIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentKey;
        }
    }

    protected class HashIterator
    implements Iterator,
    Enumeration {
        protected final Entry[] tab;
        protected int index;
        protected Entry entry = null;
        protected Object currentKey;
        protected Object currentValue;
        protected Entry lastReturned = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HashIterator() {
            Segment segment = ConcurrentHashMap.this.segments[0];
            synchronized (segment) {
                this.tab = ConcurrentHashMap.this.table;
            }
            for (int i = 1; i < ConcurrentHashMap.this.segments.length; ++i) {
                ConcurrentHashMap.this.segments[i].synch();
            }
            this.index = this.tab.length - 1;
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public Object nextElement() {
            return this.next();
        }

        public boolean hasNext() {
            do {
                if (this.entry != null) {
                    Object object = this.entry.value;
                    if (object != null) {
                        this.currentKey = this.entry.key;
                        this.currentValue = object;
                        return true;
                    }
                    this.entry = this.entry.next;
                }
                while (this.entry == null && this.index >= 0) {
                    this.entry = this.tab[this.index--];
                }
            } while (this.entry != null);
            this.currentValue = null;
            this.currentKey = null;
            return false;
        }

        protected Object returnValueOfNext() {
            return this.entry;
        }

        public Object next() {
            if (this.currentKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.returnValueOfNext();
            this.lastReturned = this.entry;
            this.currentValue = null;
            this.currentKey = null;
            this.entry = this.entry.next;
            return object;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    protected static class Entry
    implements Map.Entry {
        protected final Object key;
        protected volatile Object value;
        protected final int hash;
        protected final Entry next;

        Entry(int n, Object object, Object object2, Entry entry) {
            this.value = object2;
            this.hash = n;
            this.key = object;
            this.next = entry;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.key.equals(entry.getKey()) && this.value.equals(entry.getValue());
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new HashIterator();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = ConcurrentHashMap.this.get(entry.getKey());
            return object2 != null && object2.equals(entry.getValue());
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ConcurrentHashMap.this.remove(entry.getKey(), entry.getValue()) != null;
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsValue(object);
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return ConcurrentHashMap.this.remove(object) != null;
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    protected static final class Segment
    implements Serializable {
        protected int count;

        protected Segment() {
        }

        protected synchronized int getCount() {
            return this.count;
        }

        protected synchronized void synch() {
        }
    }
}

