/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.DefaultValues;
import com.fr.base.Inter;
import com.fr.base.XMLTools;
import com.fr.base.dav.Env;
import com.fr.base.file.CacheManager;
import com.fr.base.file.ClusterConfigManager;
import com.fr.base.file.ConfigManager;
import com.fr.base.file.DatasourceManager;
import com.fr.base.file.FaceManager;
import com.fr.base.file.FunctionManager;
import com.fr.data.impl.Connection;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.privilege.manager.PrivilegeManager;
import com.fr.report.io.xml.SynchronizedVersion;
import com.fr.report.web.ui.WidgetManager;
import com.fr.web.platform.PlatformManager;
import com.fr.web.platform.module.ModuleManager;
import java.io.InputStream;
import java.util.Locale;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class FRContext {
    private static FunctionManager functionManager = null;
    private static PlatformManager platformManager = null;
    private static PrivilegeManager privilegeManager = null;
    private static FaceManager faceManager = null;
    private static ConfigManager configManager = null;
    private static ModuleManager moduleManager = null;
    private static DatasourceManager datasourceManager = null;
    private static CacheManager cacheManager = null;
    private static WidgetManager widgetManager = null;
    private static ClusterConfigManager clusterConfigManager = null;
    private static Locale locale = Locale.CHINA;
    private static Logger logger = null;
    private static DefaultValues defaultValues = null;
    private static Env env = null;

    private FRContext() {
    }

    public static synchronized JDBCDatabaseConnection getPlatformConnection() {
        Connection connection = FRContext.getDatasourceManager().getConnection("fr_platform");
        if (connection instanceof JDBCDatabaseConnection) {
            return (JDBCDatabaseConnection)connection;
        }
        return null;
    }

    public static synchronized void setPlatformConnection(JDBCDatabaseConnection jDBCDatabaseConnection) {
        FRContext.getDatasourceManager().putConnection("fr_platform", jDBCDatabaseConnection);
    }

    public static synchronized FunctionManager getFunctionManager() {
        if (functionManager == null) {
            functionManager = new FunctionManager();
            functionManager.readXMLFile();
        }
        return functionManager;
    }

    public static synchronized void setFunctionManager(FunctionManager functionManager) {
        FRContext.functionManager = functionManager;
    }

    public static synchronized PlatformManager getPlatformManager() {
        if (platformManager == null) {
            platformManager = new PlatformManager();
            platformManager.readXMLFile();
        }
        return platformManager;
    }

    public static synchronized PrivilegeManager getPrivilegeManager() {
        if (privilegeManager == null) {
            privilegeManager = new PrivilegeManager();
            privilegeManager.readXMLFile();
        }
        return privilegeManager;
    }

    public static synchronized void setPrivilegeManager(PrivilegeManager privilegeManager) {
        FRContext.privilegeManager = privilegeManager;
    }

    public static synchronized ModuleManager getModuleManager() {
        if (moduleManager == null) {
            moduleManager = new ModuleManager();
            moduleManager.readXMLFile();
        }
        return moduleManager;
    }

    public static synchronized void setModuleManager(ModuleManager moduleManager) {
        FRContext.moduleManager = moduleManager;
    }

    public static synchronized FaceManager getFaceManager() {
        if (faceManager == null) {
            faceManager = new FaceManager();
            faceManager.readXMLFile();
        }
        return faceManager;
    }

    public static synchronized void setFaceManager(FaceManager faceManager) {
        FRContext.faceManager = faceManager;
    }

    public static synchronized DatasourceManager getDatasourceManager() {
        if (datasourceManager == null) {
            datasourceManager = new DatasourceManager();
            datasourceManager.readXMLFile();
        }
        SynchronizedVersion.removeSynchronizedVersion(Thread.currentThread());
        return datasourceManager;
    }

    public static synchronized void setDatasourceManager(DatasourceManager datasourceManager) {
        FRContext.datasourceManager = datasourceManager;
    }

    public static synchronized void refreshDatasourceManager() {
        DatasourceManager datasourceManager = new DatasourceManager();
        if (!datasourceManager.readXMLFile()) {
            return;
        }
        SynchronizedVersion.removeSynchronizedVersion(Thread.currentThread());
        FRContext.datasourceManager = datasourceManager;
    }

    public static synchronized WidgetManager getWidgetManager() {
        if (widgetManager == null) {
            widgetManager = new WidgetManager();
            widgetManager.readXMLFile();
        }
        return widgetManager;
    }

    public static synchronized void setWidgetManager(WidgetManager widgetManager) {
        FRContext.widgetManager = widgetManager;
    }

    public static synchronized ClusterConfigManager getClusterConfigManager() {
        if (clusterConfigManager == null) {
            clusterConfigManager = new ClusterConfigManager();
            clusterConfigManager.readXMLFile();
        }
        return clusterConfigManager;
    }

    public static synchronized void setClusterConfigManager(ClusterConfigManager clusterConfigManager) {
        FRContext.clusterConfigManager = clusterConfigManager;
    }

    public static synchronized CacheManager getCacheManager() {
        if (cacheManager == null) {
            cacheManager = new CacheManager();
            cacheManager.readXMLFile();
        }
        return cacheManager;
    }

    public static synchronized void setCacheManager(CacheManager cacheManager) {
        FRContext.cacheManager = cacheManager;
    }

    public static synchronized ConfigManager getConfigManager() {
        InputStream inputStream;
        if (configManager == null && !(configManager = new ConfigManager()).readXMLFile() && (inputStream = FRContext.getResourceStream("ReportServerParameter.rxml")) != null) {
            try {
                XMLTools.readInputStreamXML(configManager, inputStream);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return configManager;
    }

    public static synchronized void setConfigManager(ConfigManager configManager) {
        FRContext.configManager = configManager;
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        FRContext.locale = locale;
    }

    public static void setLanguage(int n) {
        switch (n) {
            case 2: {
                locale = Locale.US;
                break;
            }
            case 3: {
                locale = Locale.JAPAN;
                break;
            }
            case 1: {
                locale = Locale.CHINA;
                break;
            }
            case 4: {
                locale = Locale.TAIWAN;
                break;
            }
            default: {
                locale = Locale.CHINA;
            }
        }
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("FR");
            logger.setLevel(Level.WARNING);
            logger.setUseParentHandlers(false);
            logger.addHandler(new ConsoleHandler(){

                public void publish(LogRecord logRecord) {
                    logRecord.setSourceClassName("");
                    super.publish(logRecord);
                }
            });
        }
        return logger;
    }

    public static DefaultValues getDefaultValues() {
        if (defaultValues == null) {
            defaultValues = new DefaultValues();
        }
        return defaultValues;
    }

    public static void setDefaultValues(DefaultValues defaultValues) {
        FRContext.defaultValues = defaultValues;
    }

    public static InputStream getResourceStream(String string) {
        Env env = FRContext.getCurrentEnv();
        if (env != null) {
            try {
                InputStream inputStream = env.readResource(string);
                if (inputStream != null) {
                    FRContext.getLogger().log(Level.INFO, Inter.getLocText("Load_Resource_File") + ":\"" + string + "\".");
                }
                return inputStream;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Env getCurrentEnv() {
        return env;
    }

    public static void setCurrentEnv(Env env) {
        FRContext.env = env;
        configManager = null;
        datasourceManager = null;
        widgetManager = null;
        faceManager = null;
        functionManager = null;
        privilegeManager = null;
        moduleManager = null;
        cacheManager = null;
        clusterConfigManager = null;
        defaultValues = null;
    }
}

