/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.Inter;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.chart.core.ChartUtils;
import java.awt.Color;
import java.awt.Font;
import java.io.InvalidObjectException;
import java.util.Map;
import java.util.WeakHashMap;

public class FRFont
extends Font
implements Cloneable {
    private static final long serialVersionUID = -4341538101804628719L;
    private static final String DEFAULT_FONTNAME = "SimSun";
    private static Map initializeFRFont = new WeakHashMap();
    private Color foreground = Color.black;
    private byte underline = 0;
    private boolean strikethrough = false;
    private boolean shadow = false;
    private boolean superscript = false;
    private boolean subscript = false;
    static /* synthetic */ Class class$com$fr$base$FRFont;

    public static FRFont getInstance() {
        return FRFont.getInstance(DEFAULT_FONTNAME, 0, 12);
    }

    public static FRFont getInstance(Font font) {
        return FRFont.getInstance(font.getName(), font.getStyle(), font.getSize());
    }

    public static FRFont getInstance(String string, int n, int n2) {
        return FRFont.getInstance(string, n, n2, Color.black, 0, false, false, false, false);
    }

    public static FRFont getInstance(String string, int n, int n2, Color color) {
        return FRFont.getInstance(string, n, n2, color, 0, false, false, false, false);
    }

    public static FRFont getInstance(String string, int n, int n2, Color color, int n3) {
        return FRFont.getInstance(string, n, n2, color, n3, false, false, false, false);
    }

    public static FRFont getInstance(String string, int n, int n2, Color color, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        FK fK = new FK(string, n, n2, color, n3, bl, bl2, bl3, bl4);
        Object v = initializeFRFont.get(fK);
        if (v != null) {
            return (FRFont)v;
        }
        FRFont fRFont = new FRFont(string, n, n2, color, n3, bl, bl2, bl3, bl4);
        initializeFRFont.put(fK, fRFont);
        return fRFont;
    }

    private FRFont(String string, int n, int n2, Color color, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(string, n, n2);
        this.foreground = color;
        this.underline = (byte)n3;
        this.strikethrough = bl;
        this.shadow = bl2;
        this.superscript = bl3;
        this.subscript = bl4;
    }

    public String getStyleName() {
        int n = this.getStyle();
        if (n == 1) {
            return Inter.getLocText("FRFont-bold");
        }
        if (n == 2) {
            return Inter.getLocText("FRFont-italic");
        }
        if (n == 3) {
            return Inter.getLocText("FRFont-bolditalic");
        }
        return Inter.getLocText("FRFont-plain");
    }

    public FRFont applyName(String string) {
        return FRFont.getInstance(string, this.style, this.size, this.foreground, this.underline, this.strikethrough, this.shadow, this.superscript, this.subscript);
    }

    public FRFont applyStyle(int n) {
        return FRFont.getInstance(this.name, n, this.size, this.foreground, this.underline, this.strikethrough, this.shadow, this.superscript, this.subscript);
    }

    public FRFont applySize(int n) {
        return FRFont.getInstance(this.name, this.style, n, this.foreground, this.underline, this.strikethrough, this.shadow, this.superscript, this.subscript);
    }

    public FRFont applyForeground(Color color) {
        return FRFont.getInstance(this.name, this.style, this.size, color, this.underline, this.strikethrough, this.shadow, this.superscript, this.subscript);
    }

    public FRFont applyUnderline(int n) {
        return FRFont.getInstance(this.name, this.style, this.size, this.foreground, n, this.strikethrough, this.shadow, this.superscript, this.subscript);
    }

    public FRFont applyStrikethrough(boolean bl) {
        return FRFont.getInstance(this.name, this.style, this.size, this.foreground, this.underline, bl, this.shadow, this.superscript, this.subscript);
    }

    public FRFont applyShadow(boolean bl) {
        return FRFont.getInstance(this.name, this.style, this.size, this.foreground, this.underline, this.strikethrough, bl, this.superscript, this.subscript);
    }

    public FRFont applySuperscript(boolean bl) {
        return FRFont.getInstance(this.name, this.style, this.size, this.foreground, this.underline, this.strikethrough, this.shadow, bl, this.subscript);
    }

    public FRFont applySubscript(boolean bl) {
        return FRFont.getInstance(this.name, this.style, this.size, this.foreground, this.underline, this.strikethrough, this.shadow, this.superscript, bl);
    }

    public Color getForeground() {
        return this.foreground;
    }

    public int getUnderline() {
        return this.underline;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public boolean isSuperscript() {
        return this.superscript;
    }

    public boolean isSubscript() {
        return this.subscript;
    }

    public int hashCode() {
        int n = super.hashCode();
        if (this.foreground != null) {
            n += this.foreground.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof FRFont)) {
            return false;
        }
        FRFont fRFont = (FRFont)object;
        return super.equals(object) && ComparatorUtils.equals(fRFont.getForeground(), this.getForeground()) && fRFont.getUnderline() == this.getUnderline() && fRFont.isStrikethrough() == this.isStrikethrough() && fRFont.isShadow() == this.isShadow() && fRFont.isSuperscript() == this.isSuperscript() && fRFont.isSubscript() == this.isSubscript();
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("color", ChartUtils.color2JS(this.getForeground()));
        jSONObject.put("size", this.getSize());
        jSONObject.put("fontName", this.getName());
        jSONObject.put("style", ChartUtils.fontStyle2JS(this.getStyle()));
        return jSONObject;
    }

    protected Object readResolve() throws InvalidObjectException {
        if (this.getClass() != (class$com$fr$base$FRFont == null ? (class$com$fr$base$FRFont = FRFont.class$("com.fr.base.FRFont")) : class$com$fr$base$FRFont)) {
            throw new InvalidObjectException("subclass didn't correctly implement readResolve");
        }
        FK fK = new FK(this);
        Object object = initializeFRFont.get(fK);
        if (object == null) {
            object = this;
            initializeFRFont.put(fK, object);
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class FK {
        String name;
        int style;
        int size;
        Color foreground;
        int underline;
        boolean strikethrough;
        boolean shadow;
        boolean superscript;
        boolean subscript;

        FK(FRFont fRFont) {
            this(fRFont.name, fRFont.style, fRFont.size, fRFont.foreground, fRFont.underline, fRFont.strikethrough, fRFont.shadow, fRFont.superscript, fRFont.subscript);
        }

        FK(String string, int n, int n2, Color color, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.name = string;
            this.style = n;
            this.size = n2;
            this.foreground = color;
            this.underline = n3;
            this.strikethrough = bl;
            this.shadow = bl2;
            this.superscript = bl3;
            this.subscript = bl4;
        }

        public int hashCode() {
            return (this.name != null ? this.name.hashCode() : 0) ^ this.style ^ this.size ^ (this.foreground != null ? this.foreground.hashCode() : 0);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof FK)) {
                return false;
            }
            FK fK = (FK)object;
            if (this.name == null && fK.name != null || fK.name == null && this.name != null) {
                return false;
            }
            return this.name.equals(fK.name) && this.style == fK.style && this.size == fK.size && ComparatorUtils.equals(this.foreground, fK.foreground) && this.underline == fK.underline && this.strikethrough == fK.strikethrough && this.shadow == fK.shadow && this.superscript == fK.superscript && this.subscript == fK.subscript;
        }
    }
}

