/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String EMPTY = "";
    public static final String BLANK = " ";

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static boolean isBlank(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String string) {
        return !StringUtils.isBlank(string);
    }

    public static String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static String trimToNull(String string) {
        String string2 = StringUtils.trim(string);
        return StringUtils.isEmpty(string2) ? null : string2;
    }

    public static String trimToEmpty(String string) {
        return string == null ? EMPTY : string.trim();
    }

    public static int stringToInt(String string) {
        return StringUtils.stringToInt(string, 0);
    }

    public static int stringToInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static String perfectStart(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string.startsWith(string2) ? string : string2 + string;
    }

    public static String perfectEnd(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string.endsWith(string2) ? string : string + string2;
    }

    public static String ignoreCaseReplaceAll(String string, String string2, String string3) {
        Pattern pattern = Pattern.compile(string2, 2);
        Matcher matcher = pattern.matcher(string);
        String string4 = matcher.replaceAll(string3);
        return string4;
    }

    public static boolean equalsIgnore(String string, String string2, String string3) {
        return StringUtils.perfectStart(StringUtils.perfectEnd(string, string3), string3).equals(StringUtils.perfectStart(StringUtils.perfectEnd(string2, string3), string3));
    }

    public static boolean containChinese(String string) {
        if (StringUtils.isBlank(string)) {
            return false;
        }
        return !string.matches("[^\u4e00-\u9fa5]*");
    }
}

