/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.DefaultValues;
import com.fr.base.FRContext;
import com.fr.base.FRFont;
import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.core.ComparatorUtils;
import com.fr.report.io.core.IOHelper;
import com.fr.util.Utils;
import java.awt.Color;
import java.awt.Font;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.text.Format;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class Style
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1675056857456167839L;
    private static Map clsFontFamily = new HashMap(){
        private static final long serialVersionUID = -6898424690912166160L;
        {
            this.put("Arial Black", "fnab");
            this.put("Basic Sans SF", "fnbs");
            this.put("Book Antiqua", "fnba");
            this.put("Calibri", "fnci");
            this.put("Comic Sans MS", "fncs");
            this.put("Courier New", "fncn");
            this.put("Elementary SF", "fnes");
            this.put("Garamond", "fngd");
            this.put("Georgia", "fnga");
            this.put("Letter Gothic", "fnlg");
            this.put("Lucida Console", "fnlc");
            this.put("Marigold", "fnmd");
            this.put("MS Sans Serif", "fnms");
            this.put("MS Gothic", "fnmg");
            this.put("MS PGothic", "fnmpg");
            this.put("MS Mincho", "fnmm");
            this.put("MS P Mincho", "fnmpm");
            this.put("MingLiU", "fnml");
            this.put("SimHei", "fnsh");
            this.put("System", "fnsm");
            this.put("Tahoma", "fnta");
            this.put("Times New Roman", "fntn");
            this.put("Trebuchet MS", "fntms");
            this.put("Verdana", "fnva");
            this.put("SimSun", "fnss");
            this.put("Arial", "fnar");
            this.put("\u5fae\u8f6f\u96c5\u9ed1", "fnyh");
            this.put("Microsoft YaHei", "fnyh");
            this.put("\u6977\u4f53", "fnkt");
            this.put("KaiTi", "fnkt");
        }
    };
    private static Map initializeStyle = new WeakHashMap();
    public static final int TextStyle_WrapText = 0;
    public static final int TextStyle_SingleLine = 1;
    public static final int TextStyle_SingleLineAdjustFont = 2;
    public static final int TextStyle_MultiLineAdjustFont = 3;
    public static final int VERTICALTEXT = 1;
    public static final int HORIZONTALTEXT = 0;
    public static final int LEFT_TO_RIGHT = 1;
    public static final int RIGHT_TO_LEFT = 0;
    private Format format = null;
    private FRFont frFont = null;
    private Background background = null;
    private byte border_top = 0;
    private byte border_left = 0;
    private byte border_bottom = 0;
    private byte border_right = 0;
    private Color border_top_color = Color.black;
    private Color border_left_color = Color.black;
    private Color border_bottom_color = Color.black;
    private Color border_right_color = Color.black;
    private int horizontal_alignment = 2;
    private int vertical_alignment = 0;
    private int textStyle = 0;
    private int verticalText = 0;
    private int textDirection = 0;
    private int rotation = 0;
    private byte imageLayout = (byte)3;
    private byte paddingLeft = (byte)2;
    private byte paddingRight = (byte)2;
    private byte spacingBefore = 0;
    private byte spacingAfter = 0;
    private byte lineSpacing = 0;
    private String contentClsCss = "";
    private Map contentStyleCssMap = new HashMap();
    private String borderClsCss = "";
    private Map borderStyleCssMap = new HashMap();
    public static Style DEFAULT_STYLE = new Style();
    public static Style BORDER_STYLE;
    static /* synthetic */ Class class$com$fr$base$Style;

    public static Style getInstance() {
        Style style = new Style();
        Object v = initializeStyle.get(style);
        if (v != null) {
            return (Style)v;
        }
        initializeStyle.put(style, style);
        return style;
    }

    private static Style getInstance(Background background, Format format, FRFont fRFont, int n, Color color, int n2, Color color2, int n3, Color color3, int n4, Color color4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        Style style = new Style(background, format, fRFont, n, color, n2, color2, n3, color3, n4, color4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16);
        Object v = initializeStyle.get(style);
        if (v != null) {
            return (Style)v;
        }
        initializeStyle.put(style, style);
        return style;
    }

    protected Style() {
        DefaultValues defaultValues = FRContext.getDefaultValues();
        this.frFont = defaultValues.getFRFont();
        this.contentClsCss = this.contentStyle2class(this.contentStyleCssMap);
        this.borderClsCss = this.border2Class(this.borderStyleCssMap);
    }

    private Style(Background background, Format format, FRFont fRFont, int n, Color color, int n2, Color color2, int n3, Color color3, int n4, Color color4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        this.background = background;
        this.format = format;
        this.frFont = fRFont;
        this.border_top = (byte)n;
        this.border_top_color = color;
        this.border_bottom = (byte)n2;
        this.border_bottom_color = color2;
        this.border_left = (byte)n3;
        this.border_left_color = color3;
        this.border_right = (byte)n4;
        this.border_right_color = color4;
        this.horizontal_alignment = (byte)n5;
        this.vertical_alignment = (byte)n6;
        this.textStyle = (byte)n7;
        this.verticalText = (byte)n8;
        this.textDirection = (byte)n9;
        this.rotation = (short)n10;
        this.imageLayout = (byte)n11;
        this.paddingLeft = (byte)n12;
        this.paddingRight = (byte)n13;
        this.spacingBefore = (byte)n14;
        this.spacingAfter = (byte)n15;
        this.lineSpacing = (byte)n16;
        this.contentClsCss = this.contentStyle2class(this.contentStyleCssMap);
        this.borderClsCss = this.border2Class(this.borderStyleCssMap);
    }

    public Style deriveFormat(Format format) {
        return Style.getInstance(this.background, format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public static Style getInstance(Format format) {
        return DEFAULT_STYLE.deriveFormat(format);
    }

    public Style deriveFRFont(FRFont fRFont) {
        return Style.getInstance(this.background, this.format, fRFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public static Style getInstance(FRFont fRFont) {
        return DEFAULT_STYLE.deriveFRFont(fRFont);
    }

    public Style deriveBackground(Background background) {
        return Style.getInstance(background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public static Style getInstance(Background background) {
        return DEFAULT_STYLE.deriveBackground(background);
    }

    public Style deriveBorderBackgroundNone() {
        return Style.getInstance(null, this.format, this.frFont, 0, this.border_top_color, 0, this.border_bottom_color, 0, this.border_left_color, 0, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveBorder(int n, Color color, int n2, Color color2, int n3, Color color3, int n4, Color color4) {
        return Style.getInstance(this.background, this.format, this.frFont, n, color, n2, color2, n3, color3, n4, color4, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveBorderTop(int n, Color color) {
        return Style.getInstance(this.background, this.format, this.frFont, n, color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveBorderBottom(int n, Color color) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, n, color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveBorderLeft(int n, Color color) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, n, color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveBorderRight(int n, Color color) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, n, color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveHorizontalAlignment(int n) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, n, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveVerticalAlignment(int n) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, n, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveTextStyle(int n) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, n, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveTextDirection(int n) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, n, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveVerticalText(int n) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, n, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveRotation(int n) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, n, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveImageLayout(int n) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, n, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style derivePadding(int n, int n2) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, n, n2, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style derivePaddingLeft(int n) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, n, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style derivePaddingRight(int n) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, n, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveSpacingBefore(int n) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, n, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveSpacingAfter(int n) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, n, this.lineSpacing);
    }

    public Style deriveLineSpacing(int n) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, n);
    }

    public FRFont getFRFont() {
        if (this.frFont == null) {
            this.frFont = FRContext.getDefaultValues().getFRFont();
        }
        return this.frFont;
    }

    public Format getFormat() {
        return this.format;
    }

    public Background getBackground() {
        return this.background;
    }

    public int getBorderTop() {
        return this.border_top;
    }

    public int getBorderLeft() {
        return this.border_left;
    }

    public int getBorderBottom() {
        return this.border_bottom;
    }

    public int getBorderRight() {
        return this.border_right;
    }

    public Color getBorderTopColor() {
        return this.border_top_color;
    }

    public Color getBorderLeftColor() {
        return this.border_left_color;
    }

    public Color getBorderBottomColor() {
        return this.border_bottom_color;
    }

    public Color getBorderRightColor() {
        return this.border_right_color;
    }

    public int getHorizontalAlignment() {
        return this.horizontal_alignment;
    }

    public int getVerticalAlignment() {
        return this.vertical_alignment;
    }

    public int getTextStyle() {
        return this.textStyle;
    }

    public int getVerticalText() {
        return this.verticalText;
    }

    public int getTextDirection() {
        return this.textDirection;
    }

    public int getRotation() {
        return this.rotation;
    }

    public int getImageLayout() {
        return this.imageLayout;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public byte getSpacingBefore() {
        return this.spacingBefore;
    }

    public byte getSpacingAfter() {
        return this.spacingAfter;
    }

    public byte getLineSpacing() {
        return this.lineSpacing;
    }

    public String getContentClsCss() {
        return this.contentClsCss;
    }

    public Map getContentStyleCssMap() {
        return this.contentStyleCssMap;
    }

    public String getBorderClsCss() {
        return this.borderClsCss;
    }

    public Map getBorderStyleCssMap() {
        return this.borderStyleCssMap;
    }

    private String contentStyle2class(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("fh");
        switch (this.horizontal_alignment) {
            case 0: {
                stringBuffer.append(" tac");
                break;
            }
            case 4: {
                stringBuffer.append(" tar");
            }
        }
        switch (this.vertical_alignment) {
            case 3: {
                stringBuffer.append(" vab");
                break;
            }
            case 1: {
                stringBuffer.append(" vat");
            }
        }
        if (this.textStyle != 0 && this.textStyle != 3) {
            stringBuffer.append(" nw");
        } else {
            stringBuffer.append(" bw");
        }
        FRFont fRFont = this.getFRFont();
        if (fRFont != null) {
            stringBuffer.append(Style.font2Class(fRFont, map));
        }
        byte by = this.paddingLeft;
        byte by2 = this.paddingRight;
        if (by < 2) {
            stringBuffer.append(" pl" + by);
        } else if (by > 2) {
            map.put("padding-left", by + "px");
        }
        if (by2 < 2) {
            stringBuffer.append(" pr" + by2);
        } else if (by2 > 2) {
            map.put("padding-right", by2 + "px;");
        }
        return stringBuffer.toString().trim();
    }

    private String border2Class(Map map) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.border_left == 0 && this.border_right == 0 && this.border_top == 0 && this.border_bottom == 0) {
            stringBuffer.append(" b0");
            return stringBuffer.toString().trim();
        }
        if (this.border_left == 1 && this.border_right == 1 && this.border_top == 1 && this.border_bottom == 1 && ComparatorUtils.equals(this.border_left_color, Color.black) && ComparatorUtils.equals(this.border_right_color, Color.black) && ComparatorUtils.equals(this.border_top_color, Color.black) && ComparatorUtils.equals(this.border_bottom_color, Color.black)) {
            stringBuffer.append(" b1");
            return stringBuffer.toString().trim();
        }
        if (this.border_right == 1 && ComparatorUtils.equals(this.border_right_color, Color.black)) {
            stringBuffer.append(" br1");
        } else {
            n = IOHelper.getBorderWidth(this.border_right);
            if (n > 0) {
                stringBuffer.append(" brw" + n);
                stringBuffer.append(" " + Style.__border2Class(this.border_right, "r"));
                if (ComparatorUtils.equals(this.border_right_color, Color.black)) {
                    stringBuffer.append(" brcb");
                } else {
                    map.put("border-right-color", Utils.javaColorToCSSColor(this.border_right_color));
                }
            } else {
                stringBuffer.append(" br0");
            }
        }
        if (this.border_bottom == 1 && ComparatorUtils.equals(this.border_bottom_color, Color.black)) {
            stringBuffer.append(" bb1");
        } else {
            n = IOHelper.getBorderWidth(this.border_bottom);
            if (n > 0) {
                stringBuffer.append(" bbw" + n);
                stringBuffer.append(" " + Style.__border2Class(this.border_bottom, "b"));
                if (ComparatorUtils.equals(this.border_bottom_color, Color.black)) {
                    stringBuffer.append(" bbcb");
                } else {
                    map.put("border-bottom-color", Utils.javaColorToCSSColor(this.border_bottom_color));
                }
            } else {
                stringBuffer.append(" bb0");
            }
        }
        if (this.border_left == 1 && ComparatorUtils.equals(this.border_left_color, Color.black)) {
            stringBuffer.append(" bl1");
        } else {
            n = IOHelper.getBorderWidth(this.border_left);
            if (n > 0) {
                stringBuffer.append(" blw" + n);
                stringBuffer.append(" " + Style.__border2Class(this.border_left, "l"));
                if (ComparatorUtils.equals(this.border_left_color, Color.black)) {
                    stringBuffer.append(" blcb");
                } else {
                    map.put("border-left-color", Utils.javaColorToCSSColor(this.border_left_color));
                }
            } else {
                stringBuffer.append(" bl0");
            }
        }
        if (this.border_top == 1 && ComparatorUtils.equals(this.border_top_color, Color.black)) {
            stringBuffer.append(" bt1");
        } else {
            n = IOHelper.getBorderWidth(this.border_top);
            if (n > 0) {
                stringBuffer.append(" btw" + n);
                stringBuffer.append(" " + Style.__border2Class(this.border_top, "t"));
                if (ComparatorUtils.equals(this.border_top_color, Color.black)) {
                    stringBuffer.append(" btcb");
                } else {
                    map.put("border-top-color", Utils.javaColorToCSSColor(this.border_top_color));
                }
            } else {
                stringBuffer.append(" bt0");
            }
        }
        return stringBuffer.toString().trim();
    }

    private static String __border2Class(int n, String string) {
        switch (n) {
            case 1: 
            case 2: 
            case 5: {
                return "b" + string + "ss";
            }
            case 6: {
                return "b" + string + "sd";
            }
            case 7: 
            case 9: 
            case 11: {
                return "b" + string + "sdo";
            }
        }
        return "b" + string + "sda";
    }

    private static String font2Class(Font font, Map map) {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        if (font.isBold()) {
            stringBuffer.append(" fwb");
        }
        if (font.isItalic()) {
            stringBuffer.append(" fsi");
        }
        if ((string2 = (String)clsFontFamily.get(string = font.getName())) == null) {
            map.put("font-family", string);
        } else if (!string2.equals("fnss")) {
            stringBuffer.append(" " + string2);
        }
        int n = font.getSize();
        if (n != 12) {
            if (n >= 8 && n <= 26) {
                stringBuffer.append(" f" + n);
            } else {
                map.put("font-size", font.getSize() + "px");
            }
        }
        if (font instanceof FRFont) {
            Color color;
            if (((FRFont)font).isStrikethrough()) {
                stringBuffer.append(" tdst");
            }
            if (((FRFont)font).getUnderline() != 0) {
                stringBuffer.append(" tdu");
            }
            if (((FRFont)font).isSubscript() || ((FRFont)font).isSuperscript()) {
                stringBuffer.append(" fvsc");
            }
            if (!ComparatorUtils.equals(color = ((FRFont)font).getForeground(), Color.black)) {
                map.put("color", Utils.javaColorToCSSColor(color));
            }
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = this.border_top ^ this.border_bottom ^ this.border_left ^ this.border_right ^ this.border_top_color.hashCode() ^ this.border_bottom_color.hashCode() ^ this.border_left_color.hashCode() ^ this.border_right_color.hashCode() ^ this.frFont.hashCode() ^ this.horizontal_alignment ^ this.imageLayout ^ this.verticalText ^ this.paddingLeft ^ this.paddingRight ^ this.rotation ^ this.textDirection ^ this.textStyle ^ this.vertical_alignment ^ this.spacingBefore ^ this.spacingAfter ^ this.lineSpacing;
        return this.background instanceof ColorBackground ? n ^ this.background.hashCode() : n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Style)) {
            return false;
        }
        Style style = (Style)object;
        return ComparatorUtils.equals(style.getFormat(), this.getFormat()) && ComparatorUtils.equals(style.getFRFont(), this.getFRFont()) && ComparatorUtils.equals(style.getBackground(), this.getBackground()) && style.getBorderTop() == this.getBorderTop() && style.getBorderLeft() == this.getBorderLeft() && style.getBorderBottom() == this.getBorderBottom() && style.getBorderRight() == this.getBorderRight() && ComparatorUtils.equals(style.getBorderTopColor(), this.getBorderTopColor()) && ComparatorUtils.equals(style.getBorderLeftColor(), this.getBorderLeftColor()) && ComparatorUtils.equals(style.getBorderBottomColor(), this.getBorderBottomColor()) && ComparatorUtils.equals(style.getBorderRightColor(), this.getBorderRightColor()) && style.getHorizontalAlignment() == this.getHorizontalAlignment() && style.getVerticalAlignment() == this.getVerticalAlignment() && style.getTextStyle() == this.getTextStyle() && style.getVerticalText() == this.getVerticalText() && style.getTextDirection() == this.getTextDirection() && style.getRotation() == this.getRotation() && style.getImageLayout() == this.getImageLayout() && style.getPaddingLeft() == this.getPaddingLeft() && style.getPaddingRight() == this.getPaddingRight() && style.getSpacingBefore() == this.getSpacingBefore() && style.getSpacingAfter() == this.getSpacingAfter() && style.getLineSpacing() == this.getLineSpacing();
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    protected Object readResolve() throws InvalidObjectException {
        if (this.getClass() != (class$com$fr$base$Style == null ? (class$com$fr$base$Style = Style.class$("com.fr.base.Style")) : class$com$fr$base$Style)) {
            throw new InvalidObjectException("subclass didn't correctly implement readResolve");
        }
        Object object = initializeStyle.get(this);
        if (object == null) {
            object = this;
            initializeStyle.put(this, object);
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DefaultValues defaultValues = FRContext.getDefaultValues();
        DEFAULT_STYLE = DEFAULT_STYLE.deriveFRFont(defaultValues.getFRFont());
        BORDER_STYLE = new Style();
        defaultValues = FRContext.getDefaultValues();
        BORDER_STYLE = BORDER_STYLE.deriveFRFont(defaultValues.getFRFont());
        BORDER_STYLE = BORDER_STYLE.deriveBorder(1, Color.black, 1, Color.black, 1, Color.black, 1, Color.black);
    }
}

