/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.FRContext;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLReadable;
import com.fr.base.xml.XMLWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.logging.Level;

public abstract class XMLTools {
    public static void readInputStreamXML(XMLReadable xMLReadable, InputStream inputStream) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF8");
        XMLableReader xMLableReader = XMLableReader.createXMLableReader(inputStreamReader);
        if (xMLableReader != null) {
            xMLableReader.readXMLObject(xMLReadable);
        }
    }

    public static void readFileXML(XMLReadable xMLReadable, File file) throws Exception {
        if (file == null || !file.exists()) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        XMLTools.readInputStreamXML(xMLReadable, fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    public static void writeOutputStreamXML(XMLWriter xMLWriter, OutputStream outputStream) {
        XMLPrintWriter xMLPrintWriter = XMLPrintWriter.create(outputStream);
        xMLWriter.writeXML(xMLPrintWriter);
        xMLPrintWriter.flush();
        xMLPrintWriter.close();
    }

    public static void writeFileXML(XMLWriter xMLWriter, File file) {
        if (file == null) {
            return;
        }
        if (!file.getParentFile().exists()) {
            Utils.mkdirs(file.getParentFile());
        }
        try {
            File file2 = file;
            while (file2.exists()) {
                file2 = new File(file2.getParentFile(), file2.getName() + ".1");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            XMLTools.writeOutputStreamXML(xMLWriter, fileOutputStream);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            if (file2 != file) {
                if (file.exists()) {
                    file.delete();
                }
                file2.renameTo(file);
            }
        }
        catch (IOException iOException) {
            FRContext.getLogger().log(Level.SEVERE, "Write XML file: " + file + "\n" + iOException.getMessage(), iOException);
        }
    }
}

