/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.background;

import com.fr.base.background.AbstractBackground;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.chart.core.ChartUtils;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;

public class GradientBackground
extends AbstractBackground {
    public static int LEFT2RIGHT = 0;
    public static int TOP2BOTTOM = 1;
    private int direction = 0;
    private boolean useCell = true;
    private boolean cyclic = false;
    private float begin = 0.0f;
    private float finish = 0.0f;
    private Color color1;
    private Color color2;

    public GradientBackground() {
    }

    public GradientBackground(Color color, Color color2, int n) {
        this.color1 = color;
        this.color2 = color2;
        this.direction = n;
    }

    public void setColor1(Color color) {
        this.color1 = color;
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor2(Color color) {
        this.color2 = color;
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setDirection(int n) {
        if (n != LEFT2RIGHT && n != TOP2BOTTOM) {
            return;
        }
        this.direction = n;
    }

    public int getDirection() {
        return this.direction;
    }

    public boolean isUseCell() {
        return this.useCell;
    }

    public void setUseCell(boolean bl) {
        this.useCell = bl;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public void setCyclic(boolean bl) {
        this.cyclic = bl;
    }

    public void setBeginPlace(float f) {
        this.begin = f;
    }

    public float getBeginPlace() {
        return this.begin;
    }

    public void setFinishPlace(float f) {
        this.finish = f;
    }

    public float getFinishPlace() {
        return this.finish;
    }

    public void paint(Graphics graphics, Shape shape) {
        GradientPaint gradientPaint = null;
        Point2D.Float float_ = null;
        Point2D.Float float_2 = null;
        if (this.isUseCell()) {
            float_ = new Point2D.Float(shape.getBounds().x, shape.getBounds().y);
            if (this.direction == LEFT2RIGHT) {
                float_2 = new Point2D.Float((float)shape.getBounds().x + (float)shape.getBounds().width, shape.getBounds().y);
            } else if (this.direction == TOP2BOTTOM) {
                float_2 = new Point2D.Float(shape.getBounds().x, (float)shape.getBounds().y + (float)shape.getBounds().height);
            }
        } else if (this.direction == LEFT2RIGHT) {
            float_ = new Point2D.Float(this.begin, shape.getBounds().y);
            float_2 = new Point2D.Float(this.finish, shape.getBounds().y);
        } else if (this.direction == TOP2BOTTOM) {
            float_ = new Point2D.Float(shape.getBounds().x, this.begin);
            float_2 = new Point2D.Float(shape.getBounds().x, this.finish);
        }
        if (this.color1 == null || this.color2 == null) {
            return;
        }
        gradientPaint = new GradientPaint(float_, this.color1, float_2, this.color2, this.cyclic);
        if (gradientPaint == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(shape);
        graphics2D.setPaint(paint);
    }

    public void toImage() {
    }

    public boolean equals(Object object) {
        if (!(object instanceof GradientBackground)) {
            return false;
        }
        GradientBackground gradientBackground = (GradientBackground)object;
        return this.getBeginPlace() == gradientBackground.getBeginPlace() && this.getFinishPlace() == gradientBackground.getFinishPlace() && this.isCyclic() == gradientBackground.isCyclic() && this.isUseCell() == gradientBackground.isUseCell() && this.direction == gradientBackground.getDirection() && this.comparaColor(this.getColor1(), gradientBackground.getColor1()) && this.comparaColor(this.getColor2(), gradientBackground.getColor2());
    }

    public boolean comparaColor(Color color, Color color2) {
        if (color == null || color2 == null) {
            return color == null && color2 == null;
        }
        return color.getRGB() == color2.getRGB();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("direction", this.direction);
        jSONObject.put("beginColor", ChartUtils.color2JS(this.color1));
        jSONObject.put("endColor", ChartUtils.color2JS(this.color2));
        jSONObject.put("begin", this.begin);
        jSONObject.put("finish", this.finish);
        jSONObject.put("cyclic", this.cyclic);
        jSONObject.put("useCell", this.useCell);
        return jSONObject;
    }

    public String getBackgroundType() {
        return "GradientBackground";
    }
}

