/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.background;

import com.fr.base.background.AbstractBackground;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.serializable.ImageSerializable;
import com.fr.chart.core.ChartUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ImageBackground
extends AbstractBackground {
    private transient Image image = null;
    private int layout = 3;
    private double specifiedImageWidth = -1.0;
    private double specifiedImageHeight = -1.0;

    public ImageBackground() {
        this(null);
    }

    public ImageBackground(Image image) {
        this(image, 0);
    }

    public ImageBackground(Image image, int n) {
        this.setImage(image);
        this.setLayout(n);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public int getLayout() {
        return this.layout;
    }

    public void setLayout(int n) {
        this.layout = n;
    }

    public Image getDefaultImage() {
        int n = (int)this.specifiedImageWidth;
        int n2 = (int)this.specifiedImageHeight;
        if (n == -1 && n2 == -1) {
            return this.getImage();
        }
        int n3 = n == -1 ? this.getImage().getWidth(null) : n;
        int n4 = n2 == -1 ? this.getImage().getHeight(null) : n2;
        BufferedImage bufferedImage = GraphHelper.createBufferedImage(n3, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paint(graphics2D, new Rectangle2D.Double(0.0, 0.0, n3, n4));
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }

    public double getSpecifiedImageWidth() {
        return this.specifiedImageWidth;
    }

    public void setSpecifiedImageWidth(double d) {
        this.specifiedImageWidth = d;
    }

    public double getSpecifiedImageHeight() {
        return this.specifiedImageHeight;
    }

    public void setSpecifiedImageHeight(double d) {
        this.specifiedImageHeight = d;
    }

    public void paint(Graphics graphics, Shape shape) {
        if (this.getImage() == null) {
            return;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape2 = graphics2D.getClip();
        graphics2D.clip(shape);
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        GraphHelper.paintImage(graphics2D, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), this.getImage(), null, this.getLayout(), (int)this.getSpecifiedImageWidth(), (int)this.getSpecifiedImageHeight());
        graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        graphics2D.setClip(shape2);
    }

    public void paint2(Graphics graphics, Shape shape, int n, int n2) {
        if (this.getImage() == null) {
            return;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape2 = graphics2D.getClip();
        graphics2D.clip(shape);
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        GraphHelper.paintImage2(graphics2D, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), this.getImage(), null, this.getLayout(), (int)this.getSpecifiedImageWidth(), (int)this.getSpecifiedImageHeight(), n, n2);
        graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        graphics2D.setClip(shape2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object != null) {
            this.image = ((ImageSerializable)object).getImage();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.image != null) {
            ImageSerializable imageSerializable = new ImageSerializable(this.image);
            objectOutputStream.writeObject(imageSerializable);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImageBackground)) {
            return false;
        }
        ImageBackground imageBackground = (ImageBackground)object;
        return this.getLayout() == imageBackground.getLayout() && ComparatorUtils.imageEquals(this.getImage(), imageBackground.getImage()) && this.getSpecifiedImageWidth() == imageBackground.getSpecifiedImageWidth() && this.getSpecifiedImageHeight() == imageBackground.getSpecifiedImageHeight();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("layout", this.layout);
        jSONObject.put("specifiedImageHeight", this.specifiedImageHeight);
        jSONObject.put("specifiedImageWidth", this.specifiedImageWidth);
        if (this.getImage() != null) {
            jSONObject.put("imgWidth", this.getImage().getWidth(null));
            jSONObject.put("imgHeight", this.getImage().getHeight(null));
            ChartUtils.image2JS(jSONObject, this.getImage());
        }
        return jSONObject;
    }

    public String getBackgroundType() {
        return "ImageBackground";
    }
}

