/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.background;

import com.fr.base.background.AbstractBackground;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class IntervalColorBackground
extends AbstractBackground {
    private static final long serialVersionUID = -3686146578900215327L;
    private Color bgColor;
    private int position = 2;
    private double intervalLength;

    public IntervalColorBackground() {
    }

    public IntervalColorBackground(Color color, int n) {
        this.bgColor = color;
        this.position = n;
    }

    public void paint(Graphics graphics, Shape shape) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        double d = this.getIntervalLength();
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            double d2 = rectangle2D.getWidth();
            double d3 = rectangle2D.getHeight();
            double d4 = rectangle2D.getX();
            double d5 = rectangle2D.getY() + d3;
            int n = (int)(d3 / d);
            int n2 = (int)(d2 / d);
            if (this.getPosition() == 2 || this.getPosition() == 4) {
                for (int i = 0; i < n; ++i) {
                    if (i % 2 != 0) continue;
                    graphics2D.setPaint(this.bgColor);
                    GraphHelper.fillRect(graphics2D, d4, d5 - (double)(i + 1) * d, d2, d);
                }
                if (n % 2 == 0) {
                    graphics2D.setPaint(this.bgColor);
                } else {
                    graphics2D.setPaint(null);
                }
                GraphHelper.fillRect(graphics2D, d4, rectangle2D.getY(), d2, d3 - (double)n * d);
            } else {
                for (int i = 0; i < n2; ++i) {
                    if (i % 2 != 0) continue;
                    graphics2D.setPaint(this.bgColor);
                    GraphHelper.fillRect(graphics2D, d4 + (double)i * d, rectangle2D.getY(), d, d3);
                }
                if (n2 % 2 == 0) {
                    graphics2D.setPaint(this.bgColor);
                } else {
                    graphics2D.setPaint(null);
                }
                GraphHelper.fillRect(graphics2D, d4 + (double)n2 * d, rectangle2D.getY(), d2 - (double)n2 * d, d3);
            }
        }
        graphics2D.setPaint(paint);
    }

    public void setColor(Color color) {
        this.bgColor = color;
    }

    public Color getColor() {
        return this.bgColor;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getPosition() {
        return this.position;
    }

    public void setIntervalLength(double d) {
        this.intervalLength = d;
    }

    public double getIntervalLength() {
        return this.intervalLength;
    }

    public JSONObject toJSONObject() throws JSONException {
        return null;
    }

    public String getBackgroundType() {
        return null;
    }
}

