/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.background;

import com.fr.base.background.AbstractBackground;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.chart.core.ChartUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

public class PatternBackground
extends AbstractBackground {
    private int patternIndex = 0;
    private Color foreground = null;
    private Color background = null;
    static byte[] staticByteArray = new byte[]{-86, 85, -86, 85, -86, 85, -86, 85, -69, -18, -69, -18, -69, -18, -69, -18, 34, -120, 34, -120, 34, -120, 34, -120, 0, -1, -1, 0, 0, -1, -1, 0, 102, 102, 102, 102, 102, 102, 102, 102, 56, 28, 14, 7, -125, -63, -32, 112, 7, 14, 28, 56, 112, -32, -63, -125, 102, 102, -103, -103, 102, 102, -103, -103, -103, -1, 102, -1, -103, -1, 102, -1, 0, -1, 0, 0, 0, -1, 0, 0, 68, 68, 68, 68, 68, 68, 68, 68, 17, -120, 68, 34, 17, -120, 68, 34, 34, 68, -120, 17, 34, 68, -120, 17, -120, -120, -120, -1, -120, -120, -120, -1, 68, -86, 17, -86, 68, -86, 17, -86, 0, 34, 0, -120, 0, 34, 0, -120, 0, -128, 0, 8, 0, -128, 0, 8, 0, 0, 0, -128, 0, 0, 0, 8, 21, -86, 85, -86, 81, -86, 85, -86, -86, -35, -86, 119, -86, -35, -86, 119, -1, -18, -1, -69, -1, -18, -1, -69, -1, -3, -1, -33, -1, -3, -1, -33, -2, -1, -1, -1, -17, -1, -1, -1, -16, 15, 15, 15, 15, -16, -16, -16, -128, -1, -128, -128, -128, -128, -128, -128, 0, -86, 0, 32, 0, 32, 0, 32, 16, -1, 1, 1, 1, -1, 16, 16, 64, -128, 1, 3, -124, 72, 48, 32, -86, -86, -86, -86, -86, -86, -86, -86, 0, -1, 0, -1, 0, -1, 0, -1, 8, -128, -128, -128, -128, 8, 8, 8, 0, 0, 0, -16, 0, 0, 0, 15, -103, -52, 102, 51, -103, -52, 102, 51, 102, -52, -103, 51, 102, -52, -103, 51, 17, 0, 0, 0, 0, -120, 68, 34, 0, 0, 0, 17, 34, 68, -120, 0, 0, 16, 56, 124, -2, 124, 56, 16, 68, -126, 1, -126, 68, 40, 16, 40, 0, -120, 0, 2, 0, -120, 0, 32, -40, 27, 3, 48, -79, -115, 12, -64, 16, 2, 64, 8, -128, 4, 32, 1, 72, -124, 3, 48, 72, -124, 3, 48, 32, 64, 32, 0, 4, 2, 4, 0, 24, 0, 3, -92, 24, 0, 3, -92, 12, 3, -128, 64, 64, -64, 33, 18, -126, 68, 42, 17, -118, 68, -88, 17, 30, 85, -86, 85, -86, 30, 30, 30, 62, -35, 98, -29, -29, -35, 38, 62};

    public PatternBackground() {
        this(0, Color.lightGray, Color.black);
    }

    public PatternBackground(int n, Color color, Color color2) {
        this.setPatternIndex(n);
        this.setForeground(color);
        this.setBackground(color2);
    }

    private TexturePaint createPattern(int n) {
        Color color;
        Color color2;
        if (n < 0 || n > 47) {
            n = 0;
        }
        if ((color2 = this.getForeground()) == null) {
            color2 = Color.lightGray;
        }
        if ((color = this.getBackground()) == null) {
            color = Color.black;
        }
        int n2 = this.createColorInt(color2);
        int n3 = this.createColorInt(color);
        BufferedImage bufferedImage = GraphHelper.createBufferedImage(8, 8, 1);
        int n4 = 8 * n;
        for (int i = 0; i < 8; ++i) {
            byte by = staticByteArray[n4 + i];
            int n5 = 7;
            for (int j = 0; j < 8; ++j) {
                bufferedImage.setRGB(n5--, i, (by & 1 << j) != 0 ? n3 : n2);
            }
        }
        Rectangle rectangle = new Rectangle(0, 0, 8, 8);
        return new TexturePaint(bufferedImage, rectangle);
    }

    private int createColorInt(Color color) {
        return color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
    }

    public int getPatternIndex() {
        return this.patternIndex;
    }

    public void setPatternIndex(int n) {
        this.patternIndex = n;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void paint(Graphics graphics, Shape shape) {
        TexturePaint texturePaint = this.createPattern(this.getPatternIndex());
        if (texturePaint == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(texturePaint);
        GraphHelper.fill(graphics2D, shape);
        graphics2D.setPaint(paint);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PatternBackground)) {
            return false;
        }
        PatternBackground patternBackground = (PatternBackground)object;
        return patternBackground.getPatternIndex() == this.getPatternIndex() && ComparatorUtils.equals(patternBackground.getForeground(), this.getForeground()) && ComparatorUtils.equals(patternBackground.getBackground(), this.getBackground());
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        TexturePaint texturePaint = this.createPattern(this.patternIndex);
        ChartUtils.image2JS(jSONObject, texturePaint.getImage());
        return jSONObject;
    }

    public String getBackgroundType() {
        return "PatterBackground";
    }
}

