/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.background;

import com.fr.base.BaseUtils;
import com.fr.base.background.AbstractBackground;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.serializable.ImageSerializable;
import com.fr.base.core.serializable.ShapeSerializable;
import com.fr.chart.core.ChartUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TextureBackground
extends AbstractBackground {
    private static final long serialVersionUID = 1994011909459388705L;
    private static final Rectangle2D embededImageRect = new Rectangle2D.Double(0.0, 0.0, 58.0, 42.0);
    private transient TexturePaint texturePaint = null;
    public static final TexturePaint NewsprintTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Newsprint.gif"), embededImageRect);
    public static final TexturePaint RecycledPaperTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/RecycledPaper.gif"), embededImageRect);
    public static final TexturePaint ParchmentTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Parchment.gif"), embededImageRect);
    public static final TexturePaint StationeryTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Stationery.gif"), embededImageRect);
    public static final TexturePaint GreenMarbleTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/GreenMarble.gif"), embededImageRect);
    public static final TexturePaint WhiteMarbleTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/WhiteMarble.gif"), embededImageRect);
    public static final TexturePaint BrownMarbleTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/BrownMarble.gif"), embededImageRect);
    public static final TexturePaint GraniteTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Granite.gif"), embededImageRect);
    public static final TexturePaint BlueTissuePaperTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/BlueTissuePaper.gif"), embededImageRect);
    public static final TexturePaint PinkTissuePaperTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/PinkTissuePaper.gif"), embededImageRect);
    public static final TexturePaint PurpleMeshTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/PurpleMesh.gif"), embededImageRect);
    public static final TexturePaint BouquetTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Bouquet.gif"), embededImageRect);
    public static final TexturePaint PapyrusTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Papyrus.gif"), embededImageRect);
    public static final TexturePaint CanvasTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Canvas.gif"), embededImageRect);
    public static final TexturePaint DenimTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Denim.gif"), embededImageRect);
    public static final TexturePaint WovenMatTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/WovenMat.gif"), embededImageRect);
    public static final TexturePaint WaterDropletsTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/WaterDroplets.gif"), embededImageRect);
    public static final TexturePaint PaperBagTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/PaperBag.gif"), embededImageRect);
    public static final TexturePaint FishFossilTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/FishFossil.gif"), embededImageRect);
    public static final TexturePaint SandTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Sand.gif"), embededImageRect);
    public static final TexturePaint CorkTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Cork.gif"), embededImageRect);
    public static final TexturePaint WalnutTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Walnut.gif"), embededImageRect);
    public static final TexturePaint OakTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/Oak.gif"), embededImageRect);
    public static final TexturePaint MediumWoodTexturePaint = new TexturePaint(TextureBackground.createBufferedImage("/com/fr/base/background/images/MediumWood.gif"), embededImageRect);

    public TextureBackground() {
        this(null);
    }

    public TextureBackground(TexturePaint texturePaint) {
        this.setTexturePaint(texturePaint);
    }

    private static BufferedImage createBufferedImage(String string) {
        return GraphHelper.createBufferedImageFromImage(BaseUtils.readImage(string));
    }

    public void paint(Graphics graphics, Shape shape) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getTexturePaint() == null) {
            return;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        BufferedImage bufferedImage = GraphHelper.createBufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 2);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        BufferedImage bufferedImage2 = this.getTexturePaint().getImage();
        Rectangle2D rectangle2D2 = this.getTexturePaint().getAnchorRect();
        int n = (int)rectangle2D2.getWidth();
        int n2 = (int)rectangle2D2.getHeight();
        if (n > 0 && n2 > 0) {
            int n3 = 0;
            while ((double)n3 < rectangle2D.getHeight()) {
                int n4 = 0;
                while ((double)n4 < rectangle2D.getWidth()) {
                    graphics2D2.drawImage(bufferedImage2, n4, n3, n, n2, null);
                    n4 += n;
                }
                n3 += n2;
            }
        }
        graphics2D2.dispose();
        Shape shape2 = graphics2D.getClip();
        graphics2D.clip(shape);
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        graphics2D.setClip(shape2);
    }

    public TexturePaint getTexturePaint() {
        return this.texturePaint;
    }

    public void setTexturePaint(TexturePaint texturePaint) {
        this.texturePaint = texturePaint;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        ShapeSerializable shapeSerializable = (ShapeSerializable)objectInputStream.readObject();
        Rectangle2D rectangle2D = (Rectangle2D)shapeSerializable.getShape();
        BufferedImage bufferedImage = null;
        Object object = objectInputStream.readObject();
        if (object != null) {
            bufferedImage = GraphHelper.createBufferedImageFromImage(((ImageSerializable)object).getImage());
        }
        this.texturePaint = new TexturePaint(bufferedImage, rectangle2D);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.texturePaint == null) {
            return;
        }
        Rectangle2D rectangle2D = this.texturePaint.getAnchorRect();
        ShapeSerializable shapeSerializable = new ShapeSerializable(rectangle2D);
        objectOutputStream.writeObject(shapeSerializable);
        BufferedImage bufferedImage = this.texturePaint.getImage();
        if (bufferedImage != null) {
            ImageSerializable imageSerializable = new ImageSerializable(bufferedImage);
            objectOutputStream.writeObject(imageSerializable);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextureBackground)) {
            return false;
        }
        TextureBackground textureBackground = (TextureBackground)object;
        return this.texturePaintEquals(this.getTexturePaint(), textureBackground.getTexturePaint());
    }

    private boolean texturePaintEquals(TexturePaint texturePaint, TexturePaint texturePaint2) {
        if (texturePaint == null || texturePaint2 == null) {
            return texturePaint == null && texturePaint2 == null;
        }
        return ComparatorUtils.equals(texturePaint.getAnchorRect(), texturePaint2.getAnchorRect()) && ComparatorUtils.imageEquals(texturePaint.getImage(), texturePaint2.getImage());
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.texturePaint != null) {
            ChartUtils.image2JS(jSONObject, this.texturePaint.getImage());
        }
        return jSONObject;
    }

    public String getBackgroundType() {
        return "TextureBackground";
    }
}

