/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.cache;

import com.fr.base.cache.FRCache;
import com.fr.base.cache.Unity;
import com.fr.base.cache.config.CacheConfiguration;
import com.fr.base.cache.store.MemoryStoreEvictionPolicy;
import com.fr.util.Utils;
import java.io.File;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CptCacheMap
extends AbstractMap {
    private Map key_fileunity_map = new HashMap();

    private static FRCache createMemoryCache() {
        CacheConfiguration cacheConfiguration = new CacheConfiguration();
        cacheConfiguration.setMaxElementsInMemory(3);
        cacheConfiguration.setTimeToLiveSeconds(600L);
        cacheConfiguration.setMemoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.LFU.toString());
        FRCache fRCache = new FRCache(cacheConfiguration);
        return fRCache;
    }

    public boolean containsKey(Object object) {
        return this.key_fileunity_map.containsKey(object);
    }

    public Object put(Object object, Object object2) {
        File file;
        if (!(object2 instanceof Unity) || !(((Unity)object2).getValue() instanceof File)) {
            throw new IllegalArgumentException();
        }
        if (this.key_fileunity_map.containsKey(object) && (file = (File)this.key_fileunity_map.remove(object)) != null) {
            Utils.deleteFile(file);
        }
        this.key_fileunity_map.put(object, object2);
        return null;
    }

    public Object remove(Object object) {
        Unity unity = (Unity)this.key_fileunity_map.remove(object);
        if (unity != null) {
            Object var3_3 = null;
            Utils.deleteFile((File)unity.getObjectValue());
            return var3_3;
        }
        return null;
    }

    public Object get(Object object) {
        Unity unity = (Unity)this.key_fileunity_map.get(object);
        return unity;
    }

    public int size() {
        return this.key_fileunity_map.size();
    }

    public Set entrySet() {
        return new CacheEntrySet();
    }

    public void clear() {
        this.key_fileunity_map.clear();
    }

    static class CacheEntry
    implements Map.Entry {
        Map.Entry key_file_entry;

        CacheEntry(Map.Entry entry) {
            this.key_file_entry = entry;
        }

        public Object getKey() {
            return this.key_file_entry.getKey();
        }

        public Object getValue() {
            Unity unity = (Unity)this.key_file_entry.getValue();
            return unity;
        }

        public Object setValue(Object object) {
            if (!(object instanceof Unity) || !(((Unity)object).getValue() instanceof File)) {
                throw new IllegalArgumentException();
            }
            return null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CacheEntry)) {
                return false;
            }
            CacheEntry cacheEntry = (CacheEntry)object;
            return ((Object)this.key_file_entry).equals(cacheEntry.key_file_entry);
        }

        public int hashCode() {
            return ((Object)this.key_file_entry).hashCode() + 1;
        }

        public String toString() {
            return "CacheEntry" + this.key_file_entry.toString();
        }
    }

    private class CacheEntryIterator
    implements Iterator {
        Iterator key_file_iterator = null;
        private transient Map.Entry entry = null;

        public CacheEntryIterator() {
            this.key_file_iterator = CptCacheMap.this.key_fileunity_map.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.key_file_iterator.hasNext();
        }

        public Object next() {
            this.entry = (Map.Entry)this.key_file_iterator.next();
            return new CacheEntry(this.entry);
        }

        public void remove() {
            this.key_file_iterator.remove();
            if (this.entry != null) {
                CptCacheMap.this.remove(this.entry.getKey());
            }
        }
    }

    private class CacheEntrySet
    extends AbstractSet {
        private CacheEntrySet() {
        }

        public Iterator iterator() {
            return new CacheEntryIterator();
        }

        public boolean contains(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return CptCacheMap.this.size();
        }

        public void clear() {
            CptCacheMap.this.clear();
        }
    }
}

