/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.cache;

import com.fr.base.cache.CacheException;
import com.fr.base.cache.RegisteredEventListeners;
import com.fr.base.cache.Unity;
import com.fr.base.cache.config.CacheConfiguration;
import com.fr.base.cache.store.MemoryStore;
import com.fr.base.cache.store.MemoryStoreEvictionPolicy;
import com.fr.base.cache.store.Status;

public class FRCache {
    private Status status = Status.STATUS_UNINITIALISED;
    private MemoryStore memoryStore;
    private CacheConfiguration configuration;
    private RegisteredEventListeners registeredEventListeners;
    private long memoryStoreHitCount;
    private long missCountExpired;
    private long missCountNotFound;
    private long hitCount;
    private long totalGetTime;

    public FRCache() {
        this.configuration = new CacheConfiguration();
        this.memoryStore = MemoryStore.create(this);
        this.registeredEventListeners = new RegisteredEventListeners(this);
        this.status = Status.STATUS_ALIVE;
    }

    public FRCache(CacheConfiguration cacheConfiguration) {
        this.configuration = cacheConfiguration;
        this.memoryStore = MemoryStore.create(this);
        this.registeredEventListeners = new RegisteredEventListeners(this);
        this.status = Status.STATUS_ALIVE;
    }

    public final void put(Object object, Object object2) {
        this.put(new Unity(object, object2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Unity unity) {
        if (unity == null) {
            throw new IllegalArgumentException("Unity can not be null");
        }
        unity.resetAccessStatistics();
        Object object = unity.getObjectKey();
        boolean bl = this.memoryStore.containsKey(object);
        if (bl) {
            unity.updateUpdateStatistics();
        }
        this.applyDefaultsToElementWithoutLifespanSet(unity);
        this.backOffIfDiskSpoolFull();
        FRCache fRCache = this;
        synchronized (fRCache) {
            this.memoryStore.put(unity);
        }
    }

    public final Object getObject(Object object) {
        Unity unity = this.get(object);
        return unity != null ? unity.getObjectValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Unity get(Object object) throws IllegalStateException, CacheException {
        Unity unity;
        this.checkStatus();
        long l = System.currentTimeMillis();
        FRCache fRCache = this;
        synchronized (fRCache) {
            unity = this.searchInMemoryStore(object, true);
            if (unity == null) {
                ++this.missCountNotFound;
            } else {
                ++this.hitCount;
            }
        }
        long l2 = System.currentTimeMillis();
        this.totalGetTime += l2 - l;
        return unity;
    }

    private Unity searchInMemoryStore(Object object, boolean bl) {
        Unity unity = bl ? this.memoryStore.get(object) : this.memoryStore.getQuiet(object);
        if (unity != null) {
            if (this.isExpired(unity)) {
                if (bl) {
                    ++this.missCountExpired;
                }
                this.remove(object);
                unity = null;
            } else if (bl) {
                ++this.memoryStoreHitCount;
            }
        }
        return unity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isExpired(Unity unity) throws IllegalStateException, NullPointerException {
        this.checkStatus();
        Unity unity2 = unity;
        synchronized (unity2) {
            return unity.isExpired();
        }
    }

    public synchronized void clearStatistics() throws IllegalStateException {
        this.checkStatus();
        this.hitCount = 0L;
        this.memoryStoreHitCount = 0L;
        this.missCountExpired = 0L;
        this.missCountNotFound = 0L;
        this.totalGetTime = 0L;
        this.registeredEventListeners.clearCounters();
    }

    public MemoryStore getStore() {
        return this.memoryStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictExpiredElements() {
        Object[] objectArray = this.memoryStore.getKeyArray();
        FRCache fRCache = this;
        synchronized (fRCache) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                this.searchInMemoryStore(object, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) throws IllegalStateException {
        Unity unity;
        this.checkStatus();
        FRCache fRCache = this;
        synchronized (fRCache) {
            unity = this.memoryStore.remove(object);
        }
        this.registeredEventListeners.notifyElementExpiry(unity);
        this.registeredEventListeners.notifyElementRemoved(unity);
        return unity != null;
    }

    private void applyDefaultsToElementWithoutLifespanSet(Unity unity) {
        if (!unity.isLifespanSet()) {
            unity.setTimeToLive((int)this.configuration.getTimeToLiveSeconds());
            unity.setTimeToIdle((int)this.configuration.getTimeToIdleSeconds());
            unity.setEternal(this.configuration.isEternal());
        }
    }

    public final RegisteredEventListeners getCacheEventNotificationService() {
        return this.registeredEventListeners;
    }

    private void backOffIfDiskSpoolFull() {
    }

    public final int getMaxElementsInMemory() {
        return this.configuration.getMaxElementsInMemory();
    }

    public final MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.configuration.getMemoryStoreEvictionPolicy();
    }

    private void changeStatus(Status status) {
        this.status = status;
    }

    public final Status getStatus() {
        return this.status;
    }

    private void checkStatus() throws IllegalStateException {
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            throw new IllegalStateException("The " + this.configuration.getName() + " Cache is not alive.");
        }
    }

    private void checkStatusNotDisposed() throws IllegalStateException {
        if (this.status.equals(Status.STATUS_SHUTDOWN)) {
            throw new IllegalStateException("The " + this.configuration.getName() + " Cache is disposed.");
        }
    }

    public synchronized void dispose() throws IllegalStateException {
        this.checkStatusNotDisposed();
        this.registeredEventListeners.dispose();
        if (this.memoryStore != null) {
            this.memoryStore.dispose();
        }
        this.memoryStore = null;
        this.changeStatus(Status.STATUS_SHUTDOWN);
    }
}

