/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.cache;

import com.fr.base.cache.CacheEventListener;
import com.fr.base.cache.CacheException;
import com.fr.base.cache.FRCache;
import com.fr.base.cache.Unity;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RegisteredEventListeners {
    private final Set cacheEventListeners = new HashSet();
    private final FRCache cache;
    private long elementsRemovedCounter;
    private long elementsPutCounter;
    private long elementsUpdatedCounter;
    private long elementsExpiredCounter;
    private long elementsEvictedCounter;
    private long elementsRemoveAllCounter;

    public RegisteredEventListeners(FRCache fRCache) {
        this.cache = fRCache;
    }

    public final void notifyElementRemoved(Unity unity) throws CacheException {
        ++this.elementsRemovedCounter;
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.createThreadSafeIterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                cacheEventListener.notifyElementRemoved(this.cache, unity);
            }
        }
    }

    public final void notifyElementPut(Unity unity) throws CacheException {
        ++this.elementsPutCounter;
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.createThreadSafeIterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                cacheEventListener.notifyElementPut(this.cache, unity);
            }
        }
    }

    public final void notifyElementUpdated(Unity unity) {
        ++this.elementsUpdatedCounter;
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.createThreadSafeIterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                cacheEventListener.notifyElementUpdated(this.cache, unity);
            }
        }
    }

    public final void notifyElementExpiry(Unity unity) {
        ++this.elementsExpiredCounter;
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.createThreadSafeIterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                cacheEventListener.notifyElementExpired(this.cache, unity);
            }
        }
    }

    public final boolean hasCacheEventListeners() {
        return this.cacheEventListeners.size() > 0;
    }

    public void notifyElementEvicted(Unity unity) {
        ++this.elementsEvictedCounter;
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.createThreadSafeIterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                cacheEventListener.notifyElementEvicted(this.cache, unity);
            }
        }
    }

    public void notifyRemoveAll(boolean bl) {
        ++this.elementsRemoveAllCounter;
        if (this.hasCacheEventListeners()) {
            Iterator iterator = this.createThreadSafeIterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                cacheEventListener.notifyRemoveAll(this.cache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator createThreadSafeIterator() {
        HashSet hashSet;
        Set set = this.cacheEventListeners;
        synchronized (set) {
            hashSet = new HashSet(this.cacheEventListeners);
        }
        return hashSet.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean registerListener(CacheEventListener cacheEventListener) {
        boolean bl;
        if (cacheEventListener == null) {
            return false;
        }
        Set set = this.cacheEventListeners;
        synchronized (set) {
            bl = this.cacheEventListeners.add(cacheEventListener);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unregisterListener(CacheEventListener cacheEventListener) {
        boolean bl;
        Set set = this.cacheEventListeners;
        synchronized (set) {
            bl = this.cacheEventListeners.remove(cacheEventListener);
        }
        return bl;
    }

    public final Set getCacheEventListeners() {
        return this.cacheEventListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Object object;
        Iterator iterator = this.createThreadSafeIterator();
        while (iterator.hasNext()) {
            object = (CacheEventListener)iterator.next();
            object.dispose();
        }
        object = this.cacheEventListeners;
        synchronized (object) {
            this.cacheEventListeners.clear();
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(" cacheEventListeners: ");
        Iterator iterator = this.createThreadSafeIterator();
        while (iterator.hasNext()) {
            CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
            stringBuffer.append(cacheEventListener.getClass().getName()).append(" ");
        }
        return stringBuffer.toString();
    }

    public void clearCounters() {
        this.elementsRemovedCounter = 0L;
        this.elementsPutCounter = 0L;
        this.elementsUpdatedCounter = 0L;
        this.elementsExpiredCounter = 0L;
        this.elementsEvictedCounter = 0L;
        this.elementsRemoveAllCounter = 0L;
    }

    public long getElementsRemovedCounter() {
        return this.elementsRemovedCounter;
    }

    public long getElementsPutCounter() {
        return this.elementsPutCounter;
    }

    public long getElementsUpdatedCounter() {
        return this.elementsUpdatedCounter;
    }

    public long getElementsExpiredCounter() {
        return this.elementsExpiredCounter;
    }

    public long getElementsEvictedCounter() {
        return this.elementsEvictedCounter;
    }

    public long getElementsRemoveAllCounter() {
        return this.elementsRemoveAllCounter;
    }
}

