/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.cache;

import com.fr.base.FRContext;
import com.fr.base.cache.CacheException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;

public final class Unity
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 9068644761950510725L;
    private static final long ONE_SECOND = 1000L;
    private final Object key;
    private Object value;
    private long version;
    private long creationTime;
    private long lastAccessTime;
    private long nextToLastAccessTime;
    private long hitCount;
    private int timeToLive;
    private int timeToIdle;
    private long lastUpdateTime;
    private boolean eternal;
    private boolean lifespanSet;

    public Unity(Serializable serializable, Serializable serializable2, long l) {
        this((Object)serializable, (Object)serializable2, l);
    }

    public Unity(Object object, Object object2, long l) {
        this.key = object;
        this.value = object2;
        this.version = l;
        this.creationTime = System.currentTimeMillis();
        this.hitCount = 0L;
    }

    public Unity(Object object, Object object2, long l, long l2, long l3, long l4, long l5, long l6) {
        this.key = object;
        this.value = object2;
        this.version = l;
        this.creationTime = l2;
        this.lastAccessTime = l3;
        this.nextToLastAccessTime = l4;
        this.lastUpdateTime = l5;
        this.hitCount = l6;
    }

    public Unity(Object object, Object object2, boolean bl, int n, int n2) {
        this.key = object;
        this.value = object2;
        this.eternal = bl;
        this.timeToIdle = n;
        this.timeToLive = n2;
        this.creationTime = System.currentTimeMillis();
    }

    public Unity(Serializable serializable, Serializable serializable2) {
        this((Object)serializable, (Object)serializable2, 1L);
    }

    public Unity(Object object, Object object2) {
        this(object, object2, 1L);
    }

    public final Serializable getKey() {
        Serializable serializable;
        try {
            serializable = (Serializable)this.key;
        }
        catch (Exception exception) {
            throw new CacheException("The key " + this.key + " is not Serializable. Consider using Element#getObjectKey()");
        }
        return serializable;
    }

    public final Object getObjectKey() {
        return this.key;
    }

    public final Serializable getValue() {
        Serializable serializable;
        try {
            serializable = (Serializable)this.value;
        }
        catch (Exception exception) {
            throw new CacheException("The value " + this.value + " for key " + this.key + " is not Serializable. Consider using Element#getObjectKey()");
        }
        return serializable;
    }

    public final Object getObjectValue() {
        return this.value;
    }

    public void setObjectValue(Object object) {
        this.value = object;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof Unity)) {
            return false;
        }
        Unity unity = (Unity)object;
        if (this.key == null || unity.getObjectKey() == null) {
            return false;
        }
        return this.key.equals(unity.getObjectKey());
    }

    public void setTimeToLive(int n) {
        this.timeToLive = n;
        this.lifespanSet = true;
    }

    public void setTimeToIdle(int n) {
        this.timeToIdle = n;
        this.lifespanSet = true;
    }

    public final int hashCode() {
        return this.key.hashCode();
    }

    public final void setVersion(long l) {
        this.version = l;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final void setCreateTime() {
        this.creationTime = System.currentTimeMillis();
    }

    public final long getVersion() {
        return this.version;
    }

    public final long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public final long getNextToLastAccessTime() {
        return this.nextToLastAccessTime;
    }

    public final long getHitCount() {
        return this.hitCount;
    }

    public final void resetAccessStatistics() {
        this.lastAccessTime = 0L;
        this.nextToLastAccessTime = 0L;
        this.hitCount = 0L;
    }

    public final void updateAccessStatistics() {
        this.nextToLastAccessTime = this.lastAccessTime;
        this.lastAccessTime = System.currentTimeMillis();
        ++this.hitCount;
    }

    public final void updateUpdateStatistics() {
        this.version = this.lastUpdateTime = System.currentTimeMillis();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ key = ").append(this.key).append(", value=").append(this.value).append(", version=").append(this.version).append(", hitCount=").append(this.hitCount).append(", CreationTime = ").append(this.getCreationTime()).append(", LastAccessTime = ").append(this.getLastAccessTime()).append(" ]");
        return stringBuffer.toString();
    }

    public final Object clone() throws CloneNotSupportedException {
        super.clone();
        Unity unity = new Unity(this.deepCopy(this.key), this.deepCopy(this.value), this.version);
        unity.creationTime = this.creationTime;
        unity.lastAccessTime = this.lastAccessTime;
        unity.nextToLastAccessTime = this.nextToLastAccessTime;
        unity.hitCount = this.hitCount;
        return unity;
    }

    public Object lightClone() throws CloneNotSupportedException {
        Unity unity = (Unity)super.clone();
        if (this.value != null) {
            unity.value = this.deepCopy(this.value);
        }
        return unity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object deepCopy(Object object) {
        Serializable serializable;
        block18: {
            serializable = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = null;
            ObjectInputStream objectInputStream = null;
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            serializable = (Serializable)objectInputStream.readObject();
            Object var8_9 = null;
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                break block18;
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.SEVERE, "Error closing Stream");
            }
            break block18;
            {
                catch (IOException iOException) {
                    FRContext.getLogger().log(Level.SEVERE, "Error cloning Element with key " + this.key + " during serialization and deserialization of value");
                    Object var8_10 = null;
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                        break block18;
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().log(Level.SEVERE, "Error closing Stream");
                    }
                    break block18;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FRContext.getLogger().log(Level.SEVERE, "Error cloning Element with key " + this.key + " during serialization and deserialization of value");
                    Object var8_11 = null;
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                        break block18;
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().log(Level.SEVERE, "Error closing Stream");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.SEVERE, "Error closing Stream");
                }
                throw throwable;
            }
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final long getSerializedSize() {
        if (!this.isSerializable()) {
            return 0L;
        }
        long l = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this);
        long l2 = l = (long)byteArrayOutputStream.size();
        Object var8_6 = null;
        try {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, "Error closing ObjectOutputStream");
        }
        return l2;
        catch (IOException iOException) {
            try {
                FRContext.getLogger().log(Level.WARNING, "Error measuring element size for element with key " + this.key + ". Cause was: " + iOException.getMessage());
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, "Error closing ObjectOutputStream");
                }
                throw throwable;
            }
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, "Error closing ObjectOutputStream");
            }
        }
        return l;
    }

    public final boolean isSerializable() {
        return this.key instanceof Serializable && this.value instanceof Serializable;
    }

    public final boolean isKeySerializable() {
        return this.key instanceof Serializable;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public boolean isExpired() {
        long l;
        if (!this.lifespanSet) {
            return false;
        }
        long l2 = System.currentTimeMillis();
        return l2 > (l = this.getExpirationTime());
    }

    public long getExpirationTime() {
        if (!this.lifespanSet || this.eternal || this.timeToLive == 0 && this.timeToIdle == 0) {
            return Long.MAX_VALUE;
        }
        long l = 0L;
        long l2 = this.creationTime + (long)this.timeToLive * 1000L;
        long l3 = Math.max(this.creationTime, this.nextToLastAccessTime);
        long l4 = l3 + (long)this.timeToIdle * 1000L;
        l = this.timeToLive != 0 && (this.timeToIdle == 0 || this.lastAccessTime == 0L) ? l2 : (this.timeToLive == 0 ? l4 : Math.min(l2, l4));
        return l;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public void setEternal(boolean bl) {
        this.eternal = bl;
        this.lifespanSet = true;
    }

    public boolean isLifespanSet() {
        return this.lifespanSet;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public int getTimeToIdle() {
        return this.timeToIdle;
    }
}

