/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.cache.config;

import com.fr.base.StringUtils;
import com.fr.base.XMLable;
import com.fr.base.cache.store.MemoryStoreEvictionPolicy;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;

public class CacheConfiguration
implements XMLable,
Cloneable {
    protected String name;
    protected int maxElementsInMemory = 10;
    protected int maxElementsOnDisk;
    protected MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.LRU;
    protected boolean eternal;
    protected long timeToIdleSeconds = 200L;
    protected long timeToLiveSeconds = 40L;
    protected boolean overflowToDisk;
    protected boolean diskPersistent;
    protected int diskSpoolBufferSizeMB;
    protected long diskExpiryThreadIntervalSeconds;

    public Object clone() throws CloneNotSupportedException {
        CacheConfiguration cacheConfiguration = (CacheConfiguration)super.clone();
        return cacheConfiguration;
    }

    public final void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cache name cannot be null.");
        }
        if (string.indexOf(47) != -1) {
            throw new IllegalArgumentException("Cache name cannot contain '/' characters.");
        }
        this.name = string;
    }

    public final void setMaxElementsInMemory(int n) {
        this.maxElementsInMemory = n;
    }

    public final void setMemoryStoreEvictionPolicy(String string) {
        this.memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.fromString(string);
    }

    public final void setMemoryStoreEvictionPolicyFromObject(MemoryStoreEvictionPolicy memoryStoreEvictionPolicy) {
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
    }

    public final void setEternal(boolean bl) {
        this.eternal = bl;
    }

    public final void setTimeToIdleSeconds(long l) {
        this.timeToIdleSeconds = l;
    }

    public final void setTimeToLiveSeconds(long l) {
        this.timeToLiveSeconds = l;
    }

    public final void setOverflowToDisk(boolean bl) {
        this.overflowToDisk = bl;
    }

    public final void setDiskPersistent(boolean bl) {
        this.diskPersistent = bl;
    }

    public int getDiskSpoolBufferSizeMB() {
        return this.diskSpoolBufferSizeMB;
    }

    public void setDiskSpoolBufferSizeMB(int n) {
        this.diskSpoolBufferSizeMB = n;
    }

    public void setMaxElementsOnDisk(int n) {
        this.maxElementsOnDisk = n;
    }

    public final void setDiskExpiryThreadIntervalSeconds(long l) {
        this.diskExpiryThreadIntervalSeconds = l;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public int getMaxElementsOnDisk() {
        return this.maxElementsOnDisk;
    }

    public MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    public long getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    public void parseJSON(JSONObject jSONObject) throws JSONException {
        if (StringUtils.isNotEmpty(jSONObject.getString("maxElementsInMemory"))) {
            this.setMaxElementsInMemory(jSONObject.getInt("maxElementsInMemory"));
        }
        if (StringUtils.isNotEmpty(jSONObject.getString("memoryStoreEvictionPolicy"))) {
            this.setMemoryStoreEvictionPolicy(jSONObject.getString("memoryStoreEvictionPolicy"));
        }
        if (StringUtils.isNotEmpty(jSONObject.getString("timeToIdleSeconds"))) {
            this.setTimeToIdleSeconds(jSONObject.getLong("timeToIdleSeconds"));
        }
        if (StringUtils.isNotEmpty(jSONObject.getString("timeToLiveSeconds"))) {
            this.setTimeToLiveSeconds(jSONObject.getLong("timeToLiveSeconds"));
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && "CacheConfig".equals(string = xMLableReader.getTagName())) {
            String string2 = xMLableReader.getAttr("maxElementsInMemory");
            if (string2 != null) {
                this.setMaxElementsInMemory(Integer.parseInt(string2));
            }
            if ((string2 = xMLableReader.getAttr("memoryStoreEvictionPolicy")) != null) {
                this.setMemoryStoreEvictionPolicy(string2);
            }
            if ((string2 = xMLableReader.getAttr("timeToIdleSeconds")) != null) {
                this.setTimeToIdleSeconds(Long.parseLong(string2));
            }
            if ((string2 = xMLableReader.getAttr("timeToLiveSeconds")) != null) {
                this.setTimeToLiveSeconds(Long.parseLong(string2));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CacheConfig").attr("maxElementsInMemory", this.getMaxElementsInMemory()).attr("memoryStoreEvictionPolicy", this.getMemoryStoreEvictionPolicy().toString()).attr("timeToIdleSeconds", this.getTimeToIdleSeconds()).attr("timeToLiveSeconds", this.getTimeToLiveSeconds()).end();
    }
}

