/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.cache.store;

import com.fr.base.cache.FRCache;
import com.fr.base.cache.Unity;
import com.fr.base.cache.store.LfuPolicy;
import com.fr.base.cache.store.MemoryStore;
import java.util.HashMap;
import java.util.Iterator;

public class LfuMemoryStore
extends MemoryStore {
    protected LfuMemoryStore(FRCache fRCache) {
        super(fRCache);
        this.map = new HashMap();
    }

    public final synchronized void doPut(Unity unity) {
        if (this.isFull()) {
            this.removeLfuElement(unity);
        }
    }

    private void removeLfuElement(Unity unity) {
        Unity unity2 = this.findRelativelyUnused(unity);
        if (unity2.isExpired()) {
            this.remove(unity2.getObjectKey());
            this.notifyExpiry(unity2);
            return;
        }
        this.evict(unity2);
        this.remove(unity2.getObjectKey());
    }

    final Unity findRelativelyUnused(Unity unity) {
        LfuPolicy.Metadata[] metadataArray = this.sampleElements(this.map.size());
        LfuPolicy.Metadata metadata = LfuPolicy.leastHit(metadataArray, new UnityMetadata(unity));
        return (Unity)this.map.get(metadata.getObjectKey());
    }

    LfuPolicy.Metadata[] sampleElements(int n) {
        int[] nArray = LfuPolicy.generateRandomSample(n);
        LfuPolicy.Metadata[] metadataArray = new UnityMetadata[nArray.length];
        Iterator iterator = this.map.values().iterator();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i]; ++j) {
                iterator.next();
            }
            metadataArray[i] = new UnityMetadata((Unity)iterator.next());
        }
        return metadataArray;
    }

    private class UnityMetadata
    implements LfuPolicy.Metadata {
        private Unity element;

        public UnityMetadata(Unity unity) {
            this.element = unity;
        }

        public Object getObjectKey() {
            return this.element.getObjectKey();
        }

        public long getHitCount() {
            return this.element.getHitCount();
        }

        public int hashCode() {
            if (this.element != null) {
                return this.element.getKey().hashCode();
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof LfuPolicy.Metadata) {
                LfuPolicy.Metadata metadata = (LfuPolicy.Metadata)object;
                return this.getObjectKey().equals(metadata.getObjectKey());
            }
            return false;
        }
    }
}

