/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.cache.store;

import com.fr.base.cache.CacheException;
import com.fr.base.cache.FRCache;
import com.fr.base.cache.Unity;
import com.fr.base.cache.store.MemoryStore;
import java.util.LinkedHashMap;
import java.util.Map;

public class LruMemoryStore
extends MemoryStore {
    public LruMemoryStore(FRCache fRCache) {
        super(fRCache);
        this.map = new SpoolingLinkedHashMap();
    }

    public final class SpoolingLinkedHashMap
    extends LinkedHashMap {
        private static final int INITIAL_CAPACITY = 100;
        private static final float GROWTH_FACTOR = 0.75f;

        public SpoolingLinkedHashMap() {
            super(100, 0.75f, true);
        }

        protected final boolean removeEldestEntry(Map.Entry entry) {
            Unity unity = (Unity)entry.getValue();
            return this.removeLeastRecentlyUsedElement(unity);
        }

        private boolean removeLeastRecentlyUsedElement(Unity unity) throws CacheException {
            if (unity.isExpired()) {
                LruMemoryStore.this.notifyExpiry(unity);
                return true;
            }
            if (LruMemoryStore.this.isFull()) {
                LruMemoryStore.this.evict(unity);
                return true;
            }
            return false;
        }
    }
}

