/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core;

import com.fr.base.ArrayUtils;
import com.fr.base.FCloneable;
import com.fr.base.FRContext;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.Mapper;
import com.fr.base.core.util.ListMap;
import com.fr.util.OperatingSystem;
import com.fr.util.Utils;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;

public class BaseCoreUtils {
    private static final char[] digits = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    private BaseCoreUtils() {
    }

    public static String convertIntToABC(int n) {
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == 0) {
            return "";
        }
        while (n2 != 0) {
            int n3 = n2 % 26;
            if (n3 == 0) {
                n3 = 26;
            }
            stringBuffer.insert(0, digits[n3 - 1]);
            n2 = (n2 - n3) / 26;
        }
        return stringBuffer.toString();
    }

    public static int convertABCToInt(String string) {
        int n = 0;
        Character c = new Character('A');
        string = string.toUpperCase();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            n = Character.getNumericValue(string.charAt(i)) - Character.getNumericValue(c.charValue()) + 26 * n + 1;
        }
        return n;
    }

    public static String encodeString(String string, String[][] stringArray) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        block0: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            for (int j = 0; j < stringArray[1].length; ++j) {
                if (c != stringArray[1][j].charAt(0)) continue;
                stringBuffer.append(stringArray[0][j]);
                continue block0;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static double convertMillimetersToInches(double d) {
        return d / 25.4;
    }

    public static double convertInchesToMillimeters(double d) {
        BigDecimal bigDecimal = new BigDecimal("" + d);
        BigDecimal bigDecimal2 = new BigDecimal("25.4");
        return bigDecimal.multiply(bigDecimal2).doubleValue();
    }

    public static double convertInchesToMillimeters2Show(double d) {
        double d2 = BaseCoreUtils.convertInchesToMillimeters(d);
        return Math.floor(d2 * 10.0) / 10.0;
    }

    public static List getMacAddresses() throws IOException {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        Process process = null;
        BufferedReader bufferedReader = null;
        String string2 = System.getProperty("os.name", "");
        if (string2.startsWith("Windows")) {
            process = Runtime.getRuntime().exec(new String[]{"ipconfig", "/all"}, null);
        } else if (string2.startsWith("AIX")) {
            process = Runtime.getRuntime().exec(new String[]{"netstat", "-v"}, null);
        } else if (string2.startsWith("Solaris") || string2.startsWith("SunOS")) {
            object = BaseCoreUtils.getFirstLineOfCommand(new String[]{"uname", "-n"});
            if (object != null) {
                process = Runtime.getRuntime().exec(new String[]{"/usr/sbin/arp", object}, null);
            }
        } else if (new File("/usr/sbin/lanscan").exists()) {
            process = Runtime.getRuntime().exec(new String[]{"/usr/sbin/lanscan"}, null);
        } else if (new File("/sbin/ifconfig").exists()) {
            process = Runtime.getRuntime().exec(new String[]{"/sbin/ifconfig", "-a"}, null);
        }
        if (process != null) {
            object = process.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object), 128);
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                FRContext.getLogger().log(Level.INFO, string3);
                string = BaseCoreUtils.parseMacAddress(string3);
                if (string == null || BaseCoreUtils.parseShort(string) == 255) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public static String getMacAddress() throws IOException {
        return (String)BaseCoreUtils.getMacAddresses().get(0);
    }

    public static boolean matchMacAddress(String string) throws IOException {
        Object object;
        String string2 = null;
        Process process = null;
        BufferedReader bufferedReader = null;
        String string3 = System.getProperty("os.name", "");
        if (OperatingSystem.isWindows()) {
            process = Runtime.getRuntime().exec(new String[]{"ipconfig", "/all"}, null);
        } else if (string3.startsWith("AIX")) {
            process = Runtime.getRuntime().exec(new String[]{"netstat", "-v"}, null);
        } else if (string3.startsWith("Solaris") || string3.startsWith("SunOS")) {
            object = BaseCoreUtils.getFirstLineOfCommand(new String[]{"uname", "-n"});
            if (object != null) {
                process = Runtime.getRuntime().exec(new String[]{"/usr/sbin/arp", object}, null);
            }
        } else if (new File("/usr/sbin/lanscan").exists()) {
            process = Runtime.getRuntime().exec(new String[]{"/usr/sbin/lanscan"}, null);
        } else if (new File("/sbin/ifconfig").exists()) {
            process = Runtime.getRuntime().exec(new String[]{"/sbin/ifconfig", "-a"}, null);
        }
        object = string.split(",");
        if (process != null) {
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 128);
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                string2 = BaseCoreUtils.parseMacAddress(string4);
                if (string2 == null || BaseCoreUtils.parseShort(string2) == 255 || ArrayUtils.indexOf(object, string2) == -1) continue;
                return true;
            }
        }
        return false;
    }

    private static short parseShort(String string) throws NullPointerException {
        string = string.toLowerCase();
        short s = 0;
        int n = 0;
        for (int i = 0; i < string.length() && n < 4; ++i) {
            char c = string.charAt(i);
            if (c > '/' && c < ':') {
                s = (short)(s << 4);
                n = (byte)(n + 1);
                s = (short)(s | c - 48);
                continue;
            }
            if (c <= '`' || c >= 'g') continue;
            n = (byte)(n + 1);
            s = (short)(s << 4);
            s = (short)(s | c - 87);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFirstLineOfCommand(String[] stringArray) throws IOException {
        String string;
        block12: {
            IOException iOException3;
            Process process;
            block13: {
                process = null;
                BufferedReader bufferedReader = null;
                try {
                    process = Runtime.getRuntime().exec(stringArray);
                    bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 128);
                    string = bufferedReader.readLine();
                    Object var5_4 = null;
                    if (process == null) break block12;
                    if (bufferedReader == null) break block13;
                }
                catch (Throwable throwable) {
                    block16: {
                        IOException iOException22;
                        Object var5_5 = null;
                        if (process == null) break block16;
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException22) {
                                // empty catch block
                            }
                        }
                        try {
                            process.getErrorStream().close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                        try {
                            process.getOutputStream().close();
                        }
                        catch (IOException iOException22) {
                            // empty catch block
                        }
                        process.destroy();
                    }
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
            }
            try {
                process.getErrorStream().close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            try {
                process.getOutputStream().close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            process.destroy();
        }
        return string;
    }

    private static String parseMacAddress(String string) {
        int n;
        int n2;
        int n3 = string.indexOf("0x");
        if (n3 != -1 && string.indexOf("ETHER") != -1 && (n2 = string.indexOf(32, n3)) > n3 + 2) {
            return string.substring(n3, n2);
        }
        n2 = 0;
        if (string.indexOf(45) > -1) {
            string = string.replace('-', ':');
        }
        if ((n = string.lastIndexOf(58)) > string.length() - 2) {
            return null;
        }
        int n4 = Math.min(string.length(), n + 3);
        ++n2;
        int n5 = n;
        while (n2 != 5 && n != -1 && n > 1) {
            --n;
            if (n5 - (n = string.lastIndexOf(58, n)) != 3 && n5 - n != 2) continue;
            ++n2;
            n5 = n;
        }
        if (n2 == 5 && n > 1) {
            return string.substring(n - 2, n4).trim();
        }
        return null;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = BaseCoreUtils.hasAlpha(image);
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int n = 1;
            if (bl) {
                n = 2;
            }
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            FRContext.getLogger().log(Level.WARNING, headlessException.getMessage());
        }
        if (bufferedImage == null) {
            int n = 1;
            if (bl) {
                n = 2;
            }
            bufferedImage = GraphHelper.createBufferedImage(image.getWidth(null), image.getHeight(null), n);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            FRContext.getLogger().log(Level.WARNING, interruptedException.getMessage());
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    public static boolean checkDesingerActive(String string) {
        return string != null && string.length() == 26 && string.charAt(5) == 'A' && string.charAt(15) == 'F';
    }

    public static String writeESC(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block10: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block10;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block10;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block10;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block10;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block10;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block10;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block10;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String readESC(String string) throws Exception {
        if (string == null) {
            return "";
        }
        Pattern pattern = Pattern.compile("\\\\");
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find(n)) {
            n = matcher.start();
            stringBuffer.append(string.substring(n2, n));
            n2 = matcher.end();
            String string2 = string.substring(n2);
            if (string2.length() == 0) {
                throw new Exception("\\ can't be parsed.");
            }
            char c = string2.charAt(0);
            switch (c) {
                case 'n': {
                    stringBuffer.append('\n');
                    ++n2;
                    break;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    ++n2;
                    break;
                }
                case 't': {
                    stringBuffer.append('\t');
                    ++n2;
                    break;
                }
                case 'b': {
                    stringBuffer.append('\b');
                    ++n2;
                    break;
                }
                case 'f': {
                    stringBuffer.append('\f');
                    ++n2;
                    break;
                }
                case '\"': {
                    stringBuffer.append('\"');
                    ++n2;
                    break;
                }
                case '\'': {
                    stringBuffer.append('\'');
                    ++n2;
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    ++n2;
                    break;
                }
                case 'u': {
                    String string3 = string.substring(n2);
                    if (string3.length() < 4) {
                        throw new Exception("\\u" + string3 + " can't be parsed.");
                    }
                    stringBuffer.append(BaseCoreUtils.parseHex(string3.substring(0, 4)));
                    n2 += 5;
                    break;
                }
                default: {
                    int n3 = 0;
                    if (string2.matches("[0-3][0-7][0-7].*")) {
                        n3 = 3;
                    } else if (string2.matches("[0-7][0-7].*")) {
                        n3 = 2;
                    } else if (string2.matches("[0-7].*")) {
                        n3 = 1;
                    }
                    if (n3 > 0) {
                        stringBuffer.append(BaseCoreUtils.parseOctal(string.substring(n2, n2 + n3)));
                        n2 += n3;
                        break;
                    }
                    throw new Exception("\\" + string2 + " can't be parsed.");
                }
            }
            n = n2;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private static char parseHex(String string) {
        return (char)Integer.decode("0x" + string).intValue();
    }

    private static char parseOctal(String string) {
        return (char)Integer.decode('0' + string).intValue();
    }

    public static String[] pathSplit(String string) {
        return string.split("[/\\\\]");
    }

    public static String pathJoin(String[] stringArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string == null) {
                string = "";
            }
            if (i > 0 && (string.startsWith("/") || string.startsWith("\\"))) {
                string = string.substring(1);
            }
            stringBuffer.append(string);
            if (i + 1 >= n || string.endsWith("/") || string.endsWith("\\")) continue;
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    public static String getRelativePath(File file, File file2) {
        String string = file.getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        if (string.length() < string2.length()) {
            return null;
        }
        if (string.equals(string2)) {
            return "";
        }
        if (string.startsWith(string2)) {
            String string3 = string.substring(string2.length());
            if (!string3.startsWith("/") && !string3.startsWith("\\")) {
                string3 = File.separator + string3;
            }
            return string3;
        }
        return null;
    }

    public static String join(Collection collection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuffer.append(e);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String join(Collection collection) {
        return BaseCoreUtils.join(collection, "");
    }

    public static String join(Object[] objectArray, String string) {
        return BaseCoreUtils.join(Arrays.asList(objectArray), string);
    }

    public static String join(Object[] objectArray) {
        return BaseCoreUtils.join(objectArray, "");
    }

    public static List map(List list, Mapper mapper) {
        int n = list.size();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = mapper.map(i, list.get(i), list);
        }
        return Arrays.asList(objectArray);
    }

    public static Object cloneObject(Object object) throws CloneNotSupportedException {
        if (object instanceof FCloneable) {
            return ((FCloneable)object).clone();
        }
        if (object instanceof Cloneable) {
            Method method = Utils.getDeclaredMethod(object.getClass(), "clone", new Class[0]);
            method.setAccessible(true);
            try {
                return method.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return object;
    }

    public static Map cloneMap(Map map) throws CloneNotSupportedException {
        if (map == null) {
            return null;
        }
        if (map instanceof HashMap) {
            return (Map)((HashMap)map).clone();
        }
        if (map instanceof Hashtable) {
            return (Map)((Hashtable)map).clone();
        }
        if (map instanceof ListMap) {
            return (Map)((ListMap)map).clone();
        }
        try {
            Method method = Utils.getDeclaredMethod(map.getClass(), "clone", new Class[0]);
            method.setAccessible(true);
            return (Map)method.invoke((Object)map, new Object[0]);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            return map;
        }
    }
}

