/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core;

import com.fr.base.core.DateUtils;
import com.fr.base.xml.BaseXMLUtils;
import java.awt.Image;
import java.lang.reflect.Array;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ComparatorUtils {
    private static final double NUMBER_FOR_PRECISE_COMPARE = 1.0E-9;

    private ComparatorUtils() {
    }

    public static int compare(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == null && object2 == null ? 0 : (object == null ? -1 : 1);
        }
        if (object instanceof Date || object2 instanceof Date) {
            long l;
            Date date = DateUtils.object2Date(object, true);
            Date date2 = DateUtils.object2Date(object2, true);
            long l2 = date == null ? 0L : date.getTime();
            long l3 = l = date2 == null ? 0L : date2.getTime();
            return l2 == l ? 0 : (l2 > l ? 1 : -1);
        }
        if (object instanceof Number && !(object2 instanceof Number)) {
            try {
                object2 = Double.valueOf(object2.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object2 instanceof Number && !(object instanceof Number)) {
            try {
                object = Double.valueOf(object.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object instanceof Number && object2 instanceof Number) {
            return ComparatorUtils.compare(((Number)object).doubleValue(), ((Number)object2).doubleValue());
        }
        return object.toString().toLowerCase().compareTo(object2.toString().toLowerCase());
    }

    public static int compare(double d, double d2) {
        double d3 = d - d2;
        return Math.abs(d3) < 1.0E-9 ? 0 : (d3 > 0.0 ? 1 : -1);
    }

    public static int compare(Comparator comparator, Object object, Object object2) {
        if (comparator instanceof Collator && object != null && object2 != null) {
            return comparator.compare(object.toString().toLowerCase(), object2.toString().toLowerCase());
        }
        return ComparatorUtils.compare(object, object2);
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return object == null && object2 == null;
        }
        if (object instanceof Date || object2 instanceof Date) {
            return ComparatorUtils.compare(object, object2) == 0;
        }
        try {
            if (object instanceof Number && !(object2 instanceof Number)) {
                object2 = Double.valueOf(object2.toString());
            }
            if (object2 instanceof Number && !(object instanceof Number)) {
                object = Double.valueOf(object.toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (object instanceof Number && object2 instanceof Number) {
            return ComparatorUtils.compare(object, object2) == 0;
        }
        if (object.getClass().isArray() && object2.getClass().isArray()) {
            int n;
            int n2 = Array.getLength(object);
            if (n2 != (n = Array.getLength(object2))) {
                return false;
            }
            for (int i = 0; i < n2; ++i) {
                if (ComparatorUtils.equals(Array.get(object, i), Array.get(object2, i))) continue;
                return false;
            }
            return true;
        }
        if (object instanceof List && object2 instanceof List) {
            if (((List)object).size() != ((List)object2).size()) {
                return false;
            }
            for (int i = 0; i < ((List)object).size(); ++i) {
                if (ComparatorUtils.equals(((List)object).get(i), ((List)object2).get(i))) continue;
                return false;
            }
            return true;
        }
        return object.equals(object2);
    }

    public static boolean equals_exactly(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == null && object2 == null;
        }
        if (object instanceof Date && object2 instanceof Date) {
            return ((Date)object).getTime() == ((Date)object2).getTime();
        }
        if (object instanceof Number && object2 instanceof Number) {
            return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
        }
        return object.equals(object2);
    }

    public static boolean imageEquals(Image image, Image image2) {
        byte[] byArray;
        if (image == null || image2 == null) {
            return image == null && image2 == null;
        }
        byte[] byArray2 = BaseXMLUtils.encodeImage(image);
        if (byArray2.length != (byArray = BaseXMLUtils.encodeImage(image2)).length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean tableDataColumnNameEquals(String string, String string2) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        return string.toLowerCase().equals(string2.toLowerCase());
    }

    public static boolean equals(Iterator iterator, Iterator iterator2) {
        if (iterator == null) {
            iterator = Collections.EMPTY_LIST.iterator();
        }
        if (iterator2 == null) {
            iterator2 = Collections.EMPTY_LIST.iterator();
        }
        boolean bl = iterator.hasNext();
        boolean bl2 = iterator2.hasNext();
        while (bl && bl2) {
            if (!ComparatorUtils.equals(iterator.next(), iterator2.next())) {
                return false;
            }
            bl = iterator.hasNext();
            bl2 = iterator2.hasNext();
        }
        return bl == bl2;
    }
}

