/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.data.core.db.YearDate;
import com.fr.util.Utils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class DateUtils {
    public static final DateFormat DATEFORMAT1 = new SimpleDateFormat("yyyy/MM/dd");
    public static final DateFormat DATEFORMAT2 = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat DATEFORMAT3 = new SimpleDateFormat("dd/MM/yyyy");
    public static final DateFormat DATEFORMAT4 = new SimpleDateFormat("MM/dd/yyyy");
    public static final DateFormat DATETIMEFORMAT1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    public static final DateFormat DATETIMEFORMAT2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final DateFormat DATETIMEFORMAT3 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final DateFormat DATETIMEFORMAT4 = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    public static final DateFormat TIMEFORMAT = new SimpleDateFormat("HH:mm:ss");
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
    public static final String SECOND = "s";
    public static final String MINUTE = "m";
    public static final String HOUR = "h";
    public static final String DAY = "d";
    public static final String WEEK = "w";

    private DateUtils() {
    }

    public static synchronized String getDate2Str(String string, Date date) {
        simpleDateFormat.applyPattern(string);
        return simpleDateFormat.format(date);
    }

    public static String getDate2LStr(Date date) {
        return DateUtils.getDate2Str("yyyy-MM-dd HH:mm:ss", date);
    }

    public static String getDate2AllIncludeSSS(Date date) {
        return DateUtils.getDate2Str("yyyyMMddHmmssSSS", date);
    }

    public static Date createDate(int n, int n2, int n3) {
        return DateUtils.createDate(n, n2, n3, 0, 0, 0);
    }

    public static Date createDate(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(0L);
        calendar.set(1, n);
        calendar.set(2, n2 - 1);
        calendar.set(5, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        return calendar.getTime();
    }

    public static Date object2Date(Object object, boolean bl) {
        Date date = null;
        if (object instanceof Date) {
            date = (Date)object;
        } else if (object instanceof Calendar) {
            date = ((Calendar)object).getTime();
        } else if (object instanceof Number) {
            long l = ((Number)object).longValue();
            date = l > 1000000L ? new Date(l) : new Date((l - 25569L) * 1000L * 24L * 60L * 60L);
        } else if (object != null) {
            date = DateUtils.string2Date(Utils.objectToString(object), bl);
        }
        if (!bl && date == null) {
            date = new Date();
        }
        return date;
    }

    public static Date string2Date(String string, boolean bl) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        if (string.matches("^\\d+$")) {
            return DateUtils.object2Date(Long.valueOf(string), true);
        }
        if (string.matches("\\d{1,2}/\\d{1,2}/\\d{4}")) {
            try {
                return DATEFORMAT4.parse(string);
            }
            catch (ParseException parseException) {
                FRContext.getLogger().log(Level.WARNING, string + " can't be parsed to Date");
            }
        }
        try {
            return DATETIMEFORMAT1.parse(string);
        }
        catch (ParseException parseException) {
            try {
                return DATETIMEFORMAT2.parse(string);
            }
            catch (ParseException parseException2) {
                try {
                    return DATETIMEFORMAT3.parse(string);
                }
                catch (ParseException parseException3) {
                    try {
                        return DATETIMEFORMAT4.parse(string);
                    }
                    catch (ParseException parseException4) {
                        try {
                            return DATEFORMAT1.parse(string);
                        }
                        catch (ParseException parseException5) {
                            try {
                                return DATEFORMAT2.parse(string);
                            }
                            catch (ParseException parseException6) {
                                try {
                                    return DATEFORMAT3.parse(string);
                                }
                                catch (ParseException parseException7) {
                                    if (bl) {
                                        return null;
                                    }
                                    FRContext.getLogger().log(Level.WARNING, string + " can't be parsed to Date");
                                    return new Date();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static long subtractDate(Date date, Date date2, String string) {
        long l = date.getTime();
        long l2 = date2.getTime();
        long l3 = l - l2;
        if (SECOND.equals(string)) {
            return l3 / 1000L;
        }
        if (MINUTE.equals(string)) {
            return l3 / 60000L;
        }
        if (HOUR.equals(string)) {
            return l3 / 3600000L;
        }
        if (DAY.equals(string)) {
            return l3 / 86400000L;
        }
        if (WEEK.equals(string)) {
            return l3 / 604800000L;
        }
        return l3 / 86400000L;
    }

    public static Date datePlusInteger(Date date, int n) {
        long l = date.getTime();
        return new Date(l += (long)n * 24L * 3600L * 1000L);
    }

    public static YearDate date2Year(Object object) {
        YearDate yearDate = null;
        if (object instanceof String) {
            Date date = DateUtils.string2Date(object.toString(), true);
            if (date != null) {
                object = date;
            } else if (Pattern.compile("^\\d{4}").matcher((String)object).find()) {
                yearDate = new YearDate(((String)object).substring(0, 4));
            }
        }
        if (object instanceof Date) {
            yearDate = new YearDate((Date)object);
        } else if (object instanceof java.sql.Date) {
            yearDate = new YearDate((java.sql.Date)object);
        }
        return yearDate;
    }
}

