/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core;

import com.fr.base.FRContext;
import com.fr.base.FRFont;
import com.fr.base.StringUtils;
import com.fr.base.Style;
import com.fr.base.core.BaseCoreConstants;
import com.fr.base.core.DoubleDimension2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;

public class GraphHelper {
    private static Line2D tmpLine2D = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
    private static Font oldFont = null;
    private static FontMetrics oldFontMetrics = null;
    private static Hashtable fontMetricsHash = new Hashtable();
    private static Stroke[] LineStrokeArray = new Stroke[15];
    private static final MediaTracker mediaTracker = new MediaTracker(new JLabel());

    public static void draw(Graphics graphics, Shape shape) {
        GraphHelper.draw(graphics, shape, 1);
    }

    public static void draw(Graphics graphics, Shape shape, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        BasicStroke basicStroke = (BasicStroke)GraphHelper.getStroke(n);
        if (shape instanceof RoundRectangle2D && GraphHelper.getLineStyleSize(n) == 1) {
            basicStroke = new BasicStroke(0.2f, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
        }
        GraphHelper.setStroke(graphics2D, basicStroke);
        graphics2D.draw(shape);
    }

    public static void drawLine(Graphics graphics, double d, double d2, double d3, double d4) {
        GraphHelper.drawLine(graphics, d, d2, d3, d4, 1);
    }

    public static void drawLine(Graphics graphics, double d, double d2, double d3, double d4, int n) {
        double d5;
        double d6;
        int n2;
        if (n == 0) {
            return;
        }
        if (n == 6) {
            double d7 = d3 - d;
            double d8 = d4 - d2;
            int n3 = (int)Math.sqrt(d7 * d7 + d8 * d8);
            if (n3 != 0) {
                int n4 = (int)(-d8 / (double)n3);
                int n5 = (int)(d7 / (double)n3);
                GraphHelper.drawLine(graphics, d - (double)n4, d2 - (double)n5, d3 - (double)n4, d4 - (double)n5, 1);
                GraphHelper.drawLine(graphics, d + (double)n4, d2 + (double)n5, d3 + (double)n4, d4 + (double)n5, 1);
                return;
            }
        } else if (n == 15 && (n2 = (int)Math.sqrt((d6 = d3 - d) * d6 + (d5 = d4 - d2) * d5)) != 0) {
            boolean bl = true;
            int n6 = (int)(-d5 * (double)bl / (double)n2);
            int n7 = (int)(d6 * (double)bl / (double)n2);
            GraphHelper.drawLine(graphics, d, d2, d3, d4, 7);
            GraphHelper.drawLine(graphics, d + (double)n6, d2 + (double)n7, d3 + (double)n6, d4 + (double)n7, 7);
            return;
        }
        tmpLine2D.setLine(d, d2, d3, d4);
        GraphHelper.draw(graphics, tmpLine2D, n);
    }

    public static void drawRect(Graphics graphics, double d, double d2, double d3, double d4) {
        GraphHelper.drawRect(graphics, d, d2, d3, d4, 1);
    }

    public static void drawRect(Graphics graphics, double d, double d2, double d3, double d4, int n) {
        GraphHelper.draw(graphics, new Rectangle2D.Double(d, d2, d3, d4), n);
    }

    public static void drawArc(Graphics graphics, double d, double d2, double d3, double d4, double d5, double d6) {
        GraphHelper.drawArc(graphics, d, d2, d3, d4, d5, d6, 1);
    }

    public static void drawArc(Graphics graphics, double d, double d2, double d3, double d4, double d5, double d6, int n) {
        GraphHelper.draw(graphics, new Arc2D.Double(d, d2, d3, d4, d5, d6, 2), n);
    }

    public static void drawTestGrid(Graphics graphics, Color color, double d, double d2) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n2 = (int)d2 / 10;
        int n3 = (int)d / 10;
        graphics2D.setPaint(Color.RED);
        for (n = 0; n < n2; ++n) {
            GraphHelper.drawLine(graphics2D, 15.0, n * 10, d - 15.0, n * 10);
            GraphHelper.drawRotatedString(graphics2D, Integer.toString(n * 10), 0.0, n * 10, 0);
        }
        for (n = 0; n < n3; ++n) {
            GraphHelper.drawLine(graphics2D, n * 10, 15.0, n * 10, d2 - 15.0);
            GraphHelper.drawRotatedString(graphics2D, Integer.toString(n * 10), n * 10, 0.0, -90);
        }
    }

    public static void fill(Graphics graphics, Shape shape) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.fill(shape);
    }

    public static void fillRect(Graphics graphics, double d, double d2, double d3, double d4) {
        GraphHelper.fill(graphics, new Rectangle2D.Double(d, d2, d3, d4));
    }

    public static void fillArc(Graphics graphics, double d, double d2, double d3, double d4, double d5, double d6) {
        GraphHelper.fill(graphics, new Arc2D.Double(d, d2, d3, d4, d5, d6, 2));
    }

    public static void drawString(Graphics graphics, String string, double d, double d2) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        if (graphics.getFont() instanceof FRFont) {
            FRFont fRFont = (FRFont)graphics.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(fRFont);
            int n = fRFont.getStyle();
            if (fRFont.isSuperscript()) {
                d2 -= (double)(fontMetrics.getAscent() / 3);
                fRFont = FRFont.getInstance(fRFont.getName(), n, fRFont.getSize() * 2 / 3, fRFont.getForeground(), fRFont.getUnderline(), fRFont.isStrikethrough(), fRFont.isShadow(), fRFont.isSuperscript(), fRFont.isSubscript());
                fontMetrics = graphics.getFontMetrics(fRFont);
                graphics.setFont(fRFont);
            } else if (fRFont.isSubscript()) {
                d2 += (double)(fontMetrics.getDescent() / 3);
                fRFont = FRFont.getInstance(fRFont.getName(), n, fRFont.getSize() * 2 / 3, fRFont.getForeground(), fRFont.getUnderline(), fRFont.isStrikethrough(), fRFont.isShadow(), fRFont.isSuperscript(), fRFont.isSubscript());
                fontMetrics = graphics.getFontMetrics(fRFont);
                graphics.setFont(fRFont);
            }
            if (fRFont.isShadow()) {
                Color color = graphics.getColor();
                graphics.setColor(color.brighter());
                GraphHelper.drawNormalString(graphics, string, d + 1.0, d2 + 1.0);
                graphics.setColor(color);
            }
            GraphHelper.drawNormalString(graphics, string, d, d2);
            if (fRFont.getUnderline() != 0) {
                double d3 = d2 + (double)fontMetrics.getDescent() + (double)GraphHelper.getLineStyleSize(fRFont.getUnderline());
                GraphHelper.drawLine(graphics, d, d3, d + (double)fontMetrics.stringWidth(string), d3, fRFont.getUnderline());
            }
            if (fRFont.isStrikethrough()) {
                int n2 = fontMetrics.getHeight() + 1;
                double d4 = d2 - (double)fontMetrics.getAscent() + (double)(n2 / 2);
                GraphHelper.drawLine(graphics, d, d4, d + (double)fontMetrics.stringWidth(string), d4, 1);
            }
        } else {
            GraphHelper.drawNormalString(graphics, string, d, d2);
        }
    }

    private static void drawNormalString(Graphics graphics, String string, double d, double d2) {
        ((Graphics2D)graphics).drawString(string, (float)d, (float)d2);
    }

    public static void drawRotatedString(Graphics graphics, String string, double d, double d2, int n) {
        GraphHelper.drawRotatedString(graphics, string, d, d2, n, 1.0);
    }

    public static void drawRotatedString(Graphics graphics, String string, double d, double d2, int n, double d3) {
        Object object;
        Serializable serializable;
        if (string == null || string.length() == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = graphics2D.getFont();
        if (graphics2D.getFont() instanceof FRFont) {
            serializable = (FRFont)graphics2D.getFont();
            object = graphics2D.getFontMetrics((Font)serializable);
            int n2 = ((Font)serializable).getStyle();
            if (((FRFont)serializable).isSuperscript()) {
                d2 -= (double)(((FontMetrics)object).getAscent() / 3);
                serializable = FRFont.getInstance(((Font)serializable).getName(), n2, ((Font)serializable).getSize() * 2 / 3, ((FRFont)serializable).getForeground(), ((FRFont)serializable).getUnderline(), ((FRFont)serializable).isStrikethrough(), ((FRFont)serializable).isShadow(), ((FRFont)serializable).isSuperscript(), ((FRFont)serializable).isSubscript());
                graphics2D.setFont((Font)serializable);
            } else if (((FRFont)serializable).isSubscript()) {
                d2 += (double)(((FontMetrics)object).getDescent() / 3);
                serializable = FRFont.getInstance(((Font)serializable).getName(), n2, ((Font)serializable).getSize() * 2 / 3, ((FRFont)serializable).getForeground(), ((FRFont)serializable).getUnderline(), ((FRFont)serializable).isStrikethrough(), ((FRFont)serializable).isShadow(), ((FRFont)serializable).isSuperscript(), ((FRFont)serializable).isSubscript());
                graphics2D.setFont((Font)serializable);
            }
        }
        serializable = graphics2D.getFontMetrics();
        object = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D = ((FontMetrics)serializable).getStringBounds(string, graphics2D);
        LineMetrics lineMetrics = font.getLineMetrics(string, (FontRenderContext)object);
        double d4 = lineMetrics.getDescent();
        double d5 = lineMetrics.getLeading();
        double[] dArray = new double[]{-rectangle2D.getWidth() / 2.0, -d4 - d5 + rectangle2D.getHeight() / 2.0};
        double[] dArray2 = new double[]{rectangle2D.getWidth() / 2.0, d4 + d5 - rectangle2D.getHeight() / 2.0};
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(Math.toRadians(n), d + dArray[0] + dArray2[0], d2 + dArray[1] + dArray2[1]);
        graphics2D.transform(affineTransform2);
        TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
        if (graphics2D.getFont() instanceof FRFont) {
            FRFont fRFont = (FRFont)graphics2D.getFont();
            float f = (float)(d + dArray[0]);
            float f2 = (float)(d2 + dArray[1]);
            if (fRFont.isShadow()) {
                Color color = graphics2D.getColor();
                graphics2D.setColor(color.brighter());
                graphics2D.scale(d3, d3);
                textLayout.draw(graphics2D, (float)((double)(f + 1.0f) / d3), (float)((double)(f2 + 1.0f) / d3));
                graphics2D.scale(1.0 / d3, 1.0 / d3);
                graphics2D.setColor(color);
            }
            int n3 = ((FontMetrics)serializable).stringWidth(string);
            GraphHelper.drawLine(graphics2D, f, f2 + (float)((FontMetrics)serializable).getDescent(), f + (float)n3, f2 + (float)((FontMetrics)serializable).getDescent(), fRFont.getUnderline());
            if (fRFont.isStrikethrough()) {
                GraphHelper.drawLine(graphics2D, f, f2 + (float)((FontMetrics)serializable).getDescent() - (float)(((FontMetrics)serializable).getAscent() / 2) - (float)(((FontMetrics)serializable).getDescent() / 2), f + (float)n3, f2 + (float)((FontMetrics)serializable).getDescent() - (float)(((FontMetrics)serializable).getAscent() / 2) - (float)(((FontMetrics)serializable).getDescent() / 2));
            }
            graphics2D.scale(d3, d3);
            textLayout.draw(graphics2D, (float)((double)f / d3), (float)((double)f2 / d3));
            graphics2D.scale(1.0 / d3, 1.0 / d3);
        } else {
            graphics2D.scale(d3, d3);
            textLayout.draw(graphics2D, (float)((d + dArray[0]) / d3), (float)((d2 + dArray[1]) / d3));
            graphics2D.scale(1.0 / d3, 1.0 / d3);
        }
        graphics2D.setTransform(affineTransform);
    }

    public static void drawAutoWrapString(Graphics2D graphics2D, String string, double d, double d2, double d3) {
        GraphHelper.drawAutoWrapString(graphics2D, string, d, d2, d3, 0.0);
    }

    public static void drawAutoWrapString(Graphics2D graphics2D, String string, double d, double d2, double d3, double d4) {
        Object object;
        int n;
        int n2;
        int n3 = string.length();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        for (n2 = 0; n2 < n3; ++n2) {
            n = string.charAt(n2);
            if (n == 13) {
                if (n2 < n3 - 1 && string.charAt(n2 + 1) == '\n') {
                    stringTokenizer = new StringTokenizer(string, "\r\n");
                    break;
                }
                stringTokenizer = new StringTokenizer(string, "\r");
                break;
            }
            if (n == 10) break;
        }
        n2 = 0;
        n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        while (stringTokenizer.hasMoreElements()) {
            object = stringTokenizer.nextToken();
            if (object == null) {
                object = " ";
            }
            stringArray[n2++] = object;
        }
        object = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            AttributedString attributedString = new AttributedString(stringArray[i], graphics2D.getFont().getAttributes());
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), graphics2D.getFontRenderContext());
            while (lineBreakMeasurer.getPosition() < stringArray[i].length()) {
                ((Vector)object).add(lineBreakMeasurer.nextLayout((float)d3));
            }
        }
        double d5 = d;
        double d6 = d2;
        AffineTransform affineTransform = null;
        if (d4 != 0.0) {
            affineTransform = new AffineTransform();
            affineTransform.setToRotation(-Math.toRadians(d4));
        }
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            TextLayout textLayout = (TextLayout)((Vector)object).elementAt(i);
            d5 = textLayout.isLeftToRight() ? d : d3 - (double)textLayout.getAdvance();
            double[] dArray = new double[]{0.0, textLayout.getAscent(), 0.0, textLayout.getDescent(), 0.0, textLayout.getLeading()};
            if (affineTransform != null) {
                affineTransform.transform(dArray, 0, dArray, 0, 3);
            }
            AffineTransform affineTransform2 = graphics2D.getTransform();
            graphics2D.translate(d5, d6 += dArray[1]);
            if (affineTransform != null) {
                graphics2D.transform(affineTransform);
            } else {
                graphics2D.transform(new AffineTransform());
            }
            textLayout.draw(graphics2D, 0.0f, 0.0f);
            graphics2D.setTransform(affineTransform2);
            d6 += dArray[3] + dArray[5];
        }
    }

    public static void waitForImage(Image image) {
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        mediaTracker.removeImage(image);
    }

    public static BufferedImage createBufferedImageFromImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        GraphHelper.waitForImage(image);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = GraphHelper.createBufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public static void setStroke(Graphics2D graphics2D, Stroke stroke) {
        Stroke stroke2 = graphics2D.getStroke();
        if (stroke.hashCode() != stroke2.hashCode()) {
            graphics2D.setStroke(stroke);
        }
    }

    public static Stroke getStroke(int n) {
        Stroke stroke = null;
        if (n < LineStrokeArray.length) {
            stroke = LineStrokeArray[n];
            if (stroke != null) {
                return stroke;
            }
        } else {
            Stroke[] strokeArray = LineStrokeArray;
            LineStrokeArray = new Stroke[Math.max(10, strokeArray.length * 2)];
            System.arraycopy(strokeArray, 0, LineStrokeArray, 0, strokeArray.length);
        }
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 1: {
                stroke = new BasicStroke(1.0f, n2, n3);
                break;
            }
            case 2: {
                stroke = new BasicStroke(2.0f, n2, n3);
                break;
            }
            case 3: {
                stroke = new BasicStroke(1.0f, n2, n3, 10.0f, new float[]{4.0f, 2.0f}, 0.0f);
                break;
            }
            case 4: {
                stroke = new BasicStroke(1.0f, n2, n3, 10.0f, new float[]{2.0f}, 0.0f);
                break;
            }
            case 14: {
                stroke = new BasicStroke(1.0f, n2, n3, 10.0f, new float[]{4.0f}, 0.0f);
                break;
            }
            case 5: {
                stroke = new BasicStroke(3.0f, n2, n3);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                stroke = new BasicStroke(1.0f, n2, n3, 10.0f, new float[]{1.0f}, 0.0f);
                break;
            }
            case 8: {
                stroke = new BasicStroke(2.0f, n2, n3, 10.0f, new float[]{8.0f, 2.0f}, 0.0f);
                break;
            }
            case 9: {
                stroke = new BasicStroke(1.0f, n2, n3, 10.0f, new float[]{8.0f, 4.0f, 2.0f, 4.0f}, 0.0f);
                break;
            }
            case 10: {
                stroke = new BasicStroke(2.0f, n2, n3, 10.0f, new float[]{8.0f, 4.0f, 2.0f, 4.0f}, 0.0f);
                break;
            }
            case 11: {
                stroke = new BasicStroke(1.0f, n2, n3, 10.0f, new float[]{8.0f, 4.0f, 2.0f, 4.0f, 2.0f, 4.0f}, 0.0f);
                break;
            }
            case 12: {
                stroke = new BasicStroke(2.0f, n2, n3, 10.0f, new float[]{8.0f, 4.0f, 2.0f, 4.0f, 2.0f, 4.0f}, 0.0f);
                break;
            }
            case 13: {
                stroke = new BasicStroke(2.0f, n2, n3, 10.0f, new float[]{8.0f, 4.0f, 2.0f, 4.0f}, 0.0f);
                break;
            }
        }
        if (stroke == null) {
            stroke = new BasicStroke(1.0f, n2, n3);
        }
        GraphHelper.LineStrokeArray[n] = stroke;
        return stroke;
    }

    public static int getLineStyleSize(int n) {
        if (n == 0) {
            return 0;
        }
        if (n == 2 || n == 6 || n == 8 || n == 10 || n == 12 || n == 13) {
            return 2;
        }
        if (n == 5) {
            return 3;
        }
        return 1;
    }

    public static double stringWidth(String string, Font font, FontRenderContext fontRenderContext) {
        FRFont fRFont;
        if (string == null || string.length() <= 0) {
            return 0.0;
        }
        double d = font.getStringBounds(string, fontRenderContext).getWidth();
        if (font instanceof FRFont && ((fRFont = (FRFont)font).isSuperscript() || fRFont.isSubscript())) {
            d = d * 2.0 / 3.0;
        }
        return d;
    }

    public static Dimension2D stringDimension(String string, Font font, int n, FontRenderContext fontRenderContext) {
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        double d = rectangle2D.getWidth();
        double d2 = Math.toRadians(n);
        return new DoubleDimension2D(d * Math.abs(Math.cos(d2)) + rectangle2D.getHeight() * Math.abs(Math.sin(d2)), d * Math.abs(Math.sin(d2)) + rectangle2D.getHeight() * Math.abs(Math.cos(d2)));
    }

    public static BufferedImage createBufferedImage(int n, int n2) {
        return GraphHelper.createBufferedImage(n, n2, 2);
    }

    public static BufferedImage createBufferedImage(int n, int n2, int n3) {
        if (n <= 0) {
            n = 1;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        return new BufferedImage(n, n2, n3);
    }

    public static FontMetrics getFontMetrics(Font font) {
        Serializable serializable;
        if (font == oldFont) {
            return oldFontMetrics;
        }
        if (font == null) {
            serializable = FRContext.getDefaultValues();
            font = serializable.getFRFont();
        }
        if ((serializable = (FontMetrics)fontMetricsHash.get(font)) == null) {
            serializable = BaseCoreConstants.getDefaultToolkit().getFontMetrics(font);
            fontMetricsHash.put(font, serializable);
        }
        oldFont = font;
        oldFontMetrics = serializable;
        return serializable;
    }

    public static void paintImage(Graphics graphics, int n, int n2, Image image, Style style, int n3, int n4, int n5) {
        if (image == null) {
            return;
        }
        GraphHelper.waitForImage(image);
        int n6 = n4 == -1 ? image.getWidth(null) : n4;
        int n7 = n5 == -1 ? image.getHeight(null) : n5;
        if (n3 == 0) {
            if (n6 < 0 || n7 < 0) {
                return;
            }
            for (int i = 0; i < n; i += n6) {
                for (int j = 0; j < n2; j += n7) {
                    graphics.drawImage(image, i, j, n6, n7, null);
                }
            }
        } else if (n3 == 1) {
            graphics.drawImage(image, (n - n6) / 2, (n2 - n7) / 2, n6, n7, null);
        } else if (n3 == 2) {
            graphics.drawImage(image, 0, 0, n, n2, null);
        } else if (n3 == 3) {
            int n8;
            int n9;
            if (style == null) {
                n9 = 0;
                n8 = 0;
            } else {
                n9 = style.getHorizontalAlignment() == 4 ? n - n6 : (style.getHorizontalAlignment() == 0 ? (n - n6) / 2 : 0);
                n8 = style.getVerticalAlignment() == 3 ? n2 - n7 : (style.getVerticalAlignment() == 0 ? (n2 - n7) / 2 : 0);
            }
            if (n6 > 0 && n7 > 0) {
                graphics.drawImage(image, n9, n8, n6, n7, null);
            }
        }
    }

    public static void paintImage2(Graphics graphics, int n, int n2, Image image, Style style, int n3, int n4, int n5, int n6, int n7) {
        block16: {
            int n8;
            int n9;
            int n10;
            int n11;
            block18: {
                block17: {
                    block15: {
                        if (image == null) {
                            return;
                        }
                        GraphHelper.waitForImage(image);
                        n11 = n4 == -1 ? image.getWidth(null) : n4;
                        n10 = n5 == -1 ? image.getHeight(null) : n5;
                        if (n11 < 0 || n10 < 0) {
                            return;
                        }
                        if (n3 != 0) break block15;
                        int n12 = -n6;
                        int n13 = -n6;
                        for (int i = -n6; i < n; i += n11) {
                            if ((i + n6) / n > (n12 + n6) / n) {
                                i = ((n12 + n6) / n + 1) * n - n6;
                            }
                            for (int j = -n7; j < n2; j += n10) {
                                if ((j + n7) / n2 > (n13 + n7) / n2) {
                                    j = ((n13 + n7) / n2 + 1) * n2 - n7;
                                }
                                graphics.drawImage(image, i, j, n11, n10, null);
                                n12 = i;
                                n13 = j;
                            }
                        }
                        break block16;
                    }
                    if (n3 != 1) break block17;
                    for (int i = ((n - n11) / 2 - n6) % n; i < n; i += n) {
                        for (int j = ((n2 - n10) / 2 - n7) % n2; j < n2; j += n2) {
                            graphics.drawImage(image, Math.max(i, i - (n - n11) / 2), Math.max(j, j - (n2 - n10) / 2), i > i - (n - n11) / 2 ? n11 : n, j > j - (n2 - n10) / 2 ? n10 : n2, null);
                        }
                    }
                    break block16;
                }
                if (n3 != 2) break block18;
                for (int i = -n6 % n; i < n; i += n) {
                    for (int j = -n7 % n2; j < n2; j += n2) {
                        graphics.drawImage(image, i, j, n, n2, null);
                    }
                }
                break block16;
            }
            if (n3 != 3) break block16;
            if (style == null) {
                n9 = -n6;
                n8 = -n7;
            } else {
                n9 = style.getHorizontalAlignment() == 4 ? n - n11 - n6 : (style.getHorizontalAlignment() == 0 ? (n - n11) / 2 - n6 : -n6);
                n8 = style.getVerticalAlignment() == 3 ? n2 - n10 - n7 : (style.getVerticalAlignment() == 0 ? (n2 - n10) / 2 - n7 : -n7);
            }
            if (n11 > 0 && n10 > 0) {
                for (int i = n9 % n; i < n; i += n) {
                    for (int j = n8 % n2; j < n2; j += n2) {
                        graphics.drawImage(image, i, j, n11, n10, null);
                    }
                }
            }
        }
    }
}

