/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IteratorChain
implements Iterator {
    private Iterator[] iteratorChain = new Iterator[0];
    private int currentIteratorIndex = 0;
    private Iterator currentIterator = null;
    private Iterator lastUsedIterator = null;

    public static void main(String[] stringArray) {
        Object object;
        Object[] objectArray = new Object[]{"o11", "o12", "o13"};
        Object[] objectArray2 = new Object[]{"o21", "o22", "o23"};
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < objectArray2.length; ++i) {
            arrayList2.add(objectArray2[i]);
        }
        IteratorChain iteratorChain = new IteratorChain(new Iterator[]{arrayList.iterator(), arrayList2.iterator()});
        while (iteratorChain.hasNext()) {
            object = iteratorChain.next();
            System.out.println(object);
            if (!object.equals("o12")) continue;
            iteratorChain.remove();
        }
        System.out.println("*******");
        iteratorChain = new IteratorChain(new Iterator[]{arrayList.iterator(), arrayList2.iterator()});
        while (iteratorChain.hasNext()) {
            object = iteratorChain.next();
            System.out.println(object);
            if (!object.equals("o12")) continue;
            iteratorChain.remove();
        }
    }

    public IteratorChain() {
    }

    public IteratorChain(Iterator[] iteratorArray) {
        if (iteratorArray != null) {
            this.iteratorChain = new Iterator[iteratorArray.length];
            System.arraycopy(iteratorArray, 0, this.iteratorChain, 0, iteratorArray.length);
        }
    }

    public int size() {
        return this.iteratorChain.length;
    }

    private void updateCurrentIterator() {
        if (this.currentIterator == null) {
            if (this.iteratorChain.length == 0) {
                this.currentIterator = EmptyIterator.INSTANCE;
            } else {
                this.currentIterator = this.iteratorChain[this.currentIteratorIndex];
                ++this.currentIteratorIndex;
            }
        } else if (!this.currentIterator.hasNext() && this.currentIteratorIndex < this.iteratorChain.length) {
            this.currentIterator = this.iteratorChain[this.currentIteratorIndex];
            ++this.currentIteratorIndex;
        }
    }

    public boolean hasNext() {
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.hasNext();
    }

    public Object next() {
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.next();
    }

    public void remove() {
        if (this.currentIterator == null) {
            this.updateCurrentIterator();
        }
        this.lastUsedIterator.remove();
    }

    private static class EmptyIterator
    implements Iterator {
        private static final EmptyIterator INSTANCE = new EmptyIterator();

        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("Iterator contains no elements");
        }

        public void remove() {
            throw new IllegalStateException("Iterator contains no elements");
        }
    }
}

