/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core.html;

import com.fr.base.CodeUtils;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.html.Html;
import com.fr.base.core.html.TextHtml;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Tag
extends Html {
    private String tagName;
    private List classes;
    private Map styles;
    private Map attributes;
    private List subHtmlList;
    private List siblingHtmlList;

    public Tag() {
        this(null);
    }

    public Tag(String string) {
        this.tagName = string;
    }

    public Tag cls(String string) {
        if (this.classes == null) {
            this.classes = new ArrayList();
        }
        this.classes.add(string);
        return this;
    }

    public Tag css(String string, String string2) {
        if (this.styles == null) {
            this.styles = new HashMap();
        }
        this.styles.put(string, string2);
        return this;
    }

    public Tag css(Map map) {
        if (this.styles == null) {
            this.styles = new HashMap();
        }
        this.styles.putAll(map);
        return this;
    }

    public Tag attr(String string, String string2) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(string, string2);
        return this;
    }

    public Tag sub(Html html) {
        if (this.subHtmlList == null) {
            this.subHtmlList = new ArrayList();
        }
        this.subHtmlList.add(html);
        return this;
    }

    public Tag sub(String string) {
        return this.sub(new TextHtml(string));
    }

    public Tag sibling(Html html) {
        if (this.siblingHtmlList == null) {
            this.siblingHtmlList = new ArrayList();
        }
        this.siblingHtmlList.add(html);
        return this;
    }

    public void writeHtml(PrintWriter printWriter) {
        int n;
        int n2;
        if (this.tagName == null) {
            int n3;
            int n4 = n3 = this.subHtmlList == null ? 0 : this.subHtmlList.size();
            for (int i = 0; i < n3; ++i) {
                ((Html)this.subHtmlList.get(i)).writeHtml(printWriter);
            }
            return;
        }
        printWriter.write("<" + this.tagName);
        printWriter.write(this.classBuffer().toString());
        printWriter.write(this.styleBuffer().toString());
        printWriter.write(this.attributeBuffer().toString());
        if (this.tagName.equalsIgnoreCase("COL") && (this.subHtmlList == null || this.subHtmlList.size() == 0)) {
            printWriter.write(" />");
            return;
        }
        printWriter.write(">");
        int n5 = n2 = this.subHtmlList == null ? 0 : this.subHtmlList.size();
        for (n = 0; n < n2; ++n) {
            ((Html)this.subHtmlList.get(n)).writeHtml(printWriter);
        }
        printWriter.write("</" + this.tagName + ">");
        if (this.siblingHtmlList != null) {
            n2 = this.siblingHtmlList.size();
            for (n = 0; n < n2; ++n) {
                ((Html)this.siblingHtmlList.get(n)).writeHtml(printWriter);
            }
        }
    }

    private StringBuffer classBuffer() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.classes != null && this.classes.size() > 0) {
            stringBuffer.append(" class=\"");
            int n = this.classes.size();
            for (int i = 0; i < n - 1; ++i) {
                stringBuffer.append(this.classes.get(i));
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.classes.get(n - 1));
            stringBuffer.append('\"');
        }
        return stringBuffer;
    }

    private StringBuffer styleBuffer() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.styles != null) {
            StringBuffer stringBuffer2 = new StringBuffer();
            Iterator iterator = this.styles.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                stringBuffer2.append(entry.getKey()).append(":").append(entry.getValue()).append(";");
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer.append(" style=\"").append(stringBuffer2).append("\"");
            }
        }
        return stringBuffer;
    }

    private StringBuffer attributeBuffer() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.attributes != null) {
            Iterator iterator = this.attributes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                stringBuffer.append(" ").append(entry.getKey()).append("=\"").append(CodeUtils.attributeHtmlEncode(entry.getValue().toString())).append("\"");
            }
        }
        return stringBuffer;
    }

    public String toString() {
        return this.toHtml();
    }

    public Object clone() throws CloneNotSupportedException {
        Tag tag = (Tag)super.clone();
        tag.attributes = BaseCoreUtils.cloneMap(this.attributes);
        tag.styles = BaseCoreUtils.cloneMap(this.styles);
        return tag;
    }
}

