/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core.image4j.codec.bmp;

import com.fr.base.core.image4j.codec.bmp.InfoHeader;
import com.fr.base.core.image4j.io.LittleEndianOutputStream;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BMPEncoder {
    private BMPEncoder() {
    }

    public static void write(BufferedImage bufferedImage, File file) throws IOException {
        BMPEncoder.write(bufferedImage, new FileOutputStream(file));
    }

    public static void write(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        InfoHeader infoHeader = BMPEncoder.createInfoHeader(bufferedImage);
        int n = 0;
        IndexColorModel indexColorModel = null;
        if (infoHeader.sBitCount <= 8) {
            indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
            n = indexColorModel.getMapSize();
        }
        int n2 = 14 + infoHeader.iSize;
        int n3 = 4 * n;
        int n4 = n2 + n3;
        int n5 = 0;
        switch (infoHeader.sBitCount) {
            case 1: {
                n5 = BMPEncoder.getBytesPerLine1(infoHeader.iWidth);
                break;
            }
            case 4: {
                n5 = BMPEncoder.getBytesPerLine4(infoHeader.iWidth);
                break;
            }
            case 8: {
                n5 = BMPEncoder.getBytesPerLine8(infoHeader.iWidth);
                break;
            }
            case 24: {
                n5 = BMPEncoder.getBytesPerLine24(infoHeader.iWidth);
                break;
            }
            case 32: {
                n5 = infoHeader.iWidth * 4;
            }
        }
        int n6 = n4 + n5 * infoHeader.iHeight;
        LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(outputStream);
        BMPEncoder.writeFileHeader(n6, n4, littleEndianOutputStream);
        infoHeader.write(littleEndianOutputStream);
        if (infoHeader.sBitCount <= 8) {
            BMPEncoder.writeColorMap(indexColorModel, littleEndianOutputStream);
        }
        switch (infoHeader.sBitCount) {
            case 1: {
                BMPEncoder.write1(bufferedImage.getRaster(), littleEndianOutputStream);
                break;
            }
            case 4: {
                BMPEncoder.write4(bufferedImage.getRaster(), littleEndianOutputStream);
                break;
            }
            case 8: {
                BMPEncoder.write8(bufferedImage.getRaster(), littleEndianOutputStream);
                break;
            }
            case 24: {
                BMPEncoder.write24(bufferedImage.getRaster(), littleEndianOutputStream);
                break;
            }
            case 32: {
                BMPEncoder.write32(bufferedImage.getRaster(), bufferedImage.getAlphaRaster(), littleEndianOutputStream);
            }
        }
    }

    public static InfoHeader createInfoHeader(BufferedImage bufferedImage) {
        InfoHeader infoHeader = new InfoHeader();
        infoHeader.iColorsImportant = 0;
        infoHeader.iColorsUsed = 0;
        infoHeader.iCompression = 0;
        infoHeader.iHeight = bufferedImage.getHeight();
        infoHeader.iWidth = bufferedImage.getWidth();
        infoHeader.sBitCount = (short)bufferedImage.getColorModel().getPixelSize();
        infoHeader.iNumColors = 1 << (infoHeader.sBitCount == 32 ? 24 : (int)infoHeader.sBitCount);
        infoHeader.iImageSize = 0;
        return infoHeader;
    }

    public static void writeFileHeader(int n, int n2, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        byte[] byArray = "BM".getBytes("UTF-8");
        littleEndianOutputStream.write(byArray);
        littleEndianOutputStream.writeIntLE(n);
        littleEndianOutputStream.writeIntLE(0);
        littleEndianOutputStream.writeIntLE(n2);
    }

    public static void writeColorMap(IndexColorModel indexColorModel, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        int n = indexColorModel.getMapSize();
        for (int i = 0; i < n; ++i) {
            int n2 = indexColorModel.getRGB(i);
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            littleEndianOutputStream.writeByte(n5);
            littleEndianOutputStream.writeByte(n4);
            littleEndianOutputStream.writeByte(n3);
            littleEndianOutputStream.writeByte(0);
        }
    }

    public static int getBytesPerLine1(int n) {
        int n2 = n / 8;
        if (n2 % 4 != 0) {
            n2 = (n2 / 4 + 1) * 4;
        }
        return n2;
    }

    public static int getBytesPerLine4(int n) {
        int n2 = n / 2;
        if (n2 % 4 != 0) {
            n2 = (n2 / 4 + 1) * 4;
        }
        return n2;
    }

    public static int getBytesPerLine8(int n) {
        int n2 = n;
        if (n2 % 4 != 0) {
            n2 = (n2 / 4 + 1) * 4;
        }
        return n2;
    }

    public static int getBytesPerLine24(int n) {
        int n2 = n * 3;
        if (n2 % 4 != 0) {
            n2 = (n2 / 4 + 1) * 4;
        }
        return n2;
    }

    public static int getBitmapSize(int n, int n2, int n3) {
        int n4 = 0;
        switch (n3) {
            case 1: {
                n4 = BMPEncoder.getBytesPerLine1(n);
                break;
            }
            case 4: {
                n4 = BMPEncoder.getBytesPerLine4(n);
                break;
            }
            case 8: {
                n4 = BMPEncoder.getBytesPerLine8(n);
                break;
            }
            case 24: {
                n4 = BMPEncoder.getBytesPerLine24(n);
                break;
            }
            case 32: {
                n4 = n * 4;
            }
        }
        int n5 = n4 * n2;
        return n5;
    }

    public static void write1(Raster raster, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        int n = BMPEncoder.getBytesPerLine1(raster.getWidth());
        byte[] byArray = new byte[n];
        for (int i = raster.getHeight() - 1; i >= 0; --i) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                byArray[n2] = 0;
            }
            for (n2 = 0; n2 < raster.getWidth(); ++n2) {
                int n3 = n2 / 8;
                int n4 = n2 % 8;
                int n5 = raster.getSample(n2, i, 0);
                byArray[n3] = BMPEncoder.setBit(byArray[n3], n4, n5);
            }
            littleEndianOutputStream.write(byArray);
        }
    }

    public static void write4(Raster raster, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        int n3 = BMPEncoder.getBytesPerLine4(n);
        byte[] byArray = new byte[n3];
        for (int i = n2 - 1; i >= 0; --i) {
            int n4;
            for (n4 = 0; n4 < n3; ++n4) {
                byArray[n4] = 0;
            }
            for (n4 = 0; n4 < n; ++n4) {
                int n5 = n4 / 2;
                int n6 = n4 % 2;
                int n7 = raster.getSample(n4, i, 0);
                byArray[n5] = BMPEncoder.setNibble(byArray[n5], n6, n7);
            }
            littleEndianOutputStream.write(byArray);
        }
    }

    public static void write8(Raster raster, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        int n3 = BMPEncoder.getBytesPerLine8(n);
        for (int i = n2 - 1; i >= 0; --i) {
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                int n5 = raster.getSample(n4, i, 0);
                littleEndianOutputStream.writeByte(n5);
            }
            for (n4 = n; n4 < n3; ++n4) {
                littleEndianOutputStream.writeByte(0);
            }
        }
    }

    public static void write24(Raster raster, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        int n3 = BMPEncoder.getBytesPerLine24(n);
        for (int i = n2 - 1; i >= 0; --i) {
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                int n5 = raster.getSample(n4, i, 0);
                int n6 = raster.getSample(n4, i, 1);
                int n7 = raster.getSample(n4, i, 2);
                littleEndianOutputStream.writeByte(n7);
                littleEndianOutputStream.writeByte(n6);
                littleEndianOutputStream.writeByte(n5);
            }
            for (n4 = n * 3; n4 < n3; ++n4) {
                littleEndianOutputStream.writeByte(0);
            }
        }
    }

    public static void write32(Raster raster, Raster raster2, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        for (int i = n2 - 1; i >= 0; --i) {
            for (int j = 0; j < n; ++j) {
                int n3 = raster.getSample(j, i, 0);
                int n4 = raster.getSample(j, i, 1);
                int n5 = raster.getSample(j, i, 2);
                int n6 = raster2.getSample(j, i, 0);
                littleEndianOutputStream.writeByte(n5);
                littleEndianOutputStream.writeByte(n4);
                littleEndianOutputStream.writeByte(n3);
                littleEndianOutputStream.writeByte(n6);
            }
        }
    }

    private static byte setBit(byte by, int n, int n2) {
        by = n2 == 0 ? (byte)(by & ~(1 << 7 - n)) : (byte)(by | 1 << 7 - n);
        return by;
    }

    private static byte setNibble(byte by, int n, int n2) {
        by = (byte)(by | n2 << (1 - n) * 4);
        return by;
    }

    public static int getColorMapSize(short s) {
        int n = 0;
        if (s <= 8) {
            n = (1 << s) * 4;
        }
        return n;
    }
}

