/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core.image4j.codec.bmp;

import com.fr.base.core.image4j.io.LittleEndianInputStream;
import com.fr.base.core.image4j.io.LittleEndianOutputStream;
import java.io.IOException;

public class InfoHeader {
    public int iSize;
    public int iWidth;
    public int iHeight;
    public short sPlanes;
    public short sBitCount;
    public int iCompression;
    public int iImageSize;
    public int iXpixelsPerM;
    public int iYpixelsPerM;
    public int iColorsUsed;
    public int iColorsImportant;
    public int iNumColors;

    public InfoHeader(LittleEndianInputStream littleEndianInputStream) throws IOException {
        this.iSize = littleEndianInputStream.readIntLE();
        this.init(littleEndianInputStream, this.iSize);
    }

    public InfoHeader(LittleEndianInputStream littleEndianInputStream, int n) throws IOException {
        this.init(littleEndianInputStream, n);
    }

    protected void init(LittleEndianInputStream littleEndianInputStream, int n) throws IOException {
        this.iSize = n;
        this.iWidth = littleEndianInputStream.readIntLE();
        this.iHeight = littleEndianInputStream.readIntLE();
        this.sPlanes = littleEndianInputStream.readShortLE();
        this.sBitCount = littleEndianInputStream.readShortLE();
        this.iNumColors = (int)Math.pow(2.0, this.sBitCount);
        this.iCompression = littleEndianInputStream.readIntLE();
        this.iImageSize = littleEndianInputStream.readIntLE();
        this.iXpixelsPerM = littleEndianInputStream.readIntLE();
        this.iYpixelsPerM = littleEndianInputStream.readIntLE();
        this.iColorsUsed = littleEndianInputStream.readIntLE();
        this.iColorsImportant = littleEndianInputStream.readIntLE();
    }

    public InfoHeader() {
        this.iSize = 40;
        this.iWidth = 0;
        this.iHeight = 0;
        this.sPlanes = 1;
        this.sBitCount = 0;
        this.iNumColors = 0;
        this.iCompression = 0;
        this.iImageSize = 0;
        this.iXpixelsPerM = 0;
        this.iYpixelsPerM = 0;
        this.iColorsUsed = 0;
        this.iColorsImportant = 0;
    }

    public InfoHeader(InfoHeader infoHeader) {
        this.iColorsImportant = infoHeader.iColorsImportant;
        this.iColorsUsed = infoHeader.iColorsUsed;
        this.iCompression = infoHeader.iCompression;
        this.iHeight = infoHeader.iHeight;
        this.iWidth = infoHeader.iWidth;
        this.iImageSize = infoHeader.iImageSize;
        this.iNumColors = infoHeader.iNumColors;
        this.iSize = infoHeader.iSize;
        this.iXpixelsPerM = infoHeader.iXpixelsPerM;
        this.iYpixelsPerM = infoHeader.iYpixelsPerM;
        this.sBitCount = infoHeader.sBitCount;
        this.sPlanes = infoHeader.sPlanes;
    }

    public void write(LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        littleEndianOutputStream.writeIntLE(this.iSize);
        littleEndianOutputStream.writeIntLE(this.iWidth);
        littleEndianOutputStream.writeIntLE(this.iHeight);
        littleEndianOutputStream.writeShortLE(this.sPlanes);
        littleEndianOutputStream.writeShortLE(this.sBitCount);
        littleEndianOutputStream.writeIntLE(this.iCompression);
        littleEndianOutputStream.writeIntLE(this.iImageSize);
        littleEndianOutputStream.writeIntLE(this.iXpixelsPerM);
        littleEndianOutputStream.writeIntLE(this.iYpixelsPerM);
        littleEndianOutputStream.writeIntLE(this.iColorsUsed);
        littleEndianOutputStream.writeIntLE(this.iColorsImportant);
    }
}

