/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core.image4j.io;

public class EndianUtils {
    public static short swapShort(short s) {
        return (short)((s & 0xFF00) >> 8 | (s & 0xFF) << 8);
    }

    public static int swapInteger(int n) {
        return (n & 0xFF000000) >> 24 | (n & 0xFF0000) >> 8 | (n & 0xFF00) << 8 | (n & 0xFF) << 24;
    }

    public static long swapLong(long l) {
        return (l & 0xFF00000000000000L) >> 56 | (l & 0xFF000000000000L) >> 40 | (l & 0xFF0000000000L) >> 24 | (l & 0xFF00000000L) >> 8 | (l & 0xFF000000L) << 8 | (l & 0xFF0000L) << 24 | (l & 0xFF00L) << 40 | (l & 0xFFL) << 56;
    }

    public static float swapFloat(float f) {
        int n = Float.floatToIntBits(f);
        n = EndianUtils.swapInteger(n);
        return Float.intBitsToFloat(n);
    }

    public static double swapDouble(double d) {
        long l = Double.doubleToLongBits(d);
        l = EndianUtils.swapLong(l);
        return Double.longBitsToDouble(l);
    }
}

