/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core.image4j.io;

import com.fr.base.core.image4j.io.EndianUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianOutputStream
extends DataOutputStream {
    public LittleEndianOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeShortLE(short s) throws IOException {
        s = EndianUtils.swapShort(s);
        super.writeShort(s);
    }

    public void writeIntLE(int n) throws IOException {
        n = EndianUtils.swapInteger(n);
        super.writeInt(n);
    }

    public void writeFloatLE(float f) throws IOException {
        f = EndianUtils.swapFloat(f);
        super.writeFloat(f);
    }

    public void writeLongLE(long l) throws IOException {
        l = EndianUtils.swapLong(l);
        super.writeLong(l);
    }

    public void writeDoubleLE(double d) throws IOException {
        d = EndianUtils.swapDouble(d);
        super.writeDouble(d);
    }

    public void writeUnsignedInt(long l) throws IOException {
        int n = (int)(l >> 24);
        int n2 = (int)(l >> 16 & 0xFFL);
        int n3 = (int)(l >> 8 & 0xFFL);
        int n4 = (int)(l & 0xFFL);
        this.write(n);
        this.write(n2);
        this.write(n3);
        this.write(n4);
    }

    public void writeUnsignedIntLE(long l) throws IOException {
        int n = (int)(l >> 24);
        int n2 = (int)(l >> 16 & 0xFFL);
        int n3 = (int)(l >> 8 & 0xFFL);
        int n4 = (int)(l & 0xFFL);
        this.write(n4);
        this.write(n3);
        this.write(n2);
        this.write(n);
    }
}

