/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core.list;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import sun.misc.Cleaner;

public class MBBList
extends AbstractList {
    private File cacheFile = null;
    private MappedByteBuffer mapped_read;
    private MappedByteBuffer mapped_write;
    byte[] page;
    int pageSize = 0x2FFFFF;
    int pageoffset = 0;
    private FileChannel fc;
    private int total_size;
    int[] size_array;
    int[] index_array;
    int count = 0;

    public MBBList(File file, int n) {
        this.page = new byte[this.pageSize];
        this.size_array = new int[n];
        this.index_array = new int[n + 1];
        this.cacheFile = file;
    }

    public MBBList(File file, int n, int n2) {
        this.pageSize = n2;
        this.page = new byte[this.pageSize];
        this.size_array = new int[n];
        this.index_array = new int[n + 1];
        this.cacheFile = file;
    }

    public static void un_map(final MappedByteBuffer mappedByteBuffer) {
        if (mappedByteBuffer != null) {
            mappedByteBuffer.force();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Method method = mappedByteBuffer.getClass().getMethod("cleaner", new Class[0]);
                        method.setAccessible(true);
                        Cleaner cleaner = (Cleaner)method.invoke((Object)mappedByteBuffer, new Object[0]);
                        if (cleaner != null) {
                            cleaner.clean();
                            cleaner.clear();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return null;
                }
            });
        }
    }

    public boolean add(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (this.pageoffset + byArray.length < this.pageSize) {
                for (int i = 0; i < byArray.length; ++i) {
                    this.page[this.pageoffset++] = byArray[i];
                }
            } else {
                for (int i = 0; i < byArray.length; ++i) {
                    this.page[this.pageoffset++] = byArray[i];
                    if (this.pageoffset < this.pageSize) continue;
                    if (this.mapped_write != null) {
                        this.mapped_write.clear();
                        MBBList.un_map(this.mapped_write);
                        this.mapped_write = null;
                    }
                    this.getFileChannel();
                    this.mapped_write = this.fc.map(FileChannel.MapMode.READ_WRITE, this.fc.size(), this.pageSize);
                    this.mapped_write.put(this.page);
                    this.pageoffset = 0;
                    this.total_size += this.pageSize;
                    if (this.mapped_read == null) continue;
                    this.mapped_read.clear();
                    MBBList.un_map(this.mapped_read);
                    this.mapped_read = null;
                }
            }
            this.size_array[this.count] = byArray.length;
            this.index_array[this.count + 1] = this.index_array[this.count] + byArray.length;
            ++this.count;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return true;
    }

    public Object get(int n) {
        if (n % 10000 == 0) {
            System.out.println(n);
        }
        try {
            int n2;
            byte[] byArray = new byte[this.size_array[n]];
            int n3 = this.index_array[n] + this.size_array[n];
            int n4 = 0;
            if (this.total_size == 0) {
                int n5 = this.index_array[n];
                while (n5 < n3) {
                    byArray[n4] = this.page[n5];
                    ++n5;
                    ++n4;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return objectInputStream.readObject();
            }
            this.getFileChannel();
            if (this.mapped_read == null) {
                System.out.println("Current size is:" + this.total_size);
                this.mapped_read = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.total_size);
            }
            if ((long)n3 < this.fc.size()) {
                n2 = this.index_array[n];
                while (n2 < n3) {
                    byArray[n4] = this.mapped_read.get(n2);
                    ++n2;
                    ++n4;
                }
            } else if (n3 > this.total_size && this.index_array[n] < this.total_size) {
                n2 = this.index_array[n];
                while ((long)n2 < this.fc.size()) {
                    byArray[n4] = this.mapped_read.get(n2);
                    ++n2;
                    ++n4;
                }
                n2 = this.total_size;
                while (n2 < n3) {
                    byArray[n4] = this.page[n2 - this.total_size];
                    ++n2;
                    ++n4;
                }
            } else {
                n2 = this.index_array[n];
                while (n2 < n3) {
                    byArray[n4] = this.page[n2 - this.total_size];
                    ++n2;
                    ++n4;
                }
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.size_array = null;
        if (this.mapped_read != null) {
            this.mapped_read.clear();
            MBBList.un_map(this.mapped_read);
            this.mapped_read = null;
        }
        if (this.mapped_write != null) {
            this.mapped_write.clear();
            MBBList.un_map(this.mapped_write);
            this.mapped_write = null;
        }
        this.pageoffset = 0;
        if (this.fc != null) {
            try {
                this.fc.close();
                this.fc = null;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.page = null;
    }

    private FileChannel getFileChannel() {
        if (this.fc == null) {
            try {
                this.fc = new RandomAccessFile(this.cacheFile, "rw").getChannel();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return this.fc;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }
}

