/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core.list;

import com.fr.base.FRContext;
import com.fr.base.core.list.MBBList;
import com.fr.util.Utils;
import java.io.File;
import java.util.List;
import java.util.logging.Level;

public class MBBTable {
    private File diskDirectory = null;
    private transient List[] mbbLists = null;
    private int MEM_SIZE = FRContext.getCacheManager().getMaxMemSize();

    public MBBTable(int n, int n2) {
        this.mbbLists = new MBBList[n];
        this.diskDirectory = this.getCacheDirectory();
        int n3 = 0x2FFFFF;
        if (n > 0) {
            n3 = this.MEM_SIZE / n;
        }
        for (int i = 0; i < this.mbbLists.length; ++i) {
            String string = "MBB_Column";
            File file = new File(this.diskDirectory, string + "_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
            int n4 = 0;
            while (file.exists()) {
                file = new File(this.diskDirectory, string + "_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n4);
                ++n4;
            }
            file.deleteOnExit();
            this.mbbLists[i] = new MBBList(file, n2, n3);
        }
    }

    public void addValueAt(int n, Object object) {
        this.mbbLists[n].add(object);
    }

    public Object getValueAt(int n, int n2) {
        if (n > this.columnCount() && n >= 0) {
            FRContext.getLogger().log(Level.WARNING, "Index out of bounds");
            return null;
        }
        return this.mbbLists[n].get(n2);
    }

    public int columnCount() {
        return this.mbbLists.length;
    }

    public int rowCount() {
        return this.mbbLists[0].size();
    }

    public void clear() {
        if (this.mbbLists != null) {
            for (int i = 0; i < this.mbbLists.length; ++i) {
                if (this.mbbLists[i] == null) continue;
                this.mbbLists[i].clear();
            }
        }
        System.gc();
        if (this.diskDirectory == null || !Utils.deleteFile(this.diskDirectory)) {
            // empty if block
        }
    }

    private File getCacheDirectory() {
        if (this.diskDirectory == null) {
            this.diskDirectory = new File(FRContext.getCacheManager().getCacheDirectory(), "DATA_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
            int n = 0;
            while (this.diskDirectory.exists()) {
                this.diskDirectory = new File(FRContext.getCacheManager().getCacheDirectory(), "DATA_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n);
                ++n;
            }
            Utils.mkdirs(this.diskDirectory);
            this.diskDirectory.deleteOnExit();
        }
        return this.diskDirectory;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }
}

