/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Ascii85OutputStream
extends FilterOutputStream {
    private int line_break = 72;
    private int count = 0;
    private byte[] indata = new byte[4];
    private byte[] outdata = new byte[5];
    private int maxline = 72;
    private boolean flushed = false;
    private char terminator = (char)126;

    public Ascii85OutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void setTerminator(char c) {
        if (c < 'v' || c > '~' || c == 'z') {
            throw new IllegalArgumentException("Terminator must be 118-126 excluding z");
        }
        this.terminator = c;
    }

    public char getTerminator() {
        return this.terminator;
    }

    public void setLineLength(int n) {
        if (this.line_break > n) {
            this.line_break = n;
        }
        this.maxline = n;
    }

    public int getLineLength() {
        return this.maxline;
    }

    private final void Ascii85Tuple() {
        long l = (long)((this.indata[0] << 8 | this.indata[1] & 0xFF) << 16 | (this.indata[2] & 0xFF) << 8 | this.indata[3] & 0xFF) & 0xFFFFFFFFL;
        if (l == 0L) {
            this.outdata[0] = 122;
            this.outdata[1] = 0;
            return;
        }
        long l2 = l / 52200625L;
        this.outdata[0] = (byte)(l2 + 33L);
        l -= l2 * 52200625L;
        l2 = l / 614125L;
        this.outdata[1] = (byte)(l2 + 33L);
        l -= l2 * 614125L;
        l2 = l / 7225L;
        this.outdata[2] = (byte)(l2 + 33L);
        l -= l2 * 7225L;
        l2 = l / 85L;
        this.outdata[3] = (byte)(l2 + 33L);
        this.outdata[4] = (byte)(l % 85L + 33L);
    }

    public final void write(int n) throws IOException {
        this.flushed = false;
        this.indata[this.count++] = (byte)n;
        if (this.count < 4) {
            return;
        }
        this.Ascii85Tuple();
        for (int i = 0; i < 5 && this.outdata[i] != 0; ++i) {
            this.out.write(this.outdata[i]);
            if (--this.line_break != 0) continue;
            this.out.write(10);
            this.line_break = this.maxline;
        }
        this.count = 0;
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            if (this.count < 3) {
                this.indata[this.count++] = byArray[n + i];
                continue;
            }
            this.write(byArray[n + i]);
        }
    }

    public final void flush() throws IOException {
        if (this.flushed) {
            return;
        }
        if (this.count > 0) {
            int n;
            for (n = this.count; n < 4; ++n) {
                this.indata[n] = 0;
            }
            this.Ascii85Tuple();
            if (this.outdata[0] == 122) {
                for (n = 0; n < 5; ++n) {
                    this.outdata[n] = 33;
                }
            }
            for (n = 0; n < this.count + 1; ++n) {
                this.out.write(this.outdata[n]);
                if (--this.line_break != 0) continue;
                this.out.write(10);
                this.line_break = this.maxline;
            }
        }
        if (--this.line_break == 0) {
            this.out.write(10);
        }
        this.out.write(this.terminator);
        this.out.write(10);
        this.count = 0;
        this.line_break = this.maxline;
        this.flushed = true;
        super.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.outdata = null;
            this.indata = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.flush();
        }
        finally {
            super.finalize();
        }
    }
}

